from numpy import log

g = 9.81 # gravitational aCCelleration ms^-2
krm = 0.40 # von Kàrmàn constant


# constants for the flux-profile relationships
gammaM = 16.0
gammaH = 16.0
alphaM = 0.25
alphaH=0.5
AA = 6.1
BB = 2.5
CC = 5.3
DD = 1.1

def Lmo(ustar,thetastar,theta0=293.15):
    return ustar**2 * theta0/(krm*g*thetastar)


def funm(z,z0,Lm=None,ustar=nan,thetastar=nan):
    # help function to calculate uprofile or theta profile 
    # (may be useful in other calculations as well)
    if Lm != None:
        Lmdef = Lm
    else:
        Lmdef = Lmo(ustar,thetastar)

    return log(z/z0) - psim(z/Lmdef) + psim(z0/Lmdef)

def funh(z,z0,Lm=None,ustar=nan,thetastar=nan):
    if Lm != None:
        Lmdef = Lm
    else:
        Lmdef = Lmo(ustar,thetastar)

    return log(z/z0h) - psih(z/Lmdef) + psih(z0h/Lmdef)

def uprofile(zref,ustar,thetastar,uref,z0):
    # calculate wind profile from meteorological surface parameters
    return sign(uref)*ustar/krm*funm(z,z0,ustar=ustar,thetastar=thetastar)
def thetaprofile(zref,ustar,thetastar,uref,thetas,z0h):
    # calculate pot. temperature profile from meteorological surface parameters
    return thetas + thetastar/krm*funh(z,z0h,ustar=ustar,thetastar=thetastar)

def CM(z,z0,ustar,thetastar):
    Lm = Lmo(ustar,thetastar)
    return krm**2/funm**2
def CH(z,z0,z0h,Lm=None,ustar=nan,thetastar=nan):
    if Lm != None:
        Lmdef = Lm
    else:
        Lmdef = Lmo(ustar,thetastar)
    return krm**2/(funm*funh)

# integrated flux-profile relationship for momentum
def psim(zeta):
    if (zeta < 0):
        # unstable case 
        #   Paulson (1970) integrated flux-profile relationships derived from 
        #   Dyer (1967) /Businger (1966)
        XX=(1.-gammaM*zeta)**alphaM
        return 2.*log((1.+XX)/2.)+log((1.+XX**2.)/2.)-2.*tan(XX)+p2
    else :
        # stable case
        # Cheng and Brutsaert 2007
        return -AA*log(zeta+(1.+zeta**BB)**(1./BB))
# integrated flux-profile relationship for heat
def psih(zeta):
    if (zeta < 0):
        # unstable case 
        #   Paulson (1970) integrated flux-profile relationships derived from 
        #   Dyer (1967) /Businger (1966)
        XX=(1.-gammaH*zeta)**alphaH
        return 2.*log((1.+XX)/2.)
    else :
        # stable case
        # Cheng and Brutsaert 2005
        return -CC*log(zeta+(1.+zeta**DD)**(1./DD))

# todo: check sign with regard to cm and ch
def zetaC(z,cm,ch,u,theta,thetas,theta0=None):
    if theta0 == None:
        theta0 = thetas
    # zeta = z k g thetast / (ust**2 theta0)
    # zeta = z k g thetast ust / (ust**3 theta0)
    # zeta = z k g -ch ua (theta - thetas) / (ust**3 theta0)
    zeta = z* krm* g* ch*abs(u) *(theta - thetas) / ((cm**(0.5) *abs(u))**3 * theta0)
    return zeta

# no RSL
def zetaCRiB(cm,ch,RiB):
    # zeta = RiB * funm**2/funh
    # zeta = RiB * funm**3/(funh*funm)
    # zeta = RiB * k**3/cm**1.5/(k**2/ch)
    # zeta = RiB * k/cm**(1.5)/(1/ch)
    zeta = RiB*krm*ch/cm**1.5
    return zeta
