/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.statediagram.StateDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkState
extends SingleLineCommand2<StateDiagram> {
    public CommandLinkState() {
        super(CommandLinkState.getRegex());
    }

    static RegexConcat getRegex() {
        return new RegexConcat(new RegexLeaf("^"), CommandLinkState.getStatePattern("ENT1"), new RegexLeaf("[%s]*"), new RegexConcat(new RegexLeaf("ARROW_CROSS_START", "(x)?"), new RegexLeaf("ARROW_BODY1", "(-+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden)(?:,#\\w+|,dotted|,dashed|,bold|,hidden)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden)(?:,#\\w+|,dotted|,dashed|,bold|,hidden)*)\\])?"), new RegexLeaf("ARROW_BODY2", "(-*)"), new RegexLeaf("\\>"), new RegexLeaf("ARROW_CIRCLE_END", "(o[%s]+)?")), new RegexLeaf("[%s]*"), CommandLinkState.getStatePattern("ENT2"), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL", "(?::[%s]*([^%g]+))?"), new RegexLeaf("$"));
    }

    private static RegexLeaf getStatePattern(String string) {
        return new RegexLeaf(string, "([\\p{L}0-9_.]+|[\\p{L}0-9_.]+\\[H\\]|\\[\\*\\]|\\[H\\]|(?:==+)(?:[\\p{L}0-9_.]+)(?:==+))[%s]*(\\<\\<.*\\>\\>)?[%s]*(#\\w+)?");
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram stateDiagram, RegexResult regexResult) {
        String string = regexResult.get("ENT1", 0);
        String string2 = regexResult.get("ENT2", 0);
        IEntity iEntity = this.getEntityStart(stateDiagram, string);
        if (iEntity == null) {
            return CommandExecutionResult.error("The state " + string + " has been created in a concurrent state : it cannot be used here.");
        }
        IEntity iEntity2 = this.getEntityEnd(stateDiagram, string2);
        if (iEntity2 == null) {
            return CommandExecutionResult.error("The state " + string2 + " has been created in a concurrent state : it cannot be used here.");
        }
        if (regexResult.get("ENT1", 1) != null) {
            iEntity.setStereotype(new Stereotype(regexResult.get("ENT1", 1)));
        }
        if (regexResult.get("ENT1", 2) != null) {
            iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("ENT1", 2)));
        }
        if (regexResult.get("ENT2", 1) != null) {
            iEntity2.setStereotype(new Stereotype(regexResult.get("ENT2", 1)));
        }
        if (regexResult.get("ENT2", 2) != null) {
            iEntity2.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(regexResult.get("ENT2", 2)));
        }
        String string3 = regexResult.get("ARROW_BODY1", 0) + regexResult.get("ARROW_BODY2", 0);
        Direction direction = this.getDirection(regexResult);
        if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            string3 = "-";
        }
        int n = string3.length();
        boolean bl = regexResult.get("ARROW_CROSS_START", 0) != null;
        boolean bl2 = regexResult.get("ARROW_CIRCLE_END", 0) != null;
        LinkType linkType = new LinkType(bl2 ? LinkDecor.ARROW_AND_CIRCLE : LinkDecor.ARROW, bl ? LinkDecor.CIRCLE_CROSS : LinkDecor.NONE);
        Link link = new Link(iEntity, iEntity2, linkType, Display.getWithNewlines(regexResult.get("LABEL", 0)), n);
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        CommandLinkClass.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), link);
        stateDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private Direction getDirection(RegexResult regexResult) {
        String string = regexResult.get("ARROW_DIRECTION", 0);
        if (string != null) {
            return StringUtils.getQueueDirection(string);
        }
        return null;
    }

    private IEntity getEntityStart(StateDiagram stateDiagram, String string) {
        if (string.startsWith("[*]")) {
            return stateDiagram.getStart();
        }
        if (string.equalsIgnoreCase("[H]")) {
            return stateDiagram.getHistorical();
        }
        if (string.endsWith("[H]")) {
            return stateDiagram.getHistorical(Code.of(string.substring(0, string.length() - 3)));
        }
        if (string.startsWith("=") && string.endsWith("=")) {
            string = this.removeEquals(string);
            return stateDiagram.getOrCreateLeaf(Code.of(string), LeafType.SYNCHRO_BAR, null);
        }
        if (!stateDiagram.checkConcurrentStateOk(Code.of(string))) {
            return null;
        }
        return stateDiagram.getOrCreateLeaf(Code.of(string), null, null);
    }

    private String removeEquals(String string) {
        while (string.startsWith("=")) {
            string = string.substring(1);
        }
        while (string.endsWith("=")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private IEntity getEntityEnd(StateDiagram stateDiagram, String string) {
        if (string.startsWith("[*]")) {
            return stateDiagram.getEnd();
        }
        if (string.endsWith("[H]")) {
            return stateDiagram.getHistorical(Code.of(string.substring(0, string.length() - 3)));
        }
        if (string.startsWith("=") && string.endsWith("=")) {
            string = this.removeEquals(string);
            return stateDiagram.getOrCreateLeaf(Code.of(string), LeafType.SYNCHRO_BAR, null);
        }
        if (!stateDiagram.checkConcurrentStateOk(Code.of(string))) {
            return null;
        }
        return stateDiagram.getOrCreateLeaf(Code.of(string), null, null);
    }
}

