/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;

abstract class Arrow
extends GraphicalElement
implements InGroupable {
    private final Skin skin;
    private final Component arrowComponent;
    private double paddingArrowHead = 0.0;
    private double maxX;
    private final Url url;

    public void setMaxX(double d) {
        if (this.maxX != 0.0) {
            throw new IllegalStateException();
        }
        this.maxX = d;
    }

    protected final double getMaxX() {
        if (this.maxX == 0.0) {
            // empty if block
        }
        return this.maxX;
    }

    public abstract double getActualWidth(StringBounder var1);

    Arrow(double d, Skin skin, Component component, Url url) {
        super(d);
        this.skin = skin;
        this.arrowComponent = component;
        this.url = url;
    }

    protected Url getUrl() {
        return this.url;
    }

    protected final void startUrl(UGraphic uGraphic) {
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
    }

    protected final void endUrl(UGraphic uGraphic) {
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    public abstract int getDirection(StringBounder var1);

    protected Skin getSkin() {
        return this.skin;
    }

    protected final Component getArrowComponent() {
        return this.arrowComponent;
    }

    public double getArrowOnlyWidth(StringBounder stringBounder) {
        return this.getPreferredWidth(stringBounder);
    }

    public abstract double getArrowYStartLevel(StringBounder var1);

    public abstract double getArrowYEndLevel(StringBounder var1);

    public abstract LivingParticipantBox getParticipantAt(StringBounder var1, NotePosition var2);

    protected final double getPaddingArrowHead() {
        return this.paddingArrowHead;
    }

    protected final void setPaddingArrowHead(double d) {
        this.paddingArrowHead = d;
    }

    public final double getMargin() {
        return 5.0;
    }
}

