/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class UHorizontalLine
implements UShape {
    private final double skipAtStart;
    private final double skipAtEnd;
    private final TextBlock title;
    private final boolean blankTitle;
    private final char style;

    private UHorizontalLine(double d, double d2, TextBlock textBlock, boolean bl, char c) {
        this.skipAtEnd = d2;
        this.skipAtStart = d;
        this.title = textBlock;
        this.blankTitle = bl;
        this.style = c;
    }

    public static UHorizontalLine infinite(double d, double d2, char c) {
        return new UHorizontalLine(d, d2, null, false, c);
    }

    public static UHorizontalLine infinite(double d, double d2, TextBlock textBlock, char c) {
        return new UHorizontalLine(d, d2, textBlock, false, c);
    }

    public boolean isDouble() {
        return this.style == '=';
    }

    public void drawLineInternal(UGraphic uGraphic, Stencil stencil, double d, UStroke uStroke) {
        stencil = this.addSkip(stencil);
        UStroke uStroke2 = this.style == '\u0000' ? uStroke : this.getStroke();
        UGraphic uGraphic2 = uGraphic.apply(uStroke2);
        if (this.title == null) {
            this.drawHLine(stencil, d, uGraphic2);
            return;
        }
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        this.drawHLine(UHorizontalLine.firstHalf(stencil, dimension2D.getWidth()), d, uGraphic2);
        double d2 = stencil.getStartingX(uGraphic.getStringBounder(), d);
        double d3 = stencil.getEndingX(uGraphic.getStringBounder(), d);
        this.drawTitleInternal(uGraphic, d2, d3, d, false);
        this.drawHLine(UHorizontalLine.secondHalf(stencil, dimension2D.getWidth()), d, uGraphic2);
    }

    private Stencil addSkip(final Stencil stencil) {
        return new Stencil(){

            public double getStartingX(StringBounder stringBounder, double d) {
                return stencil.getStartingX(stringBounder, d) + UHorizontalLine.this.skipAtStart;
            }

            public double getEndingX(StringBounder stringBounder, double d) {
                return stencil.getEndingX(stringBounder, d) - UHorizontalLine.this.skipAtEnd;
            }
        };
    }

    private static Stencil firstHalf(final Stencil stencil, final double d) {
        return new Stencil(){

            public double getStartingX(StringBounder stringBounder, double d2) {
                return stencil.getStartingX(stringBounder, d2);
            }

            public double getEndingX(StringBounder stringBounder, double d5) {
                double d2 = stencil.getStartingX(stringBounder, d5);
                double d3 = stencil.getEndingX(stringBounder, d5);
                double d4 = (d3 - d2 - d) / 2.0;
                return d2 + d4;
            }
        };
    }

    private static Stencil secondHalf(final Stencil stencil, final double d) {
        return new Stencil(){

            public double getStartingX(StringBounder stringBounder, double d5) {
                double d2 = stencil.getStartingX(stringBounder, d5);
                double d3 = stencil.getEndingX(stringBounder, d5);
                double d4 = (d3 - d2 - d) / 2.0;
                return d3 - d4;
            }

            public double getEndingX(StringBounder stringBounder, double d2) {
                return stencil.getEndingX(stringBounder, d2);
            }
        };
    }

    private void drawHLine(Stencil stencil, double d, UGraphic uGraphic) {
        UHorizontalLine.drawSimpleHline(uGraphic, stencil, d);
        if (this.style == '=') {
            UHorizontalLine.drawSimpleHline(uGraphic, stencil, d + 2.0);
        }
    }

    private static void drawSimpleHline(UGraphic uGraphic, Stencil stencil, double d) {
        double d2 = stencil.getStartingX(uGraphic.getStringBounder(), d);
        double d3 = stencil.getEndingX(uGraphic.getStringBounder(), d);
        uGraphic.apply(new UTranslate(d2, d)).draw(new ULine(d3 - d2, 0.0));
    }

    public void drawTitleInternal(UGraphic uGraphic, double d, double d2, double d3, boolean bl) {
        if (this.title == null || this.blankTitle) {
            return;
        }
        double d4 = d2 - d;
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d5 = (d4 - dimension2D.getWidth()) / 2.0;
        double d6 = d + d5;
        double d7 = d3 - dimension2D.getHeight() / 2.0 - 0.5;
        uGraphic = uGraphic.apply(new UTranslate(d6, d7));
        if (bl) {
            uGraphic.apply(this.getStroke()).draw(new URectangle(dimension2D));
        }
        this.title.drawU(uGraphic);
    }

    public void drawMe(UGraphic uGraphic) {
        uGraphic.draw(this);
    }

    public UStroke getStroke() {
        if (this.style == '\u0000') {
            throw new IllegalStateException();
        }
        if (this.style == '=') {
            return new UStroke();
        }
        if (this.style == '.') {
            return new UStroke(1.0, 2.0, 1.0);
        }
        if (this.style == '-') {
            return new UStroke();
        }
        return new UStroke(1.5);
    }
}

