import random
from .Square import Square

class Board:
    def __init__(self,x,y,generationMode=None):
        """
        Create a new board with a (width,height) = (x,y)
        For generating the bombs you can choose a specific mode. You can
        generate them later.
        """
        self.group = []
        for i in range(0,y):
            row = []
            for j in range(0,x):
                p=Square()
                row.append(p)
            self.group.append(row)

    def __str__(self):
        x=len(self.group[0])
        y=len(self.group)
        n=''
        n+= '   '
        for item in range(1,x+1):
            n+= '%-3d' %item
        n+= 'X\n'
        count=1
        for item in self.group:
            n+= '%-3d'% count
            for element in item:
                n+= '%-3s' %str(element)
            n+='\n'
            count +=1
        n+='Y'
        return n

    def set_visible(self,x,y):
        """Set that point visibility to True"""
        self[y-1][x-1].visible= True

    def allvisib(self):
        """Set the visibility of all points to True"""
        for item in self.group:
            for element in item:
                element.visible = True

    def bombState(self,x,y):
        return self[y-1][x-1].bomb

    def visibleState(self,x,y):
        return self[y-1][x-1].visible

    def generate(self,percent):
        """Generate bombs in ~ percent of points"""
        for item in self.group:
            for element in item:
                if random.randint(1,100) in range(0,int(percent)):
                    element.bomb = True
                else :
                    pass

    def bpercent(self):
        """Return the percent of bombs in the board"""
        count = 0
        for item in self.group:
            for element in item:
                if element.bomb == True:
                    count+=1
                else:
                    pass
        percent = 100*float(count)/(len(self.group)*len(self[0])) 
        return percent

    def nclear(self):
        """Returns the number of points without bombs"""
        count = 0
        for item in self.group:
            for element in item:
                if  not element.bomb:
                    count +=1
                else:
                    pass
        return count

    def clear(self):
        """Se all the point to no visible and no bomb"""
        for item in self.group:
            for element in item:
                element.reset()

    def __getitem__(self,index):
        return self.group[index]

    def __len__(self):
        return len(self[0])
        
    def nPoints(self):
        """Number of points in the board"""
        return self.y_size * self.x_size

    @property
    def x_size(self):
        return len(self)
    @property
    def y_size(self):
        return len(self[0])
        
    def nHiddenEmpties(self):
        """Number of points without bombs that are still visible"""
        nHidden = 0
        for row in self:
            for point in row:
                if not point.bomb and not point.visible:
                        nHidden += 1
        return nHidden
    def nHiddenBombs(self):
        nHidden = 0
        for row in self:
            for point in row:
                if point.bomb and not point.visible:
                        nHidden += 1
        return nHidden
    def ended(self):
        if self.nHiddenEmpties() == 0 or self.nHiddenBombs() == 0:
            return True
        else:
            False
