from .Board import Board

#Some constants:
ALREADY_CHOSEN="ALREADY_CHOSEN"
BOMB="BOMB"
EMPTY="EMPTY"
WRONG_COORDINATE="WRONG_COORDINATE"

class Game(object):
	def __init__(self):
		self.victory = True
		self.rounds = 0
	def setBoard(self, x, y, level=None):
		self.board = Board(x,y)
		self.size = [x, y]
		if level:
			self.setLevel(level)
	def setLevel(self, level):
		self.board.generate(20*level)
	def chooseSquare(self,x,y):
		"""user choosed that square"""
		board = self.board
		if x>board.x_size or y>board.y_size:
			return WRONG_COORDINATE
		if not board.visibleState(x, y):
			board.set_visible(x, y)
			if board.bombState(x,y):
				self.victory = False
				return BOMB
			else:
				self.rounds += 1
				return EMPTY
		else:
			return ALREADY_CHOSEN
	def ended(self):
		"""Is the game finished?"""
		return self.board.ended()
		
class ConsoleGame(Game):
	def askSizeAndLevel(self):
		print("Set the size of the board")
		x = int(input("X size: "))
		y = int(input("Y size: "))
		level = float(input("Select the difficulty:\n1-Easy\n2-Medium\n3-Difficult\nLevel: "))
		self.setBoard(x, y, level)
	def askNextMove(self):
		x = int(input("X: "))
		y = int(input("Y: "))
		return x, y

	def nextMove(self, message=None):
		self.render(message)
		x, y = self.askNextMove()
		print(x,y)
		res = self.chooseSquare(x,y)
		if res == ALREADY_CHOSEN:
			return self.nextMove("{}, {} had already been selected".format(x,y))
		elif res == WRONG_COORDINATE:
			return self.nextMove("Wrong coordinate")
		else:
			return res
		
	def clear(self):
		print("\n"* 20) #Find a better system
		
	def render(self, message=None):
		self.clear()
		print(self.board)
		print("Round:",self.rounds)
		if message:
			print(message)
		
	def main(self):
		print("Start game")
		self.askSizeAndLevel()
		while not self.ended():
			res = self.nextMove("Select")
			if res == BOMB:
				self.render("There is a bomb in that point")
				break
		if self.victory:
			msg = "Game finished, you won"
		else:
			msg = "You lose"
		self.render(msg)
