# campagne/plugs/campagne.py
#
#

""" the thing to resolve. """

## IMPORTS

from core.utils import a_time, nr_days
from core.object import Object
from core.looper import Looper
from core import kernel

## basic imports

import time
import logging
import random
import datetime

## SuicideWarnLoop

pogingenjaar = 14000 # + 7000
pogingendag = pogingenjaar / 365.0
pogingenuur = pogingendag / 24.0
pogingenmin = pogingenuur / 60.0
geslaagdjaar = 1700
geslaagddag = geslaagdjaar / 365.0
geslaagduur = geslaagddag /  24.0
geslaagdmin = geslaagduur / 60.0
counter = 0
startdate = "2012-09-13 00:00:00"
starttime = a_time(startdate)

url = "http://pypi.python.org/pypi/ministerclaim"
tags = ["#cda", "#pvda", "#d66", "#vvd", "#groenlinks", "#pvv", "#pvdd", "#ministernederland", "#igz", "#vws"]
kamer = [
              "@leondejong", "@SvVeldhoven", "@afke1", "@PaulusJansenSP", "@marikopeters", "@hansspekman", "@JhimvanBemmel",  "@FarshadBashir",
              "@NineKooiman", "@agneswolbert", "@tamara_venrooy", " @a_mulder", "@fatmad66", "@bgdeboer", "@GerKoopmans", "@SjoeraDikkers", "@attjekuiken",
              "@KGFerrier", "@estherouwehand", "@elbertdijkgraaf", "@helmanepperus", "@MvanToorenburg", "@EwoutIrrgang", "@PieterOmtzigt", "@vanHijum",
              "@henkjanormel", "@ellyblanksma", "@TjeerdVD", "@sharon_dijksma",  "@adkoppejan", "@GroenLiesbeth",
              "@JackdeVries", "@piadijkstra", "@mariettehamer", "@TonElias", "@jesseklaver", "@SabineUitslag", "@VanBijsterveldt", "@HeroBrinkman", 
              "@JacquesMonasch", "@KeesVee", "@harryvandesp",
             ]

prevpogingen = 0
prevgeslaagd = 0
lastpoging = ""
lastsuicide = ""

def campagne(*args, **kwargs):
    global counter, prevpogingen, prevgeslaagd, lastpoging, lastsuicide
    counter += 1
    timediff = time.time() - starttime
    aantalmin = timediff / 60.0
    pogingen = int(aantalmin  * pogingenmin)
    geslaagd = int(aantalmin  * geslaagdmin)
    tag = random.choice(tags)
    time_diff = float(time.time() - starttime)
    days = nr_days(time_diff)
    txt = "POGING nummer %s %s (%s days)" % (pogingen, url, days) 
    if txt != lastpoging:
        kernel.announce(txt)
        lastpoging = txt
    txt = "SUICIDE nummer %s %s (%s days)" % (geslaagd, url, days) 
    if txt != lastsuicide:
        kernel.announce(txt)
        lastsuicide = txt

kernel.cmnds.register("campagne", campagne)

## campagne init

def init(*args, **kwargs):
    global kernel
    camp = Looper(campagne, 1200)
    kernel.run.campagne = camp
    kernel.workers.put(camp.start)
