from tornado import netutil
from tornado.httpserver import HTTPServer

from minsol import Error as base_Error
from minsol import MultiProcService


class SocketService(MultiProcService):
    def init_sockets(self):
        raise NotImplementedError

    def init_socket_server(self, io_loop=None, ssl_options=None):
        raise NotImplementedError

    def run(self, io_loop=None):
        MultiProcService.run(self)

        self.init_sockets()
        self.init_socket_server(io_loop=io_loop)

        self.socket_server.start(num_processes=self.config["num_processes"])
        self.socket_server.add_sockets(self.sockets)

    def stop(self):
        from tornado.ioloop import IOLoop

        self.socket_server.stop()
        IOLoop.instance().stop()


class TCPSocketService(SocketService):
    def init_sockets(self):
        self.sockets = netutil.bind_sockets(
            self.config["port"], self.config["address"])


class UNIXSocketService(SocketService):
    def init_sockets(self):
        self.sockets = [netutil.bind_unix_socket(self.config["socket_path"])]


class HTTPService(TCPSocketService):

    def init(self, application, **kwargs):
        self.application = application

    def init_socket_server(self, io_loop=None):
        self.socket_server = HTTPServer(self.application, io_loop=io_loop)


class Error(base_Error):
    pass
