#!/usr/bin/env python3

"""
Directory : mistool
Name      : url_use
Version   : 2012.08
Author    : Christophe BAL
Mail      : projetmbc@gmail.com

This script proposes some useful functions to manipulate urls.
"""

import urllib.parse
import urllib.request


# ------------------------- #
# -- FOR ERRORS TO RAISE -- #
# ------------------------- #

class UrlUseError(ValueError):
    """
Base class for errors in the ``url_use`` module of the package ``mistool``.
    """
    pass


# ---------------- #
# -- FORMATTING -- #
# ---------------- #

CHAR_TO_KEEP = "/:#&?="

def escape(url):
    """
This function escapes no ASCII characters in urls. For example,
``escape("http://www.vivaespaña.com/camión/")`` is equal to
``http://www.vivaespa%C3%B1a.com/cami%C3%B3n/``.

The function uses the global string ``CHAR_TO_KEEP`` which contains the
characters that must not be escaped : ``"/:#&?="``.
    """
    return urllib.parse.quote(
        string = url,
        safe   = CHAR_TO_KEEP
    )


# ------------- #
# -- TESTING -- #
# ------------- #

def test(
    url,
    timeout = -1
):
    """
This function try to open the url given in the variable ``url`` so as to know if
the url is a real one. If the connection works ``True`` is returned, if not that
is ``False`` which is sent.

There is one optional argument ``timeout`` to indicate an upper bound in seconds
for the whole duration of the test. By default, this variable is equal to
``(-1)`` which indicates no upper bound.
    """
    try:
        if timeout == -1:
            urllib.request.urlopen(url)

        else:
            urllib.request.urlopen(
                url = url,
                timeout = timeout
            )

        return True

    except urllib.error.URLError as e:
        ...

    return False
