#!/usr/bin/env python3

# The following ugly variables were automatically build.

__ALL_LANGS = [
    'af_ZA',
    'be_BY',
    'bg_BG',
    'ca_ES',
    'cs_CZ',
    'da_DK',
    'de_AT',
    'de_CH',
    'de_DE',
    'el_GR',
    'en_AU',
    'en_CA',
    'en_GB',
    'en_IE',
    'en_NZ',
    'en_US',
    'es_ES',
    'et_EE',
    'eu_ES',
    'fi_FI',
    'fr_BE',
    'fr_CA',
    'fr_CH',
    'fr_FR',
    'he_IL',
    'hr_HR',
    'hu_HU',
    'is_IS',
    'it_CH',
    'it_IT',
    'ja_JP',
    'ko_KR',
    'lt_LT',
    'nl_BE',
    'nl_NL',
    'no_NO',
    'pl_PL',
    'pt_BR',
    'pt_PT',
    'ro_RO',
    'ru_RU',
    'sk_SK',
    'sl_SI',
    'sv_SE',
    'tr_TR',
    'uk_UA',
    'zh_CN',
    'zh_HK',
    'zh_TW'
]

__POINTERS = [
    ['пн', 'вт', 'ср', 'чт', 'пт', 'сб', 'вс'],
    ['Pts', 'Sal', 'Çar', 'Per', 'Cum', 'Cts', 'Paz'],
    ['Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam', 'Dim'],
    ['Ma', 'Ti', 'Ke', 'To', 'Pe', 'La', 'Su'],
    ['Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb', 'Dom'],
    ['Lun', 'Mar', 'Mer', 'Gio', 'Ven', 'Sab', 'Dom'],
    ['E', 'T', 'K', 'N', 'R', 'L', 'P'],
    ['ma', 'di', 'wo', 'do', 'vr', 'za', 'zo'],
    ['man', 'tir', 'ons', 'tor', 'fre', 'lør', 'søn'],
    ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
    ['Δευ', 'Τρι', 'Τετ', 'Πεμ', 'Παρ', 'Σαβ', 'Κυρ'],
    ['пн', 'аў', 'ср', 'чц', 'пт', 'сб', 'нд'],
    ['pon', 'wto', 'śro', 'czw', 'ptk', 'sob', 'ndz'],
    ['Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa', 'So'],
    ['dil', 'dim', 'dmc', 'dij', 'div', 'dis', 'diu'],
    ['Hét', 'Ked', 'Sze', 'Csü', 'Pén', 'Szo', 'Vas'],
    ['月', '火', '水', '木', '金', '土', '日'],
    ['Pr', 'An', 'Tr', 'Kt', 'Pn', 'Št', 'Sk'],
    ['pon', 'tor', 'sre', 'čet', 'pet', 'sob', 'ned'],
    ['lun', 'mar', 'mié', 'jue', 'vie', 'sáb', 'dom'],
    ['Пн', 'Вт', 'Ср', 'Чт', 'Пт', 'Сб', 'Нд'],
    ['mán', 'þri', 'mið', 'fim', 'fös', 'lau', 'sun'],
    ['一', '二', '三', '四', '五', '六', '日'],
    ['Po', 'Ut', 'Sr', 'Če', 'Pe', 'Su', 'Ne'],
    ['Man', 'Tir', 'Ons', 'Tor', 'Fre', 'Lør', 'Søn'],
    ['월', '화', '수', '목', '금', '토', '일'],
    ['po', 'út', 'st', 'čt', 'pá', 'so', 'ne'],
    ['po', 'ut', 'st', 'št', 'pi', 'so', 'ne'],
    ['Lun', 'Mar', 'Mie', 'Joi', 'Vin', 'Sâm', 'Dum'],
    ["ב'", "ג'", "ד'", "ה'", "ו'", "ש'", "א'"],
    ['пн', 'вт', 'ср', 'чт', 'пт', 'сб', 'нд'],
    ['Mån', 'Tis', 'Ons', 'Tor', 'Fre', 'Lör', 'Sön'],
    ['al.', 'as.', 'az.', 'og.', 'or.', 'lr.', 'ig.'],
    ['янв', 'фев', 'мар', 'апр', 'май', 'июн', 'июл', 'авг', 'сен', 'окт', 'ноя', 'дек'],
    ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara'],
    ['jan', 'fév', 'mar', 'avr', 'mai', 'jui', 'jul', 'aoû', 'sep', 'oct', 'nov', 'déc'],
    ['Tam', 'Hel', 'Maa', 'Huh', 'Tou', 'Kes', 'Hei', 'Elo', 'Syy', 'Lok', 'Mar', 'Jou'],
    ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
    ['Gen', 'Feb', 'Mar', 'Apr', 'Mag', 'Giu', 'Lug', 'Ago', 'Set', 'Ott', 'Nov', 'Dic'],
    ['jaan', 'veebr', 'märts', 'apr', 'mai', 'juuni', 'juuli', 'aug', 'sept', 'okt', 'nov', 'dets'],
    ['jan', 'feb', 'mrt', 'apr', 'mei', 'jun', 'jul', 'aug', 'sep', 'okt', 'nov', 'dec'],
    ['jan', 'feb', 'mar', 'apr', 'mai', 'jun', 'jul', 'aug', 'sep', 'okt', 'nov', 'des'],
    ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
    ['Ιαν', 'Φεβ', 'Μαρ', 'Απρ', 'Μαϊ', 'Ιον', 'Ιολ', 'Αυγ', 'Σεπ', 'Οκτ', 'Νοε', 'Δεκ'],
    ['сту', 'лют', 'сак', 'кра', 'тра', 'чэр', 'ліп', 'жні', 'вер', 'кас', 'ліс', 'сне'],
    ['sty', 'lut', 'mar', 'kwi', 'maj', 'cze', 'lip', 'sie', 'wrz', 'paź', 'lis', 'gru'],
    ['Jan', 'Feb', 'Mär', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dez'],
    ['gen', 'feb', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'oct', 'nov', 'des'],
    ['Jan', 'Feb', 'Már', 'Ápr', 'Máj', 'Jún', 'Júl', 'Aug', 'Sze', 'Okt', 'Nov', 'Dec'],
    ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
    ['Sau', 'Vas', 'Kov', 'Bal', 'Geg', 'Bir', 'Lie', 'Rgp', 'Rgs', 'Spa', 'Lap', 'Grd'],
    ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'avg', 'sep', 'okt', 'nov', 'dec'],
    ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep', 'oct', 'nov', 'dic'],
    ['Яну', 'Фев', 'Мар', 'Апр', 'Май', 'Юни', 'Юли', 'Авг', 'Сеп', 'Окт', 'Нов', 'Дек'],
    ['jan', 'feb', 'mar', 'apr', 'maí', 'jún', 'júl', 'ágú', 'sep', 'okt', 'nóv', 'des'],
    ['Sij', 'Vel', 'Ožu', 'Tra', 'Svi', 'Lip', 'Srp', 'Kol', 'Ruj', 'Lis', 'Stu', 'Pro'],
    ['Jan', 'Feb', 'Mar', 'Apr', 'Maj', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'],
    ['led', 'úno', 'bře', 'dub', 'kvě', 'črv', 'čvc', 'srp', 'zář', 'říj', 'lis', 'pro'],
    ['jan', 'feb', 'mar', 'apr', 'máj', 'jún', 'júl', 'aug', 'sep', 'okt', 'nov', 'dec'],
    ['Ian', 'Feb', 'Mar', 'Apr', 'Mai', 'Iun', 'Iul', 'Aug', 'Sep', 'Oct', 'Noi', 'Dec'],
    ['ינו', 'פבר', 'מרץ', 'אפר', 'מאי', 'יונ', 'יול', 'אוג', 'ספט', 'אוק', 'נוב', 'דצמ'],
    ['січ', 'лют', 'бер', 'кві', 'тра', 'чер', 'лип', 'сер', 'вер', 'жов', 'лис', 'гру'],
    ['Urt', 'Ots', 'Mar', 'Apr', 'Mai', 'Eka', 'Uzt', 'Abu', 'Ira', 'Urr', 'Aza', 'Abe'],
    ['понедельник', 'вторник', 'среда', 'четверг', 'пятница', 'суббота', 'воскресенье'],
    ['Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi', 'Pazar'],
    ['Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi', 'Dimanche'],
    ['Maanantai', 'Tiistai', 'Keskiviikko', 'Torstai', 'Perjantai', 'Lauantai', 'Sunnuntai'],
    ['Segunda Feira', 'Terça Feira', 'Quarta Feira', 'Quinta Feira', 'Sexta Feira', 'Sábado', 'Domingo'],
    ['Lunedì', 'Martedì', 'Mercoledì', 'Giovedì', 'Venerdì', 'Sabato', 'Domenica'],
    ['esmaspäev', 'teisipäev', 'kolmapäev', 'neljapäev', 'reede', 'laupäev', 'pühapäev'],
    ['maandag', 'dinsdag', 'woensdag', 'donderdag', 'vrijdag', 'zaterdag', 'zondag'],
    ['mandag', 'tirsdag', 'onsdag', 'torsdag', 'fredag', 'lørdag', 'søndag'],
    ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'],
    ['Δευτέρα', 'Τρίτη', 'Τετάρτη', 'Πέμπτη', 'Παρασκευή', 'Σάββατο', 'Κυριακή'],
    ['панядзелак', 'аўторак', 'серада', 'чацвер', 'пятніца', 'субота', 'нядзеля'],
    ['poniedziałek', 'wtorek', 'środa', 'czwartek', 'piątek', 'sobota', 'niedziela'],
    ['Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag', 'Sonntag'],
    ['dilluns', 'dimarts', 'dimecres', 'dijous', 'divendres', 'dissabte', 'diumenge'],
    ['Hétfő', 'Kedd', 'Szerda', 'Csütörtök', 'Péntek', 'Szombat', 'Vasárnap'],
    ['月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日', '日曜日'],
    ['Pirmadienis', 'Antradienis', 'Trečiadienis', 'Ketvirtadienis', 'Penktadienis', 'Šeštadienis', 'Sekmadienis'],
    ['ponedeljek', 'torek', 'sreda', 'četrtek', 'petek', 'sobota', 'nedelja'],
    ['lunes', 'martes', 'miércoles', 'jueves', 'viernes', 'sábado', 'domingo'],
    ['Понеделник', 'Вторник', 'Сряда', 'Четвъртък', 'Петък', 'Събота', 'Неделя'],
    ['mánudagur', 'þriðjudagur', 'miðvikudagur', 'fimmtudagur', 'föstudagur', 'laugardagur', 'sunnudagur'],
    ['周一', '周二', '周三', '周四', '周五', '周六', '周日'],
    ['Ponedjeljak', 'Utorak', 'Srijeda', 'Četvrtak', 'Petak', 'Subota', 'Nedjelja'],
    ['Mandag', 'Tirsdag', 'Onsdag', 'Torsdag', 'Fredag', 'Lørdag', 'Søndag'],
    ['월요일', '화요일', '수요일', '목요일', '금요일', '토요일', '일요일'],
    ['pondělí', 'úterý', 'středa', 'čtvrtek', 'pátek', 'sobota', 'neděle'],
    ['pondelok', 'utorok', 'streda', 'štvrtok', 'piatok', 'sobota', 'nedeľa'],
    ['Luni', 'Marţi', 'Miercuri', 'Joi', 'Vineri', 'Sâmbătă', 'Duminică'],
    ['שני', 'שלישי', 'רביעי', 'חמישי', 'שישי', 'שבת', 'ראשון'],
    ['понеділок', 'вівторок', 'середа', 'четвер', "п'ятниця", 'субота', 'неділя'],
    ['星期一', '星期二', '星期三', '星期四', '星期五', '星期六', '星期日'],
    ['Måndag', 'Tisdag', 'Onsdag', 'Torsdag', 'Fredag', 'Lördag', 'Söndag'],
    ['astelehena', 'asteartea', 'asteazkena', 'osteguna', 'ostirala', 'larunbata', 'igandea'],
    ['января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря'],
    ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz', 'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık'],
    ['janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'],
    ['Tammikuu', 'Helmikuu', 'Maaliskuu', 'Huhtikuu', 'Toukokuu', 'Kesäkuu', 'Heinäkuu', 'Elokuu', 'Syyskuu', 'Lokakuu', 'Marraskuu', 'Joulukuu'],
    ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
    ['Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio', 'Giugno', 'Luglio', 'Agosto', 'Settembre', 'Ottobre', 'Novembre', 'Dicembre'],
    ['jaanuar', 'veebruar', 'märts', 'aprill', 'mai', 'juuni', 'juuli', 'august', 'september', 'oktoober', 'november', 'detsember'],
    ['januari', 'februari', 'maart', 'april', 'mei', 'juni', 'juli', 'augustus', 'september', 'oktober', 'november', 'december'],
    ['januar', 'februar', 'mars', 'april', 'mai', 'juni', 'juli', 'august', 'september', 'oktober', 'november', 'desember'],
    ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
    ['Ιανουαρίου', 'Φεβρουαρίου', 'Μαρτίου', 'Απριλίου', 'Μαΐου', 'Ιουνίου', 'Ιουλίου', 'Αυγούστου', 'Σεπτεμβρίου', 'Οκτωβρίου', 'Νοεμβρίου', 'Δεκεμβρίου'],
    ['студзеня', 'лютага', 'сакавіка', 'красавіка', 'траўня', 'чэрвеня', 'ліпеня', 'жніўня', 'верасня', 'кастрычніка', 'лістапада', 'снежня'],
    ['stycznia', 'lutego', 'marca', 'kwietnia', 'maja', 'czerwca', 'lipca', 'sierpnia', 'września', 'października', 'listopada', 'grudnia'],
    ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
    ['gener', 'febrer', 'març', 'abril', 'maig', 'juny', 'juliol', 'agost', 'setembre', 'octubre', 'novembre', 'desembre'],
    ['Január', 'Február', 'Március', 'Április', 'Május', 'Június', 'Július', 'Augusztus', 'Szeptember', 'Október', 'November', 'December'],
    ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
    ['sausio', 'vasario', 'kovo', 'balandžio', 'gegužės', 'birželio', 'liepos', 'rugpjūčio', 'rugsėjo', 'spalio', 'lapkričio', 'gruodžio'],
    ['januar', 'februar', 'marec', 'april', 'maj', 'junij', 'julij', 'avgust', 'september', 'oktober', 'november', 'december'],
    ['Jänner', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
    ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
    ['Януари', 'Февруари', 'Март', 'Април', 'Май', 'Юни', 'Юли', 'Август', 'Септември', 'Октомври', 'Ноември', 'Декември'],
    ['janúar', 'febrúar', 'mars', 'apríl', 'maí', 'júní', 'júlí', 'ágúst', 'september', 'október', 'nóvember', 'desember'],
    ['Siječanj', 'Veljača', 'Ožujak', 'Travanj', 'Svibanj', 'Lipanj', 'Srpanj', 'Kolovoz', 'Rujan', 'Listopad', 'Studeni', 'Prosinac'],
    ['Januar', 'Februar', 'Marts', 'April', 'Maj', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'December'],
    ['1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월', '9월', '10월', '11월', '12월'],
    ['ledna', 'února', 'března', 'dubna', 'května', 'června', 'července', 'srpna', 'září', 'října', 'listopadu', 'prosince'],
    ['január', 'február', 'marec', 'apríl', 'máj', 'jún', 'júl', 'august', 'september', 'október', 'november', 'december'],
    ['Ianuarie', 'Februarie', 'Martie', 'Aprilie', 'Mai', 'Iunie', 'Iulie', 'August', 'Septembrie', 'Octombrie', 'Noiembrie', 'Decembrie'],
    ['ינואר', 'פברואר', 'מרץ', 'אפריל', 'מאי', 'יוני', 'יולי', 'אוגוסט', 'ספטמבר', 'אוקטובר', 'נובמבר', 'דצמבר'],
    ['січня', 'лютого', 'березня', 'квітня', 'травня', 'червня', 'липня', 'серпня', 'вересня', 'жовтня', 'листопада', 'грудня'],
    ['一月', '二月', '三月', '四月', '五月', '六月', '七月', '八月', '九月', '十月', '十一月', '十二月'],
    ['Januari', 'Februari', 'Mars', 'April', 'Maj', 'Juni', 'Juli', 'Augusti', 'September', 'Oktober', 'November', 'December'],
    ['urtarrila', 'otsaila', 'martxoa', 'apirila', 'maiatza', 'ekaina', 'uztaila', 'abuztua', 'iraila', 'urria', 'azaroa', 'abendua']
]

__FORMAT_TRANSLATIONS = {
    '%A': {
        'af_ZA': 72,
        'be_BY': 74,
        'bg_BG': 83,
        'ca_ES': 77,
        'cs_CZ': 89,
        'da_DK': 87,
        'de_AT': 76,
        'de_CH': 76,
        'de_DE': 76,
        'el_GR': 73,
        'en_AU': 72,
        'en_CA': 72,
        'en_GB': 72,
        'en_IE': 72,
        'en_NZ': 72,
        'en_US': 72,
        'es_ES': 82,
        'et_EE': 69,
        'eu_ES': 96,
        'fi_FI': 66,
        'fr_BE': 65,
        'fr_CA': 65,
        'fr_CH': 65,
        'fr_FR': 65,
        'he_IL': 92,
        'hr_HR': 86,
        'hu_HU': 78,
        'is_IS': 84,
        'it_CH': 68,
        'it_IT': 68,
        'ja_JP': 79,
        'ko_KR': 88,
        'lt_LT': 80,
        'nl_BE': 70,
        'nl_NL': 70,
        'no_NO': 71,
        'pl_PL': 75,
        'pt_BR': 67,
        'pt_PT': 67,
        'ro_RO': 91,
        'ru_RU': 63,
        'sk_SK': 90,
        'sl_SI': 81,
        'sv_SE': 95,
        'tr_TR': 64,
        'uk_UA': 93,
        'zh_CN': 94,
        'zh_HK': 85,
        'zh_TW': 85
    },
    '%B': {
        'af_ZA': 106,
        'be_BY': 108,
        'bg_BG': 118,
        'ca_ES': 111,
        'cs_CZ': 123,
        'da_DK': 121,
        'de_AT': 116,
        'de_CH': 110,
        'de_DE': 110,
        'el_GR': 107,
        'en_AU': 106,
        'en_CA': 106,
        'en_GB': 106,
        'en_IE': 106,
        'en_NZ': 106,
        'en_US': 106,
        'es_ES': 117,
        'et_EE': 103,
        'eu_ES': 130,
        'fi_FI': 100,
        'fr_BE': 99,
        'fr_CA': 99,
        'fr_CH': 99,
        'fr_FR': 99,
        'he_IL': 126,
        'hr_HR': 120,
        'hu_HU': 112,
        'is_IS': 119,
        'it_CH': 102,
        'it_IT': 102,
        'ja_JP': 113,
        'ko_KR': 122,
        'lt_LT': 114,
        'nl_BE': 104,
        'nl_NL': 104,
        'no_NO': 105,
        'pl_PL': 109,
        'pt_BR': 101,
        'pt_PT': 101,
        'ro_RO': 125,
        'ru_RU': 97,
        'sk_SK': 124,
        'sl_SI': 115,
        'sv_SE': 129,
        'tr_TR': 98,
        'uk_UA': 127,
        'zh_CN': 128,
        'zh_HK': 113,
        'zh_TW': 113
    },
    '%a': {
        'af_ZA': 9,
        'be_BY': 11,
        'bg_BG': 20,
        'ca_ES': 14,
        'cs_CZ': 26,
        'da_DK': 24,
        'de_AT': 13,
        'de_CH': 13,
        'de_DE': 13,
        'el_GR': 10,
        'en_AU': 9,
        'en_CA': 9,
        'en_GB': 9,
        'en_IE': 9,
        'en_NZ': 9,
        'en_US': 9,
        'es_ES': 19,
        'et_EE': 6,
        'eu_ES': 32,
        'fi_FI': 3,
        'fr_BE': 2,
        'fr_CA': 2,
        'fr_CH': 2,
        'fr_FR': 2,
        'he_IL': 29,
        'hr_HR': 23,
        'hu_HU': 15,
        'is_IS': 21,
        'it_CH': 5,
        'it_IT': 5,
        'ja_JP': 16,
        'ko_KR': 25,
        'lt_LT': 17,
        'nl_BE': 7,
        'nl_NL': 7,
        'no_NO': 8,
        'pl_PL': 12,
        'pt_BR': 4,
        'pt_PT': 4,
        'ro_RO': 28,
        'ru_RU': 0,
        'sk_SK': 27,
        'sl_SI': 18,
        'sv_SE': 31,
        'tr_TR': 1,
        'uk_UA': 30,
        'zh_CN': 22,
        'zh_HK': 22,
        'zh_TW': 22
    },
    '%b': {
        'af_ZA': 42,
        'be_BY': 44,
        'bg_BG': 53,
        'ca_ES': 47,
        'cs_CZ': 57,
        'da_DK': 56,
        'de_AT': 46,
        'de_CH': 46,
        'de_DE': 46,
        'el_GR': 43,
        'en_AU': 42,
        'en_CA': 42,
        'en_GB': 42,
        'en_IE': 42,
        'en_NZ': 42,
        'en_US': 42,
        'es_ES': 52,
        'et_EE': 39,
        'eu_ES': 62,
        'fi_FI': 36,
        'fr_BE': 35,
        'fr_CA': 35,
        'fr_CH': 35,
        'fr_FR': 35,
        'he_IL': 60,
        'hr_HR': 55,
        'hu_HU': 48,
        'is_IS': 54,
        'it_CH': 38,
        'it_IT': 38,
        'ja_JP': 49,
        'ko_KR': 49,
        'lt_LT': 50,
        'nl_BE': 40,
        'nl_NL': 40,
        'no_NO': 41,
        'pl_PL': 45,
        'pt_BR': 37,
        'pt_PT': 37,
        'ro_RO': 59,
        'ru_RU': 33,
        'sk_SK': 58,
        'sl_SI': 51,
        'sv_SE': 56,
        'tr_TR': 34,
        'uk_UA': 61,
        'zh_CN': 49,
        'zh_HK': 49,
        'zh_TW': 49
    }
}