#!/usr/bin/env python3

# The following ugly variables were automatically build.
    
FRAME_FORMATS = {
    'c_basic': {
        'corner': {
            'leftup': '/',
            'rightdown': '/'
        },
        'rule': {
            'down': '*',
            'left': '*',
            'right': '*',
            'up': '*'
        }
    },
    'c_pretty': {
        'corner': {
            'leftdown': '* ',
            'leftup': '/* ',
            'rightdown': ' */',
            'rightup': ' *'
        },
        'rule': {
            'down': '-',
            'left': '--',
            'right': '--',
            'up': '-'
        }
    },
    'pyba_part_nb': {
        'rule': {
            'down': '*',
            'up': '*'
        }
    },
    'pyba_part_no_nb': {
        'rule': {
            'down': ':',
            'up': ':'
        }
    },
    'pyba_title_nb': {
        'rule': {
            'down': '=',
            'up': '='
        }
    },
    'pyba_title_no_nb': {
        'rule': {
            'down': '-',
            'up': '-'
        }
    },
    'python_basic': {
        'rule': {
            'down': '#',
            'left': '#',
            'right': '#',
            'up': '#'
        }
    },
    'python_pretty': {
        'extra': {
            'rule': {
                'left': '#',
                'right': '#'
            }
        },
        'rule': {
            'down': '-',
            'left': '--',
            'right': '--',
            'up': '-'
        }
    },
    'unittest_basic': {
        'rule': {
            'down': '*',
            'left': '*',
            'right': '*',
            'up': '*'
        }
    },
    'unittest_problem': {
        'extra': {
            'rule': {
                'down': '*',
                'left': '*',
                'right': '*',
                'up': '*'
            }
        },
        'rule': {
            'down': '*',
            'left': '* ---->>',
            'right': '<<---- *',
            'up': '*'
        }
    }
}

_ABREV_FRAME = {
    'corner': {
        'leftdown': 'ld',
        'leftup': 'lu',
        'rightdown': 'rd',
        'rightup': 'ru'
    },
    'rule': {
        'down': 'd',
        'left': 'l',
        'right': 'r',
        'up': 'u'
    }
}

_KEY_FRAME = {
    'corner': {
        'ru',
        'rightup',
        'ld',
        'rd',
        'lu',
        'leftdown',
        'rightdown',
        'leftup'
    },
    'rule': {
        'right',
        'd',
        'up',
        'l',
        'down',
        'r',
        'u',
        'left'
    }
}