# =======
# Sources
# =======
#
#    1) http://wiki.python.org/moin/Distutils/Tutorial
#    2) http://www.developpez.net/forums/d1195941/autres-langages/python-zope/general-python/ajout-module-distribution-python/#post6555422
#    3) http://docs.python.org/distutils/sourcedist.html
#    4) http://www.developpez.net/forums/d1208929/autres-langages/python-zope/general-python/distutils-exclure-inclure-dossier-fichier-lors-setup/#post6619447


# ==========
# Meta-datas
# ==========
#
#     1) http://docs.python.org/3.0/distutils/setupscript.html#additional-meta-data
#     2) https://pypi.python.org/pypi?%3Aaction=list_classifiers


# =============
# Line commands
# =============
#
#    1) Local installation :
#         python3 setup.py install
#
#    2) Registering :
#         python3 setup.py register
#
#    3) Uploading the code on Pypi :
#         python3 setup.py sdist upload

from distutils.core import setup

PROJECT_DATE = "2013.10.13"

LONG_DESCRIPTION = """
**misTool** is a contraction of **missing**, **miscellaneous** and **tool**. This package contains the following modules that could be useful for Python developments.

If you want more informations and examples than thereafter, just take a look at the docstrings.

.. contents:: Table of Contents


===============================
Which OS can use this package ?
===============================

All the modules have been tested under Mac OS, Windows 7 and Linux Ubuntu 12.10 Quantal.


=========================
The module ``string_use``
=========================

* **Auto completion** features easily.
* **Replacement, split and join** advanced utilities.
* **Searching groups** delimited by parenthesis, quotes, ...
* **ASCII translation** of a text.
* **Special cases for letters** so as to obtain for example easily "One example" from "one example".
* **Testing the case of one text**.
* **Camel case** transformations so as to obtain for example "One_Example" from "oneExample".
* **ASCII frame** for multiline texts.
* **Hard wrapping** of texts.


========================
The module ``regex_use``
========================

* **Testing if a text is a number** : the kinds managed are upper or lower roman numbers, natural ones, integers, decimal numbers and rational ones.
* **Legal name for a variable**, four kinds of name are available for the moment.


========================
The module ``date_use``
========================

* **Translating dates**.


======================
The module ``url_use``
======================

* **Testing urls** so as to look for dead links.
* **Escaping in urls** the special characters.


========================
The module ``latex_use``
========================

* Easy **compilation** of LaTeX files.
* **Removing the temporary files** produced by LaTeX during one compilation.
* **Automatic installation** of personal LaTeX packages.
* Crucial **informations about your LaTeX distribution**.
* **Escaping** the special characters used by the LaTeX syntax.


=====================
The module ``os_use``
=====================

* **Testing paths** so as to know if they point to one file, or one directory.
* **Extract informations from paths** like the name of a file with or without the extension, or the path of the parent parent directory...
* **Reading and building text files** very easily.
* **Opening a file with its associated default application** from a Python code.
* **Moving, copying and deleting** files.
* **Cleaning directories** with a fine tuning.
* **Listing the content of one directory** with fine tuning.
* **ASCII tree view of one directory**.
* **System** used and **environment's path**.


===========================
The module ``log_test_use``
===========================

* **Launching test suite with unittest** very easily in a directory (all you need is to follow some very simple rules for naming testing files and classes).
* **Special formatting** for logging during tests.
* **Differences between two dictionaries** given in a string format.


=========================
The module ``python_use``
=========================

* **Pretty representation of Python variables** with a fine tuning.
* **Easy quoted text** with the least escaped quote symbols.


============================
Log of the last main changes
============================

Only the major changes are in english. You can find all of them in the directory ``change_log/en``.

If you want to know every changes, even the minor ones, there are in the directory ``change_log/fr`` but all of this is only in french.


:2013-09-21: Birth of the new module ``date_use`` that only proposes, for the moment, an easy way to translate dates.

The module ``string_use`` has one new function ``isCase`` so as to test the case of one text.


:2013-05-19: The module ``string_use`` has the new following features.

* The class ``MultiReplace`` allows to replace texts that can also contain piece of texts to be replaced.
* The function ``split`` allows to split one text regarding to several different separators instead of a single one.
* The class ``MultiSplit`` allows to split one text at different levels of splitting.
* The class ``AutoComplete`` proposes auto completion features.


:2013-03-17: First downloadable version of the package.
""".strip()

setup(
    name         = "mistool",
    version      = PROJECT_DATE,
    author       = "Christophe BAL",
    author_email = "projetmbc@gmail.com",
    url          = "https://pypi.python.org/pypi/mistool",
    download_url = "https://pypi.python.org/pypi/mistool",
    packages     = [
#    + Main
        'mistool',
#    + Configurations
        'mistool.config',
    ],
    package_dir  = {'mistool': "mistool"},
    package_data = {'mistool': ["change_log/*/*/*.txt"]},
    classifiers  = [
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Programming Language :: Python :: 3',
        'Operating System :: MacOS',
        'Operating System :: Microsoft :: Windows',
        'Operating System :: POSIX :: Linux',
        'Topic :: Utilities',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Software Development :: Testing',
        'Topic :: Desktop Environment :: File Managers',
        'Topic :: Software Development :: Code Generators',
        'Topic :: System :: Logging',
        'Topic :: Text Processing :: Markup :: LaTeX',
    ],
    description = \
        "Miscellaneous missing tools that can help the py-developper.",
    long_description = LONG_DESCRIPTION,
)
