#!/usr/bin/env python3

from mistool.parse_use.token import Groups

GROUPS = {}


# --------------- #
# -- CONSTANTS -- #
# --------------- #

STD_QUOTE = [('"', True), ("'", True)]
PY_QUOTE  = STD_QUOTE + [('"""', True), ("'''", True)]

STD_PAR = [
    ("(", ")"),
    ("[", "]"),
    ("{", "}"),
]


# ------------ #
# -- PYTHON -- #
# ------------ #

GROUPS["python"] = Groups(
    groups   = PY_QUOTE + STD_PAR,
    escape   = '\\',
    verbatim = PY_QUOTE,
    untoken  = PY_QUOTE
)
