# =======
# Sources
# =======
#
#    1) http://wiki.python.org/moin/Distutils/Tutorial
#    2) http://www.developpez.net/forums/d1195941/autres-langages/python-zope/general-python/ajout-module-distribution-python/#post6555422
#    3) http://docs.python.org/distutils/sourcedist.html
#    4) http://www.developpez.net/forums/d1208929/autres-langages/python-zope/general-python/distutils-exclure-inclure-dossier-fichier-lors-setup/#post6619447


# ==========
# Meta-datas
# ==========
#
#     1) http://docs.python.org/3.0/distutils/setupscript.html#additional-meta-data
#     2) https://pypi.python.org/pypi?%3Aaction=list_classifiers


# =============
# Line commands
# =============
#
#    1) Local installation :
#         python3 setup.py install
#
#    2) Registering :
#         python3 setup.py register
#
#    3) Uploading the code on Pypi :
#         python3 setup.py sdist upload

from distutils.core import setup

PROJECT_DATE = "2013.10.30"

LONG_DESCRIPTION = """
**misTool** is a contraction of **missing**, **miscellaneous** and **tool**. This package contains the following modules that could be useful for Python developments.

If you want more informations and examples than thereafter, just take a look at the docstrings.

.. contents:: Table of Contents


===============================
Which OS can use this package ?
===============================

All the modules have been tested under Mac OS.


=========================
The module ``string_use``
=========================

* **Auto completion** features easily.
* **Replacement, split and join** advanced utilities.
* **ASCII translation** of a text.
* **Special cases for letters** so as to obtain for example easily "One example" from "one example".
* **Testing the case of one text**.
* **Camel case** transformations so as to obtain for example "One_Example" from "oneExample".
* **ASCII frame** for multiline texts.
* **Hard wrapping** of texts with management of indentations, and also of protected groups content like for example quoting texts (you can define your own kinds of group).


========================
The module ``parse_use``
========================

* **Testing if a text is a number** : the kinds managed are upper or lower roman numbers, natural ones, integers, decimal numbers and rational ones.
* **Legal name for a variable**, four kinds of name are available for the moment.
* **Searching groups** delimited by parenthesis, quotes, ...
* **Basic tokenizing with support of groups**.


========================
The module ``date_use``
========================

* **Translating dates**.


======================
The module ``url_use``
======================

* **Testing urls** so as to look for dead links.
* **Escaping in urls** the special characters.


========================
The module ``latex_use``
========================

* Easy **compilation** of LaTeX files.
* **Removing the temporary files** produced by LaTeX during one compilation.
* **Automatic installation** of personal LaTeX packages.
* Crucial **informations about your LaTeX distribution**.
* **Escaping** the special characters used by the LaTeX syntax.


=====================
The module ``os_use``
=====================

* **Testing paths** so as to know if they point to one file, or one directory.
* **Extract informations from paths** like the name of a file with or without the extension, or the path of the parent parent directory...
* **Reading and building text files** very easily.
* **Opening a file with its associated default application** from a Python code.
* **Moving, copying and deleting** files.
* **Cleaning directories** with a fine tuning.
* **Listing the content of one directory** with fine tuning.
* **ASCII tree view of one directory**.
* **System** used and **environment's path**.


===========================
The module ``log_test_use``
===========================

* **Launching test suite with unittest** very easily in a directory (all you need is to follow some very simple rules for naming testing files and classes).
* **Special formatting** for logging during tests.
* **Differences between two dictionaries** given in a string format.


=========================
The module ``python_use``
=========================

* **Pretty representation of Python variables** with some fine tunings.
* **Easy quoted text** with the least escaped quote symbols.


============================
Log of the last main changes
============================

Only the major changes are in english. You can find all of them in the directory ``change_log/en``.

If you want to know every changes, even the minor ones, there are in the directory ``change_log/fr`` but all of this is only in french.


:2013-10-30: **Refactoring of the package ``mistool``**

The module ``regex_use`` becomes the sub-package ``parse_use`` which contains the following modules.

1) First, the module ``identify`` gathers all the simple functions ``isVarName``, ``isRoman``, ``isNatural``, ``isInteger``, ``isRational``, ``isDecimal`` and ``isFloat``.

2) With the module ``group``, you can use the following features.

    a) The class ``FindGroups`` of the module ``string_use`` has been moved to the module ``group`` of ``parse_use``. It makes more sense ...

    b) To facilitate the use of the class ``FindGroups``, a new class ``Groups`` was born so as to define easily groups.

    c) A new function ``findIndent`` allows to find the indentation level of a line.

3) The module ``token`` contains a new class ``Token`` that can build a list of tokens. Although basic, this class can work with groups by using the class ``Groups``.


**Rename and improvement of the function ``cut`` into the module ``string_use``**

The function ``cut`` of the module ``string_use`` has been renamed ``wrap``, that's better. This new version can work with the class ``Token`` to indicate, for example, protected groups or verbatim content.


**Improvement of the function ``pyRepr`` of the module ``python_use``**

1) A new optional argument ``name`` allows to give a name to be used in order to obtain ``myName =  ...``.

2) Another optional argument ``format`` allows to configure a little the output.

    a) ``"wrap"`` allows to use line breaks for parts using too many characters .

    b) ``"short"`` allows for a ordered dictionary like object to get ``OrderedDict`` instead of ``collections.OrderedDict``.

    c) ``"key"`` is used with dictionaries to format them using a syntax like ``oneDict[oneKey] = oneValue``.

    d) ``"empty"`` asks to add a blank line before every new definition ``oneDict[oneKey] = oneValue``.


**That's all !** For the moment... ;-)


:2013-10-27: The function ``ascii`` in ``string_use`` has a better implementation using the standard package ``unicode``.


:2013-10-13: The module ``string_use`` has a new class ``FindGroups`` for searching groups delimited by parenthesis, quotes, ...

**Bug:** empty lists, empty tuples and empty dictionaries were not managed by the function ``pyRepr``.

**Refactoring 1:** the functions ``isUpperRoman`` and ``isLowerRoman`` of the module ``regex_use`` have been replaced by one single function ``isRoman`` with an optional argument ``case`` which indicates the case expected.

**Refactoring 2:** the default formats for the function ``frame`` in the module ``string_use`` are now in a single dictionary ``FRAME_FORMATS`` so as to easy have all the default formats available.

**Warning !** A lot of renamings have been made for sake of simplicity and conventional notations.

1) In the module ``date_use``, the variables ``dateTime`` and ``strFormat`` of the function ``translate`` have been renamed ``date`` and ``format`` respectively.

2) In the module ``os_use``, the variable ``listPath`` of the function ``commonPath`` have been renamed ``paths``.

3) In the module ``string_use``, the initialization variables ``listWord`` and ``dict`` of the class ``AutoComplete`` become ``words`` and ``dictAsso`` respectively. The variable ``listText`` of the function ``joinAnd`` is now called ``texts``, and the class ``step`` becomes ``Step``.


:2013-09-21: Birth of the new module ``date_use`` that only proposes, for the moment, an easy way to translate dates.

The module ``string_use`` has one new function ``isCase`` so as to test the case of one text.


:2013-09-15: The new functions ``nextDir`` and ``listDir`` return the paths of the directories contained in one directory.

The functions ``nextFile`` and ``listFile`` of the module ``os_use`` allow now to use criteria of researches regarding to the prefix of the name of the files (this feature is used by the function ``launchTestSuite`` of the module ``log_test_use``).

**Warning !** The variable ``sub`` of the functions ``nextFile`` and ``listFile``, and also of the class ``DirView`` has been deleted because it is not concretly usable without big problems.


:2013-06-17: The module ``string_use`` has one new function ``ascii`` which aim is to give an ASCII translation of a text.


:2013-05-19: The module ``string_use`` has the new following features.

* The class ``MultiReplace`` allows to replace texts that can also contain piece of texts to be replaced.
* The function ``split`` allows to split one text regarding to several different separators instead of a single one.
* The class ``MultiSplit`` allows to split one text at different levels of splitting.
* The class ``AutoComplete`` proposes auto completion features.


:2013-03-17: First downloadable version of the package.
""".strip()

setup(
    name         = "mistool",
    version      = PROJECT_DATE,
    author       = "Christophe BAL",
    author_email = "projetmbc@gmail.com",
    url          = "https://pypi.python.org/pypi/mistool",
    download_url = "https://pypi.python.org/pypi/mistool",
    packages     = [
#    + Main
        'mistool',
#    + Configurations
        'mistool.config',
#    + Parse Use
        'mistool.parse_use',
    ],
    package_dir  = {'mistool': "mistool"},
    package_data = {'mistool': ["change_log/*/*/*.txt"]},
    classifiers  = [
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Programming Language :: Python :: 3',
        'Operating System :: MacOS',
        'Operating System :: Microsoft :: Windows',
        'Operating System :: POSIX :: Linux',
        'Topic :: Utilities',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Software Development :: Testing',
        'Topic :: Desktop Environment :: File Managers',
        'Topic :: Software Development :: Code Generators',
        'Topic :: System :: Logging',
        'Topic :: Text Processing :: Markup :: LaTeX',
    ],
    description = \
        "Miscellaneous missing tools that can help the py-developper.",
    long_description = LONG_DESCRIPTION,
)
