#!/usr/bin/env python3

# The following ugly variables were automatically build.

__ALL_LANGS = ['af_ZA', 'be_BY', 'bg_BG', 'ca_ES', 'cs_CZ', 'da_DK', 'de_AT',
'de_CH', 'de_DE', 'el_GR', 'en_AU', 'en_CA', 'en_GB', 'en_IE', 'en_NZ', 'en_US',
'es_ES', 'et_EE', 'eu_ES', 'fi_FI', 'fr_BE', 'fr_CA', 'fr_CH', 'fr_FR', 'he_IL',
'hr_HR', 'hu_HU', 'is_IS', 'it_CH', 'it_IT', 'ja_JP', 'ko_KR', 'lt_LT', 'nl_BE',
'nl_NL', 'no_NO', 'pl_PL', 'pt_BR', 'pt_PT', 'ro_RO', 'ru_RU', 'sk_SK', 'sl_SI',
'sv_SE', 'tr_TR', 'uk_UA', 'zh_CN', 'zh_HK', 'zh_TW']

__POINTERS = [
    ['Ιανουαρίου', 'Φεβρουαρίου', 'Μαρτίου', 'Απριλίου', 'Μαΐου', 'Ιουνίου',
    'Ιουλίου', 'Αυγούστου', 'Σεπτεμβρίου', 'Οκτωβρίου', 'Νοεμβρίου',
    'Δεκεμβρίου'],
    ['janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet', 'août',
    'septembre', 'octobre', 'novembre', 'décembre'],
    ['Jänner', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August',
    'September', 'Oktober', 'November', 'Dezember'],
    ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August',
    'September', 'October', 'November', 'December'],
    ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August',
    'September', 'Oktober', 'November', 'Dezember'],
    ['januar', 'februar', 'marec', 'april', 'maj', 'junij', 'julij', 'avgust',
    'september', 'oktober', 'november', 'december'],
    ['janúar', 'febrúar', 'mars', 'apríl', 'maí', 'júní', 'júlí', 'ágúst',
    'september', 'október', 'nóvember', 'desember'],
    ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'],
    ['Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio', 'Giugno', 'Luglio',
    'Agosto', 'Settembre', 'Ottobre', 'Novembre', 'Dicembre'],
    ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz', 'Ağustos',
    'Eylül', 'Ekim', 'Kasım', 'Aralık'],
    ['января', 'февраля', 'марта', 'апреля', 'мая', 'июня', 'июля', 'августа',
    'сентября', 'октября', 'ноября', 'декабря'],
    ['Siječanj', 'Veljača', 'Ožujak', 'Travanj', 'Svibanj', 'Lipanj', 'Srpanj',
    'Kolovoz', 'Rujan', 'Listopad', 'Studeni', 'Prosinac'],
    ['一月', '二月', '三月', '四月', '五月', '六月', '七月', '八月', '九月', '十月', '十一月', '十二月'],
    ['stycznia', 'lutego', 'marca', 'kwietnia', 'maja', 'czerwca', 'lipca',
    'sierpnia', 'września', 'października', 'listopada', 'grudnia'],
    ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio', 'agosto',
    'septiembre', 'octubre', 'noviembre', 'diciembre'],
    ['студзеня', 'лютага', 'сакавіка', 'красавіка', 'траўня', 'чэрвеня',
    'ліпеня', 'жніўня', 'верасня', 'кастрычніка', 'лістапада', 'снежня'],
    ['jaanuar', 'veebruar', 'märts', 'aprill', 'mai', 'juuni', 'juuli', 'august'
    , 'september', 'oktoober', 'november', 'detsember'],
    ['urtarrila', 'otsaila', 'martxoa', 'apirila', 'maiatza', 'ekaina',
    'uztaila', 'abuztua', 'iraila', 'urria', 'azaroa', 'abendua'],
    ['Tammikuu', 'Helmikuu', 'Maaliskuu', 'Huhtikuu', 'Toukokuu', 'Kesäkuu',
    'Heinäkuu', 'Elokuu', 'Syyskuu', 'Lokakuu', 'Marraskuu', 'Joulukuu'],
    ['січня', 'лютого', 'березня', 'квітня', 'травня', 'червня', 'липня',
    'серпня', 'вересня', 'жовтня', 'листопада', 'грудня'],
    ['ledna', 'února', 'března', 'dubna', 'května', 'června', 'července',
    'srpna', 'září', 'října', 'listopadu', 'prosince'],
    ['január', 'február', 'marec', 'apríl', 'máj', 'jún', 'júl', 'august',
    'september', 'október', 'november', 'december'],
    ['sausio', 'vasario', 'kovo', 'balandžio', 'gegužės', 'birželio', 'liepos',
    'rugpjūčio', 'rugsėjo', 'spalio', 'lapkričio', 'gruodžio'],
    ['gener', 'febrer', 'març', 'abril', 'maig', 'juny', 'juliol', 'agost',
    'setembre', 'octubre', 'novembre', 'desembre'],
    ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho',
    'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
    ['Januar', 'Februar', 'Marts', 'April', 'Maj', 'Juni', 'Juli', 'August',
    'September', 'Oktober', 'November', 'December'],
    ['ינואר', 'פברואר', 'מרץ', 'אפריל', 'מאי', 'יוני', 'יולי', 'אוגוסט',
    'ספטמבר', 'אוקטובר', 'נובמבר', 'דצמבר'],
    ['1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월', '9월', '10월', '11월', '12월'],
    ['Január', 'Február', 'Március', 'Április', 'Május', 'Június', 'Július',
    'Augusztus', 'Szeptember', 'Október', 'November', 'December'],
    ['Januari', 'Februari', 'Mars', 'April', 'Maj', 'Juni', 'Juli', 'Augusti',
    'September', 'Oktober', 'November', 'December'],
    ['Януари', 'Февруари', 'Март', 'Април', 'Май', 'Юни', 'Юли', 'Август',
    'Септември', 'Октомври', 'Ноември', 'Декември'],
    ['Ianuarie', 'Februarie', 'Martie', 'Aprilie', 'Mai', 'Iunie', 'Iulie',
    'August', 'Septembrie', 'Octombrie', 'Noiembrie', 'Decembrie'],
    ['januari', 'februari', 'maart', 'april', 'mei', 'juni', 'juli', 'augustus',
    'september', 'oktober', 'november', 'december'],
    ['januar', 'februar', 'mars', 'april', 'mai', 'juni', 'juli', 'august',
    'september', 'oktober', 'november', 'desember'],
    ['Δευτέρα', 'Τρίτη', 'Τετάρτη', 'Πέμπτη', 'Παρασκευή', 'Σάββατο', 'Κυριακή']
    ,
    ['Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi', 'Dimanche'],
    ['Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag',
    'Sonntag'],
    ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday',
    'Sunday'],
    ['ponedeljek', 'torek', 'sreda', 'četrtek', 'petek', 'sobota', 'nedelja'],
    ['mánudagur', 'þriðjudagur', 'miðvikudagur', 'fimmtudagur', 'föstudagur',
    'laugardagur', 'sunnudagur'],
    ['周一', '周二', '周三', '周四', '周五', '周六', '周日'],
    ['Lunedì', 'Martedì', 'Mercoledì', 'Giovedì', 'Venerdì', 'Sabato',
    'Domenica'],
    ['Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi', 'Pazar'],
    ['понедельник', 'вторник', 'среда', 'четверг', 'пятница', 'суббота',
    'воскресенье'],
    ['Ponedjeljak', 'Utorak', 'Srijeda', 'Četvrtak', 'Petak', 'Subota',
    'Nedjelja'],
    ['星期一', '星期二', '星期三', '星期四', '星期五', '星期六', '星期日'],
    ['月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日', '日曜日'],
    ['poniedziałek', 'wtorek', 'środa', 'czwartek', 'piątek', 'sobota',
    'niedziela'],
    ['lunes', 'martes', 'miércoles', 'jueves', 'viernes', 'sábado', 'domingo'],
    ['панядзелак', 'аўторак', 'серада', 'чацвер', 'пятніца', 'субота',
    'нядзеля'],
    ['esmaspäev', 'teisipäev', 'kolmapäev', 'neljapäev', 'reede', 'laupäev',
    'pühapäev'],
    ['astelehena', 'asteartea', 'asteazkena', 'osteguna', 'ostirala',
    'larunbata', 'igandea'],
    ['Maanantai', 'Tiistai', 'Keskiviikko', 'Torstai', 'Perjantai', 'Lauantai',
    'Sunnuntai'],
    ['понеділок', 'вівторок', 'середа', 'четвер', "п'ятниця", 'субота',
    'неділя'],
    ['pondělí', 'úterý', 'středa', 'čtvrtek', 'pátek', 'sobota', 'neděle'],
    ['pondelok', 'utorok', 'streda', 'štvrtok', 'piatok', 'sobota', 'nedeľa'],
    ['Pirmadienis', 'Antradienis', 'Trečiadienis', 'Ketvirtadienis',
    'Penktadienis', 'Šeštadienis', 'Sekmadienis'],
    ['dilluns', 'dimarts', 'dimecres', 'dijous', 'divendres', 'dissabte',
    'diumenge'],
    ['Segunda Feira', 'Terça Feira', 'Quarta Feira', 'Quinta Feira',
    'Sexta Feira', 'Sábado', 'Domingo'],
    ['Mandag', 'Tirsdag', 'Onsdag', 'Torsdag', 'Fredag', 'Lørdag', 'Søndag'],
    ['שני', 'שלישי', 'רביעי', 'חמישי', 'שישי', 'שבת', 'ראשון'],
    ['월요일', '화요일', '수요일', '목요일', '금요일', '토요일', '일요일'],
    ['Hétfő', 'Kedd', 'Szerda', 'Csütörtök', 'Péntek', 'Szombat', 'Vasárnap'],
    ['Måndag', 'Tisdag', 'Onsdag', 'Torsdag', 'Fredag', 'Lördag', 'Söndag'],
    ['Понеделник', 'Вторник', 'Сряда', 'Четвъртък', 'Петък', 'Събота', 'Неделя']
    ,
    ['Luni', 'Marţi', 'Miercuri', 'Joi', 'Vineri', 'Sâmbătă', 'Duminică'],
    ['maandag', 'dinsdag', 'woensdag', 'donderdag', 'vrijdag', 'zaterdag',
    'zondag'],
    ['mandag', 'tirsdag', 'onsdag', 'torsdag', 'fredag', 'lørdag', 'søndag'],
    ['Δευ', 'Τρι', 'Τετ', 'Πεμ', 'Παρ', 'Σαβ', 'Κυρ'],
    ['Lun', 'Mar', 'Mer', 'Jeu', 'Ven', 'Sam', 'Dim'],
    ['Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa', 'So'],
    ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
    ['pon', 'tor', 'sre', 'čet', 'pet', 'sob', 'ned'],
    ['mán', 'þri', 'mið', 'fim', 'fös', 'lau', 'sun'],
    ['一', '二', '三', '四', '五', '六', '日'],
    ['Lun', 'Mar', 'Mer', 'Gio', 'Ven', 'Sab', 'Dom'],
    ['Pts', 'Sal', 'Çar', 'Per', 'Cum', 'Cts', 'Paz'],
    ['пн', 'вт', 'ср', 'чт', 'пт', 'сб', 'вс'],
    ['Po', 'Ut', 'Sr', 'Če', 'Pe', 'Su', 'Ne'],
    ['月', '火', '水', '木', '金', '土', '日'],
    ['pon', 'wto', 'śro', 'czw', 'ptk', 'sob', 'ndz'],
    ['lun', 'mar', 'mié', 'jue', 'vie', 'sáb', 'dom'],
    ['пн', 'аў', 'ср', 'чц', 'пт', 'сб', 'нд'],
    ['E', 'T', 'K', 'N', 'R', 'L', 'P'],
    ['al.', 'as.', 'az.', 'og.', 'or.', 'lr.', 'ig.'],
    ['Ma', 'Ti', 'Ke', 'To', 'Pe', 'La', 'Su'],
    ['пн', 'вт', 'ср', 'чт', 'пт', 'сб', 'нд'],
    ['po', 'út', 'st', 'čt', 'pá', 'so', 'ne'],
    ['po', 'ut', 'st', 'št', 'pi', 'so', 'ne'],
    ['Pr', 'An', 'Tr', 'Kt', 'Pn', 'Št', 'Sk'],
    ['dil', 'dim', 'dmc', 'dij', 'div', 'dis', 'diu'],
    ['Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb', 'Dom'],
    ['Man', 'Tir', 'Ons', 'Tor', 'Fre', 'Lør', 'Søn'],
    ["ב'", "ג'", "ד'", "ה'", "ו'", "ש'", "א'"],
    ['월', '화', '수', '목', '금', '토', '일'],
    ['Hét', 'Ked', 'Sze', 'Csü', 'Pén', 'Szo', 'Vas'],
    ['Mån', 'Tis', 'Ons', 'Tor', 'Fre', 'Lör', 'Sön'],
    ['Пн', 'Вт', 'Ср', 'Чт', 'Пт', 'Сб', 'Нд'],
    ['Lun', 'Mar', 'Mie', 'Joi', 'Vin', 'Sâm', 'Dum'],
    ['ma', 'di', 'wo', 'do', 'vr', 'za', 'zo'],
    ['man', 'tir', 'ons', 'tor', 'fre', 'lør', 'søn'],
    ['Ιαν', 'Φεβ', 'Μαρ', 'Απρ', 'Μαϊ', 'Ιον', 'Ιολ', 'Αυγ', 'Σεπ', 'Οκτ', 'Νοε'
    , 'Δεκ'],
    ['jan', 'fév', 'mar', 'avr', 'mai', 'jui', 'jul', 'aoû', 'sep', 'oct', 'nov'
    , 'déc'],
    ['Jan', 'Feb', 'Mär', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov'
    , 'Dez'],
    ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov'
    , 'Dec'],
    ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'avg', 'sep', 'okt', 'nov'
    , 'dec'],
    ['jan', 'feb', 'mar', 'apr', 'maí', 'jún', 'júl', 'ágú', 'sep', 'okt', 'nóv'
    , 'des'],
    ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
    ['Gen', 'Feb', 'Mar', 'Apr', 'Mag', 'Giu', 'Lug', 'Ago', 'Set', 'Ott', 'Nov'
    , 'Dic'],
    ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas'
    , 'Ara'],
    ['янв', 'фев', 'мар', 'апр', 'май', 'июн', 'июл', 'авг', 'сен', 'окт', 'ноя'
    , 'дек'],
    ['Sij', 'Vel', 'Ožu', 'Tra', 'Svi', 'Lip', 'Srp', 'Kol', 'Ruj', 'Lis', 'Stu'
    , 'Pro'],
    ['sty', 'lut', 'mar', 'kwi', 'maj', 'cze', 'lip', 'sie', 'wrz', 'paź', 'lis'
    , 'gru'],
    ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep', 'oct', 'nov'
    , 'dic'],
    ['сту', 'лют', 'сак', 'кра', 'тра', 'чэр', 'ліп', 'жні', 'вер', 'кас', 'ліс'
    , 'сне'],
    ['jaan', 'veebr', 'märts', 'apr', 'mai', 'juuni', 'juuli', 'aug', 'sept',
    'okt', 'nov', 'dets'],
    ['Urt', 'Ots', 'Mar', 'Apr', 'Mai', 'Eka', 'Uzt', 'Abu', 'Ira', 'Urr', 'Aza'
    , 'Abe'],
    ['Tam', 'Hel', 'Maa', 'Huh', 'Tou', 'Kes', 'Hei', 'Elo', 'Syy', 'Lok', 'Mar'
    , 'Jou'],
    ['січ', 'лют', 'бер', 'кві', 'тра', 'чер', 'лип', 'сер', 'вер', 'жов', 'лис'
    , 'гру'],
    ['led', 'úno', 'bře', 'dub', 'kvě', 'črv', 'čvc', 'srp', 'zář', 'říj', 'lis'
    , 'pro'],
    ['jan', 'feb', 'mar', 'apr', 'máj', 'jún', 'júl', 'aug', 'sep', 'okt', 'nov'
    , 'dec'],
    ['Sau', 'Vas', 'Kov', 'Bal', 'Geg', 'Bir', 'Lie', 'Rgp', 'Rgs', 'Spa', 'Lap'
    , 'Grd'],
    ['gen', 'feb', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'oct', 'nov'
    , 'des'],
    ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov'
    , 'Dez'],
    ['Jan', 'Feb', 'Mar', 'Apr', 'Maj', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov'
    , 'Dec'],
    ['ינו', 'פבר', 'מרץ', 'אפר', 'מאי', 'יונ', 'יול', 'אוג', 'ספט', 'אוק', 'נוב'
    , 'דצמ'],
    ['Jan', 'Feb', 'Már', 'Ápr', 'Máj', 'Jún', 'Júl', 'Aug', 'Sze', 'Okt', 'Nov'
    , 'Dec'],
    ['Яну', 'Фев', 'Мар', 'Апр', 'Май', 'Юни', 'Юли', 'Авг', 'Сеп', 'Окт', 'Нов'
    , 'Дек'],
    ['Ian', 'Feb', 'Mar', 'Apr', 'Mai', 'Iun', 'Iul', 'Aug', 'Sep', 'Oct', 'Noi'
    , 'Dec'],
    ['jan', 'feb', 'mrt', 'apr', 'mei', 'jun', 'jul', 'aug', 'sep', 'okt', 'nov'
    , 'dec'],
    ['jan', 'feb', 'mar', 'apr', 'mai', 'jun', 'jul', 'aug', 'sep', 'okt', 'nov'
    , 'des']
]

__FORMAT_TRANSLATIONS = {
    '%A': {
        'af_ZA': 37,
        'be_BY': 49,
        'bg_BG': 64,
        'ca_ES': 57,
        'cs_CZ': 54,
        'da_DK': 59,
        'de_AT': 36,
        'de_CH': 36,
        'de_DE': 36,
        'el_GR': 34,
        'en_AU': 37,
        'en_CA': 37,
        'en_GB': 37,
        'en_IE': 37,
        'en_NZ': 37,
        'en_US': 37,
        'es_ES': 48,
        'et_EE': 50,
        'eu_ES': 51,
        'fi_FI': 52,
        'fr_BE': 35,
        'fr_CA': 35,
        'fr_CH': 35,
        'fr_FR': 35,
        'he_IL': 60,
        'hr_HR': 44,
        'hu_HU': 62,
        'is_IS': 39,
        'it_CH': 41,
        'it_IT': 41,
        'ja_JP': 46,
        'ko_KR': 61,
        'lt_LT': 56,
        'nl_BE': 66,
        'nl_NL': 66,
        'no_NO': 67,
        'pl_PL': 47,
        'pt_BR': 58,
        'pt_PT': 58,
        'ro_RO': 65,
        'ru_RU': 43,
        'sk_SK': 55,
        'sl_SI': 38,
        'sv_SE': 63,
        'tr_TR': 42,
        'uk_UA': 53,
        'zh_CN': 45,
        'zh_HK': 40,
        'zh_TW': 40
    },
    '%B': {
        'af_ZA': 3,
        'be_BY': 15,
        'bg_BG': 30,
        'ca_ES': 23,
        'cs_CZ': 20,
        'da_DK': 25,
        'de_AT': 2,
        'de_CH': 4,
        'de_DE': 4,
        'el_GR': 0,
        'en_AU': 3,
        'en_CA': 3,
        'en_GB': 3,
        'en_IE': 3,
        'en_NZ': 3,
        'en_US': 3,
        'es_ES': 14,
        'et_EE': 16,
        'eu_ES': 17,
        'fi_FI': 18,
        'fr_BE': 1,
        'fr_CA': 1,
        'fr_CH': 1,
        'fr_FR': 1,
        'he_IL': 26,
        'hr_HR': 11,
        'hu_HU': 28,
        'is_IS': 6,
        'it_CH': 8,
        'it_IT': 8,
        'ja_JP': 7,
        'ko_KR': 27,
        'lt_LT': 22,
        'nl_BE': 32,
        'nl_NL': 32,
        'no_NO': 33,
        'pl_PL': 13,
        'pt_BR': 24,
        'pt_PT': 24,
        'ro_RO': 31,
        'ru_RU': 10,
        'sk_SK': 21,
        'sl_SI': 5,
        'sv_SE': 29,
        'tr_TR': 9,
        'uk_UA': 19,
        'zh_CN': 12,
        'zh_HK': 7,
        'zh_TW': 7
    },
    '%a': {
        'af_ZA': 71,
        'be_BY': 82,
        'bg_BG': 97,
        'ca_ES': 90,
        'cs_CZ': 87,
        'da_DK': 92,
        'de_AT': 70,
        'de_CH': 70,
        'de_DE': 70,
        'el_GR': 68,
        'en_AU': 71,
        'en_CA': 71,
        'en_GB': 71,
        'en_IE': 71,
        'en_NZ': 71,
        'en_US': 71,
        'es_ES': 81,
        'et_EE': 83,
        'eu_ES': 84,
        'fi_FI': 85,
        'fr_BE': 69,
        'fr_CA': 69,
        'fr_CH': 69,
        'fr_FR': 69,
        'he_IL': 93,
        'hr_HR': 78,
        'hu_HU': 95,
        'is_IS': 73,
        'it_CH': 75,
        'it_IT': 75,
        'ja_JP': 79,
        'ko_KR': 94,
        'lt_LT': 89,
        'nl_BE': 99,
        'nl_NL': 99,
        'no_NO': 100,
        'pl_PL': 80,
        'pt_BR': 91,
        'pt_PT': 91,
        'ro_RO': 98,
        'ru_RU': 77,
        'sk_SK': 88,
        'sl_SI': 72,
        'sv_SE': 96,
        'tr_TR': 76,
        'uk_UA': 86,
        'zh_CN': 74,
        'zh_HK': 74,
        'zh_TW': 74
    },
    '%b': {
        'af_ZA': 104,
        'be_BY': 114,
        'bg_BG': 127,
        'ca_ES': 122,
        'cs_CZ': 119,
        'da_DK': 124,
        'de_AT': 103,
        'de_CH': 103,
        'de_DE': 103,
        'el_GR': 101,
        'en_AU': 104,
        'en_CA': 104,
        'en_GB': 104,
        'en_IE': 104,
        'en_NZ': 104,
        'en_US': 104,
        'es_ES': 113,
        'et_EE': 115,
        'eu_ES': 116,
        'fi_FI': 117,
        'fr_BE': 102,
        'fr_CA': 102,
        'fr_CH': 102,
        'fr_FR': 102,
        'he_IL': 125,
        'hr_HR': 111,
        'hu_HU': 126,
        'is_IS': 106,
        'it_CH': 108,
        'it_IT': 108,
        'ja_JP': 107,
        'ko_KR': 107,
        'lt_LT': 121,
        'nl_BE': 129,
        'nl_NL': 129,
        'no_NO': 130,
        'pl_PL': 112,
        'pt_BR': 123,
        'pt_PT': 123,
        'ro_RO': 128,
        'ru_RU': 110,
        'sk_SK': 120,
        'sl_SI': 105,
        'sv_SE': 124,
        'tr_TR': 109,
        'uk_UA': 118,
        'zh_CN': 107,
        'zh_HK': 107,
        'zh_TW': 107
    }
}