#!/usr/bin/env python3

# Source :
#    http://docs.python.org/library/re.html

import re


# ----------- #
# -- WORDS -- #
# ----------- #

FR_ACCENTUED_LETTERS = "âàéèêëîïôùüç"

PATTERN_GROUP_WORD = {
# Natural language
    'en': re.compile("([a-zA-Z]+)"),
    'fr': re.compile(
        "([a-z{0}A-Z{1}]+)".format(
            FR_ACCENTUED_LETTERS,
            FR_ACCENTUED_LETTERS.upper()
        )
    ),
# Coding
    'var': re.compile("([a-zA-Z][\d_a-zA-Z]*)"),
}


# ----------------------------- #
# -- LEGAL NAME FOR VARIABLE -- #
# ----------------------------- #

PATTERN_VAR_NAME = {
    'standard'  : re.compile("^[a-zA-Z][\d_a-zA-Z]*$"),
    'python'    : re.compile("^[_a-zA-Z][\d_a-zA-Z]*$"),
    'lazzy'     : re.compile("^[\d_a-zA-Z]+$"),
    'lexicBlock': re.compile(
        "^[a-zA-Z][\d_a-zA-Z]*(-[a-zA-Z][\d_a-zA-Z]*)*(\*)?$"
    )
}


# ------------------ #
# -- ROMAN NUMBER -- #
# ------------------ #

# The following pattern comes from the book "Dive into Python".

PATTERN_ROMAN_NUMERAL = re.compile(
    """
    ^                   # beginning of string
    M{0,4}              # thousands: 0 to 4 M's
    (CM|CD|D?C{0,3})    # hundreds: 900 (CM),
                        #           400 (CD),
                        #           0-300 (0 to 3 C's) or
                        #           500-800 (D, followed by 0 to 3 C's)
    (XC|XL|L?X{0,3})    # tens: 90 (XC), 40 (XL),
                        #       0-30 (0 to 3 X's) or
                        #       50-80 (L, followed by 0 to 3 X's)
    (IX|IV|V?I{0,3})    # ones: 9 (IX), 4 (IV),
                        #       0-3 (0 to 3 I's) or
                        #       5-8 (V, followed by 0 to 3 I's)
    $                   # end of string
    """ ,
    re.VERBOSE
)


# ------------------------- #
# -- MATHEMATICAL NUMBER -- #
# ------------------------- #

PATTERN_NATURAL = re.compile("^(\d)+$")
