"""
mkcffi
######

This command will output the needed files for a doing
a ``ffi.dlopen`` in the header basename prepended by ``c``::

  mkcffi path/to/include/header.h


You will still need to do some tweaking but it helps.

`forge <https://github.com/amirouche/mkcffi>`.

"""
from setuptools import setup


setup(
    name='mkcffi',
    version='0.1',
    url='http://github.com/amirouche/mkcffi',
    license='AGPL',
    author='Amirouche Boubekki',
    author_email='amirouche.boubekki@gmail.com',
    description='Bootstrap cffi wrappers',
    long_description=__doc__,
    zip_safe=False,
    platforms='any',
    install_requires=[
        'cffi',
    ],
    py_modules=['mkcffi'],
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
         'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Software Development :: Libraries :: Python Modules'
    ],
    entry_points="""
[console_scripts]
mkcffi=mkcffi:main
"""
)
