#!/usr/bin/env python
import os
import sys
from collections import OrderedDict


def mkcffi(filename):
    basename = os.path.split(filename)[-1]
    basename, ext = os.path.splitext(basename)
    basename = 'c' + basename
    output_dir = os.path.join(os.curdir, basename)
    if not os.path.exists(output_dir):
        os.makedirs(output_dir)
    constants_file = os.path.join(output_dir, 'constants.py')
    constants = OrderedDict()
    header_file = os.path.join(output_dir, 'cffi_header.h')
    init = os.path.join(output_dir, '__init__.py')
    header = ''
    with open(filename) as file:
        for line in file:
            if line.startswith('#'):
                if line.startswith('#define'):
                    define = line[7:].split()
                    if len(define) > 2:
                        if define[2].startswith('/*'):
                            define = define[:2]
                    if len(define) == 2:
                        if define[1].startswith('('):
                            constants[define[0]] = define[1][1:-1]
                        else:
                            constants[define[0]] = define[1]
                    else:
                        continue
                else:
                    continue
            else:
                header += line

    for key, value in constants.iteritems():
        if value in constants:
            value = constants[value]
        header = header.replace(key, value)
    with open(header_file, 'w') as file:
        file.write(header)
    with open(init, 'w') as file:
        file.write('# generated with mkcffi\n')
        file.write('import os\n')
        file.write('from cffi import FFI\n')
        file.write('from constants import *\n\n')
        file.write('ffi = FFI()\n')
        file.write("with open(os.path.join(os.path.dirname(__file__), 'cffi_header.h')) as file:\n")
        file.write('    header = file.read()\n')
        file.write('ffi.cdef(header)\n')
        file.write('FIXME = ffi.dlopen(FIXME)\n')
    with open(constants_file, 'w') as file:
        file.write('# generated with mkcffi\n')
        for key, value in constants.iteritems():
            file.write('%s = %s\n' % (key, value))


def main():
    if len(sys.argv) > 1:
        for filename in sys.argv[1:]:
            mkcffi(filename)

if __name__ == '__main__':
    main()
