/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.test;

import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;

final class Helper {
    private Helper() {
    }

    private static File getFile(String clazz) {
        return new File("./test-classes", String.valueOf(clazz) + ".java");
    }

    public static CompilationUnit parserClass(String clazz) throws ParseException {
        try {
            return JavaParser.parse(Helper.getFile(clazz));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompilationUnit parserString(String source) throws ParseException {
        return JavaParser.parse(new StringBufferInputStream(source));
    }

    public static String readFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            String line;
            StringBuilder ret = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                ret.append(line);
                ret.append("\n");
            }
            String string = ret.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String readClass(String clazz) throws IOException {
        return Helper.readFile(Helper.getFile(clazz));
    }
}

