/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileWriter;
import java.io.Writer;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.Util;

public class FormFieldCSVOutput {
    private static Map<String, String[]> newValuesMap = new LinkedHashMap<String, String[]>();

    static {
        newValuesMap.put("Name", new String[]{"Humphrey Bear"});
        newValuesMap.put("Title", new String[]{"Prime Minister"});
        newValuesMap.put("Member", new String[]{"on"});
        newValuesMap.put("Address", new String[]{"The Lodge\nDeakin  ACT  2600\nAustralia"});
        newValuesMap.put("MailingList", new String[]{"A", "B"});
        newValuesMap.put("FavouriteFare", new String[]{"honey"});
        newValuesMap.put("FavouriteSports", new String[]{"BB", "AFL"});
    }

    public static void main(String[] args) throws Exception {
        String sourceUrlString = "data/form.html";
        if (args.length == 0) {
            System.err.println("Using default argument of \"" + sourceUrlString + '\"');
        } else {
            sourceUrlString = args[0];
        }
        if (sourceUrlString.indexOf(58) == -1) {
            sourceUrlString = "file:" + sourceUrlString;
        }
        Source source = new Source(new URL(sourceUrlString));
        FormFields formFields = source.getFormFields();
        FileWriter out = new FileWriter("FormData.csv");
        Util.outputCSVLine(out, formFields.getColumnLabels());
        Util.outputCSVLine(out, formFields.getColumnValues(newValuesMap));
        ((Writer)out).close();
        System.err.println("\nThe following form submission data has been output to the CSV file \nFormData.csv, based on the data structure defined in the HTML document \n" + sourceUrlString + '\n');
        System.err.println(FormFieldCSVOutput.format(newValuesMap));
        System.err.println("The FormData.csv file will open automatically after you press a key.");
    }

    private static String format(Map<String, String[]> valuesMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : valuesMap.entrySet()) {
            sb.append(entry.getKey()).append(":\n");
            String[] stringArray = entry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                sb.append("- ").append(value).append('\n');
                ++n2;
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

