/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import net.htmlparser.jericho.OutputSegment;
import net.htmlparser.jericho.Segment;

final class BlankOutputSegment
implements OutputSegment {
    private final int begin;
    private final int end;

    public BlankOutputSegment(int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    public BlankOutputSegment(Segment segment) {
        this(segment.getBegin(), segment.getEnd());
    }

    @Override
    public int getBegin() {
        return this.begin;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        int i = this.begin;
        while (i < this.end) {
            appendable.append(' ');
            ++i;
        }
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        return this.end - this.begin;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.end - this.begin);
        int i = this.begin;
        while (i < this.end) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getDebugInfo() {
        return "Replace with Spaces: (p" + this.begin + "-p" + this.end + ')';
    }
}

