/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.ParseText;

class CharSequenceParseText
implements ParseText {
    private final CharSequence charSequence;

    CharSequenceParseText(CharSequence charSequence) {
        this.charSequence = charSequence;
    }

    @Override
    public final char charAt(int index) {
        char ch = this.charSequence.charAt(index);
        return ch >= 'A' && ch <= 'Z' ? (char)(ch ^ 0x20) : ch;
    }

    @Override
    public final boolean containsAt(String str, int pos) {
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) != this.charAt(pos + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final int indexOf(char searchChar, int fromIndex) {
        return this.indexOf(searchChar, fromIndex, -1);
    }

    @Override
    public final int indexOf(char searchChar, int fromIndex, int breakAtIndex) {
        int actualBreakAtIndex = breakAtIndex == -1 || breakAtIndex > this.getEnd() ? this.getEnd() : breakAtIndex;
        try {
            int i = fromIndex < 0 ? 0 : fromIndex;
            while (i < actualBreakAtIndex) {
                if (this.charAt(i) == searchChar) {
                    return i;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public final int indexOf(String searchString, int fromIndex) {
        return this.indexOf(searchString, fromIndex, -1);
    }

    @Override
    public final int indexOf(String searchString, int fromIndex, int breakAtIndex) {
        if (searchString.length() == 1) {
            return this.indexOf(searchString.charAt(0), fromIndex, breakAtIndex);
        }
        if (searchString.length() == 0) {
            return fromIndex;
        }
        char firstChar = searchString.charAt(0);
        int lastPossibleBreakAtIndex = this.getEnd() - searchString.length() + 1;
        int actualBreakAtIndex = breakAtIndex == -1 || breakAtIndex > lastPossibleBreakAtIndex ? lastPossibleBreakAtIndex : breakAtIndex;
        int i = fromIndex < 0 ? 0 : fromIndex;
        while (i < actualBreakAtIndex) {
            block6: {
                if (this.charAt(i) == firstChar) {
                    int j = 1;
                    while (j < searchString.length()) {
                        if (searchString.charAt(j) == this.charAt(j + i)) {
                            ++j;
                            continue;
                        }
                        break block6;
                    }
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(char searchChar, int fromIndex) {
        return this.lastIndexOf(searchChar, fromIndex, -1);
    }

    @Override
    public final int lastIndexOf(char searchChar, int fromIndex, int breakAtIndex) {
        int i = fromIndex > this.getEnd() ? this.getEnd() : fromIndex;
        while (i > breakAtIndex) {
            if (this.charAt(i) == searchChar) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(String searchString, int fromIndex) {
        return this.lastIndexOf(searchString, fromIndex, -1);
    }

    @Override
    public final int lastIndexOf(String searchString, int fromIndex, int breakAtIndex) {
        if (searchString.length() == 1) {
            return this.lastIndexOf(searchString.charAt(0), fromIndex, breakAtIndex);
        }
        if (searchString.length() == 0) {
            return fromIndex;
        }
        int rightIndex = this.getEnd() - searchString.length();
        if (breakAtIndex > rightIndex) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        int lastCharIndex = searchString.length() - 1;
        char lastChar = searchString.charAt(lastCharIndex);
        int actualBreakAtPos = breakAtIndex + lastCharIndex;
        int i = fromIndex + lastCharIndex;
        while (i > actualBreakAtPos) {
            block8: {
                if (this.charAt(i) == lastChar) {
                    int startIndex = i - lastCharIndex;
                    int j = lastCharIndex - 1;
                    while (j >= 0) {
                        if (searchString.charAt(j) == this.charAt(j + startIndex)) {
                            --j;
                            continue;
                        }
                        break block8;
                    }
                    return startIndex;
                }
            }
            --i;
        }
        return -1;
    }

    @Override
    public final int length() {
        return this.charSequence.length();
    }

    @Override
    public final CharSequence subSequence(int begin, int end) {
        return this.substring(begin, end);
    }

    @Override
    public final String toString() {
        return this.charSequence.toString();
    }

    protected int getEnd() {
        return this.charSequence.length();
    }

    protected String substring(int begin, int end) {
        return this.charSequence.subSequence(begin, end).toString().toLowerCase();
    }
}

