/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import net.htmlparser.jericho.CharacterEntityReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.NumericCharacterReference;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StreamedSource;

public abstract class CharacterReference
extends Segment {
    int codePoint;
    public static final int INVALID_CODE_POINT = -1;
    static int MAX_ENTITY_REFERENCE_LENGTH;
    private static final int TAB_LENGTH = 4;

    CharacterReference(Source source, int begin, int end, int codePoint) {
        super(source, begin, end);
        this.codePoint = codePoint;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public char getChar() {
        return (char)this.codePoint;
    }

    public final void appendCharTo(Appendable appendable) throws IOException {
        this.appendCharTo(appendable, Config.ConvertNonBreakingSpaces);
    }

    private void appendCharTo(Appendable appendable, boolean convertNonBreakingSpaces) throws IOException {
        if (Character.isSupplementaryCodePoint(this.codePoint)) {
            appendable.append(CharacterReference.getHighSurrogate(this.codePoint));
            appendable.append(CharacterReference.getLowSurrogate(this.codePoint));
        } else {
            char ch = this.getChar();
            if (ch == '\u00a0' && convertNonBreakingSpaces) {
                appendable.append(' ');
            } else {
                appendable.append(ch);
            }
        }
    }

    public boolean isTerminated() {
        return this.source.charAt(this.end - 1) == ';';
    }

    public static String encode(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        try {
            return CharacterReference.appendEncode(new StringBuilder(unencodedText.length() * 2), unencodedText, false).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String encode(char ch) {
        try {
            return CharacterReference.appendEncode(new StringBuilder(MAX_ENTITY_REFERENCE_LENGTH), ch).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String encodeWithWhiteSpaceFormatting(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        try {
            return CharacterReference.appendEncode(new StringBuilder(unencodedText.length() * 2), unencodedText, true).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decode(CharSequence encodedText) {
        return CharacterReference.decode(encodedText, false, Config.ConvertNonBreakingSpaces);
    }

    public static String decode(CharSequence encodedText, boolean insideAttributeValue) {
        return CharacterReference.decode(encodedText, insideAttributeValue, Config.ConvertNonBreakingSpaces);
    }

    static String decode(CharSequence encodedText, boolean insideAttributeValue, boolean convertNonBreakingSpaces) {
        if (encodedText == null) {
            return null;
        }
        int i = 0;
        while (i < encodedText.length()) {
            if (encodedText.charAt(i) == '&') {
                try {
                    return CharacterReference.appendDecode(new StringBuilder(encodedText.length()), encodedText, i, insideAttributeValue, convertNonBreakingSpaces).toString();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            ++i;
        }
        return encodedText.toString();
    }

    public static String decodeCollapseWhiteSpace(CharSequence text) {
        return CharacterReference.decodeCollapseWhiteSpace(text, Config.ConvertNonBreakingSpaces);
    }

    static String decodeCollapseWhiteSpace(CharSequence text, boolean convertNonBreakingSpaces) {
        return CharacterReference.decode(CharacterReference.appendCollapseWhiteSpace(new StringBuilder(text.length()), text), false, convertNonBreakingSpaces);
    }

    public static String reencode(CharSequence encodedText) {
        return CharacterReference.encode(CharacterReference.decode(encodedText, true));
    }

    public abstract String getCharacterReferenceString();

    public static String getCharacterReferenceString(int codePoint) {
        String characterReferenceString = null;
        if (codePoint != 39) {
            characterReferenceString = CharacterEntityReference.getCharacterReferenceString(codePoint);
        }
        if (characterReferenceString == null) {
            characterReferenceString = NumericCharacterReference.getCharacterReferenceString(codePoint);
        }
        return characterReferenceString;
    }

    public String getDecimalCharacterReferenceString() {
        return CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getDecimalCharacterReferenceString(int codePoint) {
        try {
            return CharacterReference.appendDecimalCharacterReferenceString(new StringBuilder(), codePoint).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getHexadecimalCharacterReferenceString() {
        return CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint);
    }

    public static String getHexadecimalCharacterReferenceString(int codePoint) {
        try {
            return CharacterReference.appendHexadecimalCharacterReferenceString(new StringBuilder(), codePoint).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getUnicodeText() {
        return CharacterReference.getUnicodeText(this.codePoint);
    }

    public static String getUnicodeText(int codePoint) {
        try {
            return CharacterReference.appendUnicodeText(new StringBuilder(), codePoint).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static final Appendable appendUnicodeText(Appendable appendable, int codePoint) throws IOException {
        appendable.append("U+");
        String hex = Integer.toString(codePoint, 16).toUpperCase();
        int i = 4 - hex.length();
        while (i > 0) {
            appendable.append('0');
            --i;
        }
        appendable.append(hex);
        return appendable;
    }

    public static CharacterReference parse(CharSequence characterReferenceText) {
        return CharacterReference.construct(new Source(characterReferenceText, true), 0, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    public static int getCodePointFromCharacterReferenceString(CharSequence characterReferenceText) {
        CharacterReference characterReference = CharacterReference.parse(characterReferenceText);
        return characterReference != null ? characterReference.getCodePoint() : -1;
    }

    public static final boolean requiresEncoding(char ch) {
        return ch > '\u007f' || CharacterEntityReference.getName(ch) != null && (ch != '\'' || Config.IsApostropheEncoded);
    }

    public static Writer getEncodingFilterWriter(Writer writer) {
        return new EncodingFilterWriter(writer);
    }

    private static Appendable appendEncode(Appendable appendable, char ch) throws IOException {
        if (CharacterReference.appendEncodeCheckForWhiteSpaceFormatting(appendable, ch, false)) {
            return appendable;
        }
        return appendable.append(ch);
    }

    static Appendable appendEncode(Appendable appendable, CharSequence unencodedText, boolean whiteSpaceFormatting) throws IOException {
        if (unencodedText == null) {
            return appendable;
        }
        int beginPos = 0;
        int endPos = unencodedText.length();
        if (unencodedText instanceof Segment) {
            int segmentOffset;
            Segment segment = (Segment)unencodedText;
            beginPos = segmentOffset = segment.getBegin();
            endPos += segmentOffset;
            unencodedText = segment.source;
        }
        boolean isApostropheEncoded = Config.IsApostropheEncoded;
        int i = beginPos;
        while (i < endPos) {
            block11: {
                int spaceCount;
                int nexti;
                char ch;
                block14: {
                    block12: {
                        block13: {
                            ch = unencodedText.charAt(i);
                            if (CharacterReference.appendEncodeCheckForWhiteSpaceFormatting(appendable, ch, whiteSpaceFormatting)) break block11;
                            nexti = i + 1;
                            if (ch == ' ') break block12;
                            if (ch == '\t') break block13;
                            if (ch == '\r' && nexti < endPos && unencodedText.charAt(nexti) == '\n') {
                                ++i;
                            }
                            appendable.append("<br />");
                            break block11;
                        }
                        spaceCount = 4;
                        break block14;
                    }
                    spaceCount = 1;
                }
                while (nexti < endPos) {
                    ch = unencodedText.charAt(nexti);
                    if (ch == ' ') {
                        ++spaceCount;
                    } else {
                        if (ch != '\t') break;
                        spaceCount += 4;
                    }
                    ++nexti;
                }
                if (spaceCount == 1) {
                    appendable.append(' ');
                } else {
                    if (spaceCount % 2 == 1) {
                        appendable.append(' ');
                    }
                    while (spaceCount >= 2) {
                        appendable.append("&nbsp; ");
                        spaceCount -= 2;
                    }
                    i = nexti - 1;
                }
            }
            ++i;
        }
        return appendable;
    }

    private static final boolean appendEncodeCheckForWhiteSpaceFormatting(Appendable appendable, char ch, boolean whiteSpaceFormatting) throws IOException {
        String characterEntityReferenceName = CharacterEntityReference.getName(ch);
        if (characterEntityReferenceName != null) {
            if (ch == '\'') {
                if (Config.IsApostropheEncoded) {
                    appendable.append("&#39;");
                } else {
                    appendable.append(ch);
                }
            } else {
                CharacterEntityReference.appendCharacterReferenceString(appendable, characterEntityReferenceName);
            }
        } else if (ch > '\u007f') {
            CharacterReference.appendDecimalCharacterReferenceString(appendable, ch);
        } else if (!whiteSpaceFormatting || !CharacterReference.isWhiteSpace(ch)) {
            appendable.append(ch);
        } else {
            return false;
        }
        return true;
    }

    static CharacterReference getPrevious(Source source, int pos) {
        return CharacterReference.getPrevious(source, pos, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    static CharacterReference getNext(Source source, int pos) {
        return CharacterReference.getNext(source, pos, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    private static CharacterReference getPrevious(Source source, int pos, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        ParseText parseText = source.getParseText();
        pos = parseText.lastIndexOf('&', pos);
        while (pos != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, pos, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            pos = parseText.lastIndexOf('&', pos - 1);
        }
        return null;
    }

    private static CharacterReference getNext(Source source, int pos, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        ParseText parseText = source.getParseText();
        pos = parseText.indexOf('&', pos);
        while (pos != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, pos, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            pos = parseText.indexOf('&', pos + 1);
        }
        return null;
    }

    static final Appendable appendHexadecimalCharacterReferenceString(Appendable appendable, int codePoint) throws IOException {
        return appendable.append("&#x").append(Integer.toString(codePoint, 16)).append(';');
    }

    static final Appendable appendDecimalCharacterReferenceString(Appendable appendable, int codePoint) throws IOException {
        return appendable.append("&#").append(Integer.toString(codePoint)).append(';');
    }

    static CharacterReference construct(Source source, int begin, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        block3: {
            try {
                if (source.getParseText().charAt(begin) == '&') break block3;
                return null;
            }
            catch (IndexOutOfBoundsException ex) {
                return null;
            }
        }
        return source.getParseText().charAt(begin + 1) == '#' ? NumericCharacterReference.construct(source, begin, unterminatedCharacterReferenceSettings) : CharacterEntityReference.construct(source, begin, unterminatedCharacterReferenceSettings.characterEntityReferenceMaxCodePoint);
    }

    private static Appendable appendDecode(Appendable appendable, CharSequence encodedText, int pos, boolean insideAttributeValue, boolean convertNonBreakingSpaces) throws IOException {
        Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(insideAttributeValue);
        boolean lastEnd = false;
        StreamedSource streamedSource = new StreamedSource(encodedText).setHandleTags(false).setUnterminatedCharacterReferenceSettings(unterminatedCharacterReferenceSettings).setSearchBegin(pos);
        for (Segment segment : streamedSource) {
            if (segment instanceof CharacterReference) {
                ((CharacterReference)segment).appendCharTo(appendable, convertNonBreakingSpaces);
                continue;
            }
            appendable.append(segment.toString());
        }
        return appendable;
    }

    private static char getHighSurrogate(int codePoint) {
        return (char)(55232 + (codePoint >> 10));
    }

    private static char getLowSurrogate(int codePoint) {
        return (char)(56320 + (codePoint & 0x3FF));
    }

    private static final class EncodingFilterWriter
    extends FilterWriter {
        StringBuilder sb = new StringBuilder(MAX_ENTITY_REFERENCE_LENGTH);

        public EncodingFilterWriter(Writer writer) {
            super(writer);
        }

        public void write(char ch) throws IOException {
            this.sb.setLength(0);
            CharacterReference.appendEncode(this.sb, ch);
            if (this.sb.length() == 1) {
                this.out.write(this.sb.charAt(0));
            } else {
                this.out.append(this.sb);
            }
        }

        @Override
        public void write(int chInt) throws IOException {
            this.write((char)chInt);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int end = off + len;
            int i = off;
            while (i < end) {
                this.write(cbuf[i]);
                ++i;
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            int end = off + len;
            int i = off;
            while (i < end) {
                this.write(str.charAt(i));
                ++i;
            }
        }
    }
}

