/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;

public final class EndTag
extends Tag {
    private final EndTagType endTagType;

    EndTag(Source source, int begin, int end, EndTagType endTagType, String name) {
        super(source, begin, end, name);
        this.endTagType = endTagType;
    }

    @Override
    public Element getElement() {
        if (this.element != Element.NOT_CACHED) {
            return this.element;
        }
        int pos = this.begin;
        while (pos != 0) {
            StartTag startTag = this.source.getPreviousStartTag(pos - 1);
            if (startTag == null) break;
            Element foundElement = startTag.getElement();
            if (foundElement.getEndTag() == this) {
                return foundElement;
            }
            pos = startTag.begin;
        }
        this.element = null;
        return null;
    }

    public EndTagType getEndTagType() {
        return this.endTagType;
    }

    @Override
    public TagType getTagType() {
        return this.endTagType;
    }

    @Override
    public boolean isUnregistered() {
        return this.endTagType == EndTagType.UNREGISTERED;
    }

    @Override
    public String tidy() {
        String string = this.toString();
        if (this.endTagType != EndTagType.NORMAL) {
            return string;
        }
        if (!CharacterReference.isWhiteSpace(string.charAt(string.length() - 2))) {
            return string;
        }
        int i = string.length() - 3;
        while (i > 0 && CharacterReference.isWhiteSpace(string.charAt(i))) {
            --i;
        }
        return String.valueOf(string.substring(0, i + 1)) + '>';
    }

    public static String generateHTML(String tagName) {
        return EndTagType.NORMAL.generateHTML(tagName);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this).append(' ');
        if (this.endTagType != EndTagType.NORMAL) {
            sb.append('(').append(this.endTagType.getDescription()).append(") ");
        }
        sb.append(super.getDebugInfo());
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static EndTag getPrevious(Source source, int pos, String name, EndTagType endTagType) {
        if (name == null) {
            return (EndTag)Tag.getPreviousTag(source, pos, endTagType);
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name argument must not be zero length");
        }
        String searchString = String.valueOf("</") + name;
        ParseText parseText = source.getParseText();
        int begin = pos;
        do {
            if ((begin = parseText.lastIndexOf(searchString, begin)) == -1) {
                return null;
            }
            EndTag endTag = (EndTag)source.getTagAt(begin);
            if (endTag == null || endTag.getEndTagType() != endTagType || !name.equals(endTag.getName())) continue;
            return endTag;
        } while (--begin >= 0);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static EndTag getNext(Source source, int pos, String name, EndTagType endTagType) {
        if (name == null) {
            return (EndTag)Tag.getNextTag(source, pos, endTagType);
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name argument must not be zero length");
        }
        String searchString = String.valueOf("</") + name;
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                if ((begin = parseText.indexOf(searchString, begin)) == -1) {
                    return null;
                }
                EndTag endTag = (EndTag)source.getTagAt(begin);
                if (endTag == null || endTag.getEndTagType() != endTagType || !name.equals(endTag.getName())) continue;
                return endTag;
            } while (++begin < source.end);
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static EndTag getPrevious(Source source, int pos) {
        Tag tag;
        while ((tag = Tag.getPreviousTag(source, pos)) != null) {
            if (tag instanceof EndTag) {
                return (EndTag)tag;
            }
            --pos;
        }
        return null;
    }

    static EndTag getNext(Source source, int pos) {
        Tag tag;
        while ((tag = Tag.getNextTag(source, pos)) != null) {
            if (tag instanceof EndTag) {
                return (EndTag)tag;
            }
            ++pos;
        }
        return null;
    }
}

