/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.HashMap;
import java.util.HashSet;

public enum FormControlType {
    BUTTON("button", true, true),
    CHECKBOX("input", true, false),
    FILE("input", false, false),
    HIDDEN("input", false, false),
    IMAGE("input", true, true),
    PASSWORD("input", false, false),
    RADIO("input", true, false),
    SELECT_MULTIPLE("select", true, false),
    SELECT_SINGLE("select", true, false),
    SUBMIT("input", true, true),
    TEXT("input", false, false),
    TEXTAREA("textarea", false, false);

    private String elementName;
    private boolean hasPredefinedValue;
    private boolean submit;
    private static final HashMap<String, FormControlType> INPUT_ELEMENT_TYPE_MAP;
    private static final HashSet<String> NON_FORM_CONTROL_TYPE_ATTRIBUTE_SET;

    static {
        INPUT_ELEMENT_TYPE_MAP = new HashMap(11, 1.0f);
        NON_FORM_CONTROL_TYPE_ATTRIBUTE_SET = new HashSet(3, 1.0f);
        INPUT_ELEMENT_TYPE_MAP.put("checkbox", CHECKBOX);
        INPUT_ELEMENT_TYPE_MAP.put("file", FILE);
        INPUT_ELEMENT_TYPE_MAP.put("hidden", HIDDEN);
        INPUT_ELEMENT_TYPE_MAP.put("image", IMAGE);
        INPUT_ELEMENT_TYPE_MAP.put("password", PASSWORD);
        INPUT_ELEMENT_TYPE_MAP.put("radio", RADIO);
        INPUT_ELEMENT_TYPE_MAP.put("submit", SUBMIT);
        INPUT_ELEMENT_TYPE_MAP.put("text", TEXT);
        NON_FORM_CONTROL_TYPE_ATTRIBUTE_SET.add("button");
        NON_FORM_CONTROL_TYPE_ATTRIBUTE_SET.add("reset");
    }

    private FormControlType(String elementName, boolean hasPredefinedValue, boolean submit) {
        this.elementName = elementName;
        this.hasPredefinedValue = hasPredefinedValue;
        this.submit = submit;
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean hasPredefinedValue() {
        return this.hasPredefinedValue;
    }

    public boolean isSubmit() {
        return this.submit;
    }

    static FormControlType getFromInputElementType(String typeAttributeValue) {
        return INPUT_ELEMENT_TYPE_MAP.get(typeAttributeValue.toLowerCase());
    }

    static boolean isNonFormControl(String typeAttributeValue) {
        return NON_FORM_CONTROL_TYPE_ATTRIBUTE_SET.contains(typeAttributeValue.toLowerCase());
    }
}

