/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.List;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.MicrosoftConditionalCommentTagTypes;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import org.junit.Assert;
import org.junit.Test;

public class MicrosoftConditionalCommentTagTypesTest {
    @Test
    public void testDownlevelHidden() throws Exception {
        String sourceText = "<!--[if IE]><p>content</p><![endif]-->";
        MicrosoftConditionalCommentTagTypes.register();
        Source source = new Source(sourceText);
        List<Tag> tags = source.getAllTags();
        Assert.assertEquals((long)4L, (long)tags.size());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_HIDDEN_IF, (Object)tags.get(0).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(1).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(2).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_HIDDEN_ENDIF, (Object)tags.get(3).getTagType());
        MicrosoftConditionalCommentTagTypes.deregister();
        source = new Source(sourceText);
        tags = source.getAllTags();
        Assert.assertEquals((long)1L, (long)tags.size());
        Assert.assertSame((Object)StartTagType.COMMENT, (Object)tags.get(0).getTagType());
    }

    @Test
    public void testNonValidatingDownlevelRevealed() throws Exception {
        String sourceText = "<![if !IE]><p>content</p><![endif]>";
        MicrosoftConditionalCommentTagTypes.register();
        Source source = new Source(sourceText);
        List<Tag> tags = source.getAllTags();
        Assert.assertEquals((long)4L, (long)tags.size());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_IF, (Object)tags.get(0).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(1).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(2).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_ENDIF, (Object)tags.get(3).getTagType());
        MicrosoftConditionalCommentTagTypes.deregister();
        source = new Source(sourceText);
        tags = source.getAllTags();
        Assert.assertEquals((long)2L, (long)tags.size());
        Assert.assertSame((Object)StartTagType.UNREGISTERED, (Object)source.getTagAt(0).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(0).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(1).getTagType());
    }

    @Test
    public void testValidatingDownlevelRevealed() throws Exception {
        String sourceText = "<!--[if !(IE 5)]><!--><p>content</p><!--<![endif]-->";
        MicrosoftConditionalCommentTagTypes.register();
        Source source = new Source(sourceText);
        List<Tag> tags = source.getAllTags();
        Assert.assertEquals((long)4L, (long)tags.size());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_IF, (Object)tags.get(0).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(1).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(2).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_ENDIF, (Object)tags.get(3).getTagType());
        MicrosoftConditionalCommentTagTypes.deregister();
        source = new Source(sourceText);
        tags = source.getAllTags();
        Assert.assertEquals((long)4L, (long)tags.size());
        Assert.assertSame((Object)StartTagType.COMMENT, (Object)tags.get(0).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(1).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(2).getTagType());
        Assert.assertSame((Object)StartTagType.COMMENT, (Object)tags.get(3).getTagType());
        MicrosoftConditionalCommentTagTypes.register();
        source = new Source("<!--[if IE]>content1<![endif]-->...<!--[if !(IE 5)]><!-->content2<!--<![endif]-->");
        tags = source.getAllTags();
        Assert.assertEquals((long)4L, (long)tags.size());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_HIDDEN_IF, (Object)tags.get(0).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_HIDDEN_ENDIF, (Object)tags.get(1).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_IF, (Object)tags.get(2).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_ENDIF, (Object)tags.get(3).getTagType());
        MicrosoftConditionalCommentTagTypes.deregister();
    }

    @Test
    public void testValidatingDownlevelRevealedSimplified() throws Exception {
        String sourceText = "<!--[if !IE]>--><p>content</p><!--<![endif]-->";
        MicrosoftConditionalCommentTagTypes.register();
        Source source = new Source(sourceText);
        List<Tag> tags = source.getAllTags();
        Assert.assertEquals((long)4L, (long)tags.size());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_SIMPLIFIED_IF, (Object)tags.get(0).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(1).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(2).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_ENDIF, (Object)tags.get(3).getTagType());
        MicrosoftConditionalCommentTagTypes.deregister();
        source = new Source(sourceText);
        tags = source.getAllTags();
        Assert.assertEquals((long)4L, (long)tags.size());
        Assert.assertSame((Object)StartTagType.COMMENT, (Object)tags.get(0).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(1).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(2).getTagType());
        Assert.assertSame((Object)StartTagType.COMMENT, (Object)tags.get(3).getTagType());
        MicrosoftConditionalCommentTagTypes.register();
        source = new Source("<!--[if IE]>content1<![endif]-->...<!--[if !IE]>-->content2<!--<![endif]-->");
        tags = source.getAllTags();
        Assert.assertEquals((long)4L, (long)tags.size());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_HIDDEN_IF, (Object)tags.get(0).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_HIDDEN_ENDIF, (Object)tags.get(1).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_SIMPLIFIED_IF, (Object)tags.get(2).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_ENDIF, (Object)tags.get(3).getTagType());
        source = new Source("<!--[if IE]><p>This demonstrates <![if IE 7]>the use of<![endif]> <b>nested</b> downlevel-hidden conditional comments.</p><![endif]--> <!--[if !(IE 5)]><!--><p>This demonstrates <!--[if true]><!-->the use of<!--<![endif]--> <b>nested</b> downlevel-revealed conditional comments.</p><!--<![endif]-->");
        tags = source.getAllTags();
        Assert.assertEquals((long)16L, (long)tags.size());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_HIDDEN_IF, (Object)tags.get(0).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(1).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_IF, (Object)tags.get(2).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_ENDIF, (Object)tags.get(3).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(4).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(5).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(6).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_HIDDEN_ENDIF, (Object)tags.get(7).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_IF, (Object)tags.get(8).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(9).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_IF, (Object)tags.get(10).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_ENDIF, (Object)tags.get(11).getTagType());
        Assert.assertSame((Object)StartTagType.NORMAL, (Object)tags.get(12).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(13).getTagType());
        Assert.assertSame((Object)EndTagType.NORMAL, (Object)tags.get(14).getTagType());
        Assert.assertSame((Object)MicrosoftConditionalCommentTagTypes.DOWNLEVEL_REVEALED_VALIDATING_ENDIF, (Object)tags.get(15).getTagType());
        MicrosoftConditionalCommentTagTypes.deregister();
    }
}

