/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.StartTagTypePHPScript;
import net.htmlparser.jericho.StartTagTypePHPShort;
import net.htmlparser.jericho.StartTagTypePHPStandard;
import net.htmlparser.jericho.TagType;

public final class PHPTagTypes {
    public static final StartTagType PHP_STANDARD = StartTagTypePHPStandard.INSTANCE;
    public static final StartTagType PHP_SHORT = StartTagTypePHPShort.INSTANCE;
    public static final StartTagType PHP_SCRIPT = StartTagTypePHPScript.INSTANCE;
    private static final TagType[] TAG_TYPES = new TagType[]{PHP_STANDARD, PHP_SHORT, PHP_SCRIPT};

    private PHPTagTypes() {
    }

    public static void register() {
        TagType[] tagTypeArray = TAG_TYPES;
        int n = TAG_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            TagType tagType = tagTypeArray[n2];
            tagType.register();
            ++n2;
        }
    }

    public static void deregister() {
        TagType[] tagTypeArray = TAG_TYPES;
        int n = TAG_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            TagType tagType = tagTypeArray[n2];
            tagType.deregister();
            ++n2;
        }
    }

    public static boolean defines(TagType tagType) {
        TagType[] tagTypeArray = TAG_TYPES;
        int n = TAG_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            TagType definedTagType = tagTypeArray[n2];
            if (tagType == definedTagType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isParsedByPHP(TagType tagType) {
        return tagType == StartTagType.SERVER_COMMON || PHPTagTypes.defines(tagType);
    }
}

