/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.junit.Assert;
import org.junit.Test;

public class RendererTest {
    @Test
    public void testBasics() throws Exception {
        Assert.assertEquals((Object)"text", (Object)this.render("text"));
        Assert.assertEquals((Object)"This is a long sentence that should be broken into multiple lines at word \nboundaries, with each line no longer than the default 76 character maximum \nline length.", (Object)this.render("This is a long sentence that should be broken into multiple lines at word boundaries, with each line no longer than the default 76 character maximum  line length."));
        Assert.assertEquals((Object)"text", (Object)this.render("te<applet>xyz</applet>xt"));
    }

    @Test
    public void testWhiteSpace() throws Exception {
        Assert.assertEquals((Object)" basic test", (Object)this.render(" basic   test "));
        Assert.assertEquals((Object)"basic  test", (Object)this.render("basic&nbsp; test"));
        Assert.assertEquals((Object)"basic\u00a0 test", (Object)this.renderer("basic&nbsp; test").setConvertNonBreakingSpaces(false).toString());
        Assert.assertEquals((Object)"basic test\nx", (Object)this.render("<div> basic test </div> x"));
        Assert.assertEquals((Object)"basic test", (Object)this.render("<div><span> basic test </span></div>"));
        Assert.assertEquals((Object)"x basic testy", (Object)this.render("<div>x<span> basic test</span>y</div>"));
        Assert.assertEquals((Object)"basic\ntest", (Object)this.render("basic<br>test"));
        Assert.assertEquals((Object)"basic\r\ntest", (Object)new Renderer(new Source("basic<br>test")).toString());
    }

    @Test
    public void testVerticalMargins() throws Exception {
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div>b</div>c"));
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div> <div> b </div> </div>c"));
        Assert.assertEquals((Object)"a\n\nb\n\nc", (Object)this.render("a <p> b </p> c"));
        Assert.assertEquals((Object)"text", (Object)this.render("<p> text </p>"));
        Assert.assertEquals((Object)"\nx", (Object)this.render("<br>x"));
        Assert.assertEquals((Object)"a\n\nb\n\nc", (Object)this.render("<p> a </p><p> b </p> c"));
        Assert.assertEquals((Object)"x\na\n\nb\n\nc", (Object)this.render("x <div> a <p> b </p></div> c"));
        Assert.assertEquals((Object)"a\n\n\nb\n\nc", (Object)this.render("<p> a </p><h1> b </h1> c"));
        Assert.assertEquals((Object)"Heading\n\nparagraph", (Object)this.render("<h1>Heading</h1><p>paragraph</p>"));
        Assert.assertEquals((Object)"\n\nHeading\n\nparagraph", (Object)this.renderer("<h1>Heading</h1><p>paragraph</p>").setIncludeFirstElementTopMargin(true).toString());
    }

    @Test
    public void testCSS() throws Exception {
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div style='font-size: 10pt; font-family: arial'>b</div>c"));
        Assert.assertEquals((Object)"a\n\nb\nc", (Object)this.render("a<div style='font-size: 10pt; margin-top: 1em ; font-family: arial'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n   b\n\n\nc", (Object)this.render("a<div style=' margin: 1em 0 2em 3em'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n   b\n\n\nc", (Object)this.render("a<div style=' margin: 1em 3em 2em'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n   b\n\nc", (Object)this.render("a<div style=' margin: 1em 3em'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n b\n\nc", (Object)this.render("a<div style=' margin: 1em'>b</div>c"));
        Assert.assertEquals((Object)"a\n b\n\nc", (Object)this.render("a<div style='margin-top: 0; margin: 1em'>b</div>c"));
        Assert.assertEquals((Object)"a\nb\n\nc", (Object)this.render("a<p style='margin-top: 0'>b</p>c"));
        Assert.assertEquals((Object)"a\n\n    b\n\nc", (Object)this.render("a<blockquote>b</blockquote>c"));
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<blockquote style='margin: 0'>b</blockquote>c"));
        Assert.assertEquals((Object)"a\nb\n\nc", (Object)this.render("a<div style=' margin-bottom : 1em '>b</div>c"));
        Assert.assertEquals((Object)"x\n   a\n   b\ny", (Object)this.render("x<div style='margin-left: 1cm'>a<br>b</div>y"));
        Assert.assertEquals((Object)"a\n\nb\nc", (Object)this.render("a<div style='padding-top: 1em'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n\nb\nc", (Object)this.render("a<div style='padding-top: 1em; margin-top: 1em'>b</div>c"));
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div style='padding-top: auto; margin-top: 100%'>b</div>c"));
    }

    @Test
    public void testInvalidCSS() throws Exception {
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div style='margin'>b</div>c"));
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div style='margin-'>b</div>c"));
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div style='margin-bla'>b</div>c"));
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div style='margin-top'>b</div>c"));
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div style='margin-top:'>b</div>c"));
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div style='margin-top:bla'>b</div>c"));
        Assert.assertEquals((Object)"a\nb\nc", (Object)this.render("a<div style='margin-top:;'>b</div>c"));
    }

    @Test
    public void testCSSUnits() throws Exception {
        Assert.assertEquals((Object)"a\n\nb\nc", (Object)this.render("a<div style='margin-top: 1em'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n\nb\nc", (Object)this.render("a<div style='margin-top: 2em'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n\nb\nc", (Object)this.render("a<div style='margin-top: 2ex'>b</div>c"));
        Assert.assertEquals((Object)"a\n\nb\nc", (Object)this.render("a<div style='margin-top: 10px'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n\n\nb\nc", (Object)this.render("a<div style='margin-top: 20px'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n\n\n\nb\nc", (Object)this.render("a<div style='margin-top: 0.5in'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n\n\nb\nc", (Object)this.render("a<div style='margin-top: 1cm'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n\n\nb\nc", (Object)this.render("a<div style='margin-top: 10mm'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n\nb\nc", (Object)this.render("a<div style='margin-top: 20pt'>b</div>c"));
        Assert.assertEquals((Object)"a\n\n\nb\nc", (Object)this.render("a<div style='margin-top: 2pc'>b</div>c"));
    }

    @Test
    public void testBR() throws Exception {
        Assert.assertEquals((Object)"x\ny", (Object)this.render("x<br>y"));
        Assert.assertEquals((Object)"x\n\ny", (Object)this.render("x<br><br>y"));
        Assert.assertEquals((Object)"\nx\n", (Object)this.render("<br>x<br>"));
        Assert.assertEquals((Object)"    x\n    y", (Object)this.render("<blockquote>x<br>y</blockquote>"));
        Assert.assertEquals((Object)"    x\n    y", (Object)this.render("<blockquote>x <br> y</blockquote>"));
        Assert.assertEquals((Object)"    x\n\n    y", (Object)this.render("<blockquote><div>x</div><br>y</blockquote>"));
        Assert.assertEquals((Object)"    x\n    y", (Object)this.render("<blockquote>x<br><div>y</div></blockquote>"));
        Assert.assertEquals((Object)"    x\n\n    y", (Object)this.render("<blockquote>x<div><br>y</div></blockquote>"));
        Assert.assertEquals((Object)"    x\n    y\n    z", (Object)this.render("<blockquote>x<div>y<br></div>z</blockquote>"));
        Assert.assertEquals((Object)"    x\n    y\n\n    z", (Object)this.render("<blockquote>x<div>y<br></div><br>z</blockquote>"));
        Assert.assertEquals((Object)"    x\n\n    y", (Object)this.render("<blockquote><div>x</div><br><div>y</div></blockquote>"));
        Assert.assertEquals((Object)"    x\n\n\n    y", (Object)this.render("<blockquote><p>x</p><br><p>y</p></blockquote>"));
        Assert.assertEquals((Object)"    x\n\n\n\n    y", (Object)this.render("<blockquote><p>x</p><br><h1>y</h1></blockquote>"));
        Assert.assertEquals((Object)"    x\n\n\n        y", (Object)this.render("<blockquote>x<blockquote><br>y</blockquote></blockquote>"));
        Assert.assertEquals((Object)"    x\n        * \n          y", (Object)this.render("<blockquote>x<ul><li><br>y</ul></blockquote>"));
    }

    @Test
    public void testCustomisedBlockProperties() throws Exception {
        Assert.assertEquals((Object)"a\n\nb\n\nc", (Object)this.render("a<p>b</p>c"));
        int originalDefaultTopMargin = Renderer.getDefaultTopMargin("p");
        int originalDefaultBottomMargin = Renderer.getDefaultBottomMargin("p");
        boolean originalDefaultIndent = Renderer.isDefaultIndent("p");
        Renderer.setDefaultTopMargin("p", 0);
        Renderer.setDefaultBottomMargin("p", 2);
        Renderer.setDefaultIndent("p", true);
        Assert.assertEquals((Object)"a\n    b\n\n\nc", (Object)this.render("a<p>b</p>c"));
        Renderer.setDefaultTopMargin("p", originalDefaultTopMargin);
        Renderer.setDefaultBottomMargin("p", originalDefaultBottomMargin);
        Renderer.setDefaultIndent("p", originalDefaultIndent);
        Assert.assertEquals((Object)"a\n\nb\n\nc", (Object)this.render("a<p>b</p>c"));
    }

    @Test
    public void testBlockIndents() throws Exception {
        Assert.assertEquals((Object)"a\nb\n    c\nd", (Object)this.render("a<dl><dt>b</dt><dd>c</dd></dl>d"));
        Assert.assertEquals((Object)"a\n\n    b\n\nc", (Object)this.render("a<blockquote>b</blockquote>c"));
        Assert.assertEquals((Object)"    b", (Object)this.render("<blockquote>b</blockquote>"));
        Assert.assertEquals((Object)"a\n\n        b\n\nc", (Object)this.renderer("a<blockquote>b</blockquote>c").setBlockIndentSize(8).toString());
        Assert.assertEquals((Object)"x\n\n    a\n\n        b\n\n    c\n\ny", (Object)this.render("x<blockquote>a<blockquote>b</blockquote>c</blockquote>y"));
        Assert.assertEquals((Object)"x\n\n    a\n    b\n        c\n    d\n\ny", (Object)this.render("x<blockquote>a<dl><dt>b</dt><dd>c</dd></dl>d</blockquote>y"));
    }

    @Test
    public void testPRE() throws Exception {
        Assert.assertEquals((Object)"x\n\na\n\ny", (Object)this.render("x<pre>a</pre>y"));
        Assert.assertEquals((Object)"x\n\na  b\nc  \n\ny", (Object)this.render("x<pre>a  b\nc  </pre>y"));
        Assert.assertEquals((Object)"x\n\na  b \n c  \n\ny", (Object)this.render("x<pre>a  b \n c  </pre>y"));
        Assert.assertEquals((Object)"x\n\na*b*c\n\ny", (Object)this.renderer("x<pre>a<b>b</b>c</pre>y").setDecorateFontStyles(true).toString());
        Assert.assertEquals((Object)"    x\n\n    a  b\n    c  \n\n    y", (Object)this.render("<blockquote>x<pre>a  b\nc  </pre>y</blockquote>"));
    }

    @Test
    public void testLists() throws Exception {
        Assert.assertEquals((Object)"x\n    * a\n    * b\n    * c\n    * d\n    * e\n    * f\n    * g\n    * h\n    * i\n    * j\n    * k\n    * l\ny", (Object)this.render("x<ul><li>a<li>b<li>c<li>d<li>e<li>f<li>g<li>h<li>i<li>j<li>k<li>l</ul>y"));
        Assert.assertEquals((Object)"    * a\n    * b\n    * c", (Object)this.render("<ul><li>a<li>b<li>c</ul>"));
        Assert.assertEquals((Object)"    * a\n    * b\n    * c", (Object)this.render("<ul><li>a<li> b <li>c</ul>"));
        Assert.assertEquals((Object)"x\n   1. a\n   2. b\n   3. c\n   4. d\n   5. e\n   6. f\n   7. g\n   8. h\n   9. i\n  10. j\n  11. k\n  12. l\ny", (Object)this.render("x<ol><li>a<li>b<li>c<li>d<li>e<li>f<li>g<li>h<li>i<li>j<li>k<li>l</ol>y"));
        Assert.assertEquals((Object)"x\n    - a\n    - b\n    - c\ny", (Object)this.renderer("x<ul><li>a<li>b<li>c</ul>y").setListBullets(new char[]{'-'}).toString());
        Assert.assertEquals((Object)"x\n  * a\n  * b\n  * c\ny", (Object)this.renderer("x<ul><li>a<li>b<li>c</ul>y").setListIndentSize(4).toString());
        Assert.assertEquals((Object)"x\n    * a\n    * This is a long sentence that should be broken into multiple lines at\n      word boundaries, with each line no longer than the default 76\n      character maximum line length.\n    * c\ny", (Object)this.render("x<ul><li>a<li>This is a long sentence that should be broken into multiple lines at word boundaries, with each line no longer than the default 76 character maximum line length.<li>c</ul>y"));
        Assert.assertEquals((Object)"x\n    * a\n          o b\n          o c\n                + d\n                + e\n    * f\n    * g\n         1. h\n         2. i\n               1. j\n         3. k\n    * l\ny", (Object)this.render("x<ul><li>a<ul><li>b<li>c<ul><li>d<li>e</ul></ul><li>f<li>g<ol><li>h<li>i<ol><li>j</ol><li>k</ol><li>l</ul>y"));
        Assert.assertEquals((Object)"x\n    * a\n    * \n          o b\n    * c\ny", (Object)this.render("x<ul><li>a<li><ul><li>b</ul><li>c</ul>y"));
        Assert.assertEquals((Object)"x\n    * a\n    * b\n    * c\ny", (Object)this.render("x<ul><li>a<li><div>b</div><li>c</ul>y"));
        Assert.assertEquals((Object)"x\n    * a\n    * b\n\n    * c\ny", (Object)this.render("x<ul><li>a<li><p>b</p><li>c</ul>y"));
        Assert.assertEquals((Object)"x\n    * a\n    *     b\n          c\n\n    * d\ny", (Object)this.render("x<ul><li>a<li><blockquote><div> b</div><div>c</div></blockquote><li>d</ul>y"));
    }

    @Test
    public void testTable() throws Exception {
        Assert.assertEquals((Object)"x\nA \tB \tC\na \tb \tc\ny", (Object)this.render("x<table><tr><th>A<th>B<th>C<tr><td>a<td>b<td>c</table>y"));
        Assert.assertEquals((Object)"x\nA\tB\tC\na\tb\tc\ny", (Object)this.renderer("x<table><tr><th>A<th>B<th>C<tr><td>a<td>b<td>c</table>y").setTableCellSeparator("\t").toString());
    }

    @Test
    public void testA() throws Exception {
        Assert.assertEquals((Object)"My Link <http://mysite.com/>", (Object)this.render("<a href=\"http://mysite.com/\">My Link</a>"));
        Assert.assertEquals((Object)"<http://mysite.com/>", (Object)this.render("<a href=\"http://mysite.com/\">http://mysite.com/</a>"));
        Assert.assertEquals((Object)"<http://mysite.com/>", (Object)this.render("<a href=\"http://mysite.com/\">mysite.com</a>"));
        Assert.assertEquals((Object)"My link with a long label that goes close to the end of the line\n<http://mysite.com/>", (Object)this.render("<a href=\"http://mysite.com/\">My link with a long label that goes close to the end of the line</a>"));
        Assert.assertEquals((Object)"My Link", (Object)this.renderer("<a href=\"http://mysite.com/\">My Link</a>").setIncludeHyperlinkURLs(false).toString());
        Renderer customRenderer = new Renderer(new Source("<a href=\"http://mysite.com/\">My Link</a>")){

            @Override
            public String renderHyperlinkURL(StartTag startTag) {
                String href = startTag.getAttributeValue("href");
                if (href == null || href.equals("#") || href.startsWith("javascript:")) {
                    return null;
                }
                return href;
            }
        };
        Assert.assertEquals((Object)"My Link http://mysite.com/", (Object)customRenderer.toString());
    }

    @Test
    public void testAlternateText() throws Exception {
        Assert.assertEquals((Object)"x [a picture] y", (Object)this.render("x <img src\"picture.png\" alt=\"a picture\" /> y"));
        Assert.assertEquals((Object)"x[a picture]y", (Object)this.render("x<img src\"picture.png\" alt=\"a picture\" />y"));
        Assert.assertEquals((Object)"x[ a  picture\n]y", (Object)this.render("x<img src\"picture.png\" alt=\" a  picture\n\" />y"));
        Assert.assertEquals((Object)"x\n[a picture]\ny", (Object)this.render("<div>x</div><img src\"picture.png\" alt=\"a picture\" /><div>y</div>"));
        Assert.assertEquals((Object)"An example of a line where the alternate text wraps: [this is alternate \ntext that wraps]", (Object)this.render("An example of a line where the alternate text wraps: <img src\"picture.png\" alt=\"this is alternate text that wraps\" />"));
        Assert.assertEquals((Object)"x y", (Object)this.renderer("x <img src\"picture.png\" alt=\"a picture\" /> y").setIncludeAlternateText(false).toString());
        Renderer customRenderer = new Renderer(new Source("x <img src\"picture.png\" alt=\"a picture\" /> y")){

            @Override
            public String renderAlternateText(StartTag startTag) {
                if (startTag.getName() == "area") {
                    return null;
                }
                String alt = startTag.getAttributeValue("alt");
                if (alt == null || alt.length() == 0) {
                    return null;
                }
                return String.valueOf('\u00ab') + alt + '\u00bb';
            }
        };
        Assert.assertEquals((Object)"x \u00aba picture\u00bb y", (Object)customRenderer.toString());
    }

    @Test
    public void testHR() throws Exception {
        Assert.assertEquals((Object)"x\n------------------------------------------------------------------------\ny", (Object)this.render("x<hr>y"));
        Assert.assertEquals((Object)"x\n    * ------------------------------------------------------------------\n\n          --------------------------------------------------------------\n\ny", (Object)this.render("x<ul><li><hr><blockquote><hr></blockquote></ul>y"));
    }

    @Test
    public void testFontStyles() throws Exception {
        Assert.assertEquals((Object)"a bold word", (Object)this.render("a <b>bold</b> word"));
        Assert.assertEquals((Object)"a *bold* and *strong* word", (Object)this.renderer("a <b>bold</b> and <strong>strong</strong> word").setDecorateFontStyles(true).toString());
        Assert.assertEquals((Object)"/italic/ and /emphasised/ text", (Object)this.renderer("<i>italic</i> and <em>emphasised</em> text").setDecorateFontStyles(true).toString());
        Assert.assertEquals((Object)"_underlined_ text", (Object)this.renderer("<u>underlined</u> text").setDecorateFontStyles(true).toString());
        Assert.assertEquals((Object)"|code| text", (Object)this.renderer("<code>code</code> text").setDecorateFontStyles(true).toString());
        Assert.assertEquals((Object)"*bold*\n\n*bold*", (Object)this.renderer("<p><strong>bold</strong></p><p><strong>bold</strong></p>").setDecorateFontStyles(true).toString());
    }

    private String render(String sourceText) {
        return this.renderer(sourceText).toString();
    }

    private Renderer renderer(String sourceText) {
        return new Renderer(new Source(sourceText)).setNewLine("\n");
    }
}

