/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.net.URL;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import org.junit.Assert;
import org.junit.Test;

public class SegmentGetStyleURISegmentsTest {
    private static final String sourceUrlString = "file:test/data/SegmentTest.html";

    @Test
    public void test() throws Exception {
        Source source = new Source(new URL(sourceUrlString));
        List<Segment> styleURISegments = source.getStyleURISegments();
        Assert.assertEquals((long)3L, (long)styleURISegments.size());
        Assert.assertEquals((Object)"images/background.png", (Object)styleURISegments.get(0).toString());
        Assert.assertEquals((Object)"outerdiv.htc", (Object)styleURISegments.get(1).toString());
        Assert.assertEquals((Object)"images/background-image.png", (Object)styleURISegments.get(2).toString());
        Element outerDivElement = source.getElementById("OuterDiv");
        Segment styleAttributeValueSegment = outerDivElement.getAttributes().get("style").getValueSegment();
        styleURISegments = styleAttributeValueSegment.getStyleURISegments();
        Assert.assertEquals((long)2L, (long)styleURISegments.size());
        Assert.assertEquals((Object)"images/background.png", (Object)styleURISegments.get(0).toString());
        Assert.assertEquals((Object)"outerdiv.htc", (Object)styleURISegments.get(1).toString());
    }
}

