/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.StringReader;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;
import net.htmlparser.jericho.StreamedParseText;
import net.htmlparser.jericho.StreamedText;
import org.junit.Assert;
import org.junit.Test;

public class StreamedParseTextTest {
    private static final String text = "ABCDEFGHIJKLMNOPQRSTUVWXYZ<0123456789A";

    @Test
    public void testExpandableBuffer() {
        StringReader reader = new StringReader(text);
        int originalInitialExpandableBufferSize = StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE;
        StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE = 2;
        StreamedText streamedText = new StreamedText(reader);
        StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE = originalInitialExpandableBufferSize;
        StreamedParseText streamedParseText = new StreamedParseText(streamedText);
        Assert.assertEquals((long)97L, (long)streamedParseText.charAt(0));
        Assert.assertEquals((long)2L, (long)streamedText.getBuffer().length);
        Assert.assertEquals((Object)"ab", (Object)streamedParseText.substring(0, 2));
        Assert.assertEquals((long)99L, (long)streamedParseText.charAt(2));
        Assert.assertEquals((long)4L, (long)streamedText.getBuffer().length);
        int tagStartPos = streamedParseText.indexOf('<', 0);
        streamedText.setMinRequiredBufferBegin(tagStartPos);
        Assert.assertEquals((long)26L, (long)tagStartPos);
        Assert.assertEquals((long)32L, (long)streamedText.getBuffer().length);
        Assert.assertEquals((long)7L, (long)streamedParseText.indexOf('h', 5));
        Assert.assertEquals((long)122L, (long)streamedParseText.charAt(25));
        Assert.assertEquals((long)36L, (long)streamedParseText.indexOf('9', 0));
        Assert.assertEquals((long)32L, (long)streamedText.getBuffer().length);
        Assert.assertEquals((Object)"<0123456789A", (Object)streamedText.getCurrentBufferContent());
        try {
            streamedParseText.charAt(0);
            Assert.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException ex) {
            Assert.assertEquals((Object)"StreamedText position 0 has been discarded", (Object)ex.getMessage());
        }
        Assert.assertEquals((long)-1L, (long)streamedParseText.indexOf('A', 30));
    }

    @Test
    public void testFixedBuffer() {
        StringReader reader = new StringReader(text);
        char[] buffer = new char[10];
        StreamedText streamedText = new StreamedText(reader, buffer);
        StreamedParseText streamedParseText = new StreamedParseText(streamedText);
        Assert.assertEquals((long)97L, (long)streamedParseText.charAt(0));
        Assert.assertEquals((Object)"abc", (Object)streamedParseText.substring(0, 3));
        Assert.assertEquals((long)7L, (long)streamedParseText.indexOf('h', 5));
        Assert.assertEquals((long)10L, (long)streamedText.getBuffer().length);
        try {
            streamedParseText.indexOf('<', 0);
            Assert.fail((String)"Should throw BufferOverflowException");
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)streamedText.getBuffer().length);
        try {
            streamedParseText.indexOf('z', 5);
            Assert.fail((String)"Should throw BufferOverflowException");
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        try {
            streamedParseText.indexOf('H', 5);
            Assert.fail((String)"Should throw BufferOverflowException");
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        streamedText.setMinRequiredBufferBegin(20);
        Assert.assertEquals((long)122L, (long)streamedParseText.charAt(25));
        Assert.assertEquals((long)60L, (long)streamedParseText.charAt(26));
        Assert.assertEquals((Object)"xyz<01", (Object)streamedParseText.substring(23, 29));
        streamedText.setMinRequiredBufferBegin(30);
        Assert.assertEquals((long)35L, (long)streamedParseText.indexOf('8', 28));
        Assert.assertEquals((long)36L, (long)streamedParseText.indexOf('9', 30));
        Assert.assertEquals((long)-1L, (long)streamedParseText.indexOf('A', 30));
        Assert.assertEquals((long)37L, (long)streamedParseText.indexOf('a', 30));
    }

    @Test
    public void testCharBuffer() {
        char[] charArray = text.toCharArray();
        CharBuffer charBuffer = CharBuffer.wrap(charArray, 0, 20);
        StreamedText streamedText = new StreamedText(charBuffer);
        StreamedParseText streamedParseText = new StreamedParseText(streamedText);
        int tagStartPos = streamedParseText.indexOf('<', 15);
        Assert.assertEquals((long)-1L, (long)tagStartPos);
        Assert.assertEquals((long)97L, (long)streamedParseText.charAt(0));
        Assert.assertEquals((long)-1L, (long)streamedParseText.indexOf('a', 18));
        streamedText.setMinRequiredBufferBegin(20);
        try {
            streamedParseText.charAt(25);
            Assert.fail((String)"Should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        streamedText.setMinRequiredBufferBegin(30);
        Assert.assertEquals((long)1L, (long)streamedParseText.indexOf('b', 0));
        charBuffer = CharBuffer.wrap(charArray, 0, 30);
        streamedText = new StreamedText(charBuffer);
        streamedParseText = new StreamedParseText(streamedText);
        tagStartPos = streamedParseText.indexOf('<', 15);
        Assert.assertEquals((long)26L, (long)tagStartPos);
        streamedText.setMinRequiredBufferBegin(tagStartPos);
        Assert.assertEquals((long)97L, (long)streamedParseText.charAt(0));
    }
}

