/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.StringWriter;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.htmlparser.jericho.CharacterEntityReference;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.NumericCharacterReference;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.StreamedSource;
import net.htmlparser.jericho.StreamedText;
import net.htmlparser.jericho.Tag;
import org.junit.Assert;
import org.junit.Test;

public class StreamedSourceTest {
    private static final String sourceUrlString = "file:test/data/StreamedSourceTest.html";

    @Test
    public void testDefault() throws Exception {
        StreamedSource streamedSource = null;
        try {
            int originalInitialExpandableBufferSize = StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE;
            StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE = 120;
            streamedSource = new StreamedSource(new URL(sourceUrlString));
            StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE = originalInitialExpandableBufferSize;
            Assert.assertNull((Object)streamedSource.getCurrentSegment());
            Assert.assertEquals((Object)"UTF-8", (Object)streamedSource.getEncoding());
            try {
                streamedSource.isXML();
                Assert.fail((String)"Should throw IllegalStateException");
            }
            catch (IllegalStateException ex) {
                Assert.assertEquals((Object)"isXML() method only available after iterator() has been called", (Object)ex.getMessage());
            }
            Iterator<Segment> i = streamedSource.iterator();
            Assert.assertTrue((boolean)streamedSource.isXML());
            Assert.assertTrue((boolean)i.hasNext());
            Assert.assertNull((Object)streamedSource.getCurrentSegment());
            Segment segment = i.next();
            Assert.assertSame((Object)segment, (Object)streamedSource.getCurrentSegment());
            Assert.assertEquals((Object)StartTagType.XML_DECLARATION, (Object)((Tag)segment).getTagType());
            Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", (Object)segment.toString());
            Assert.assertEquals((Object)"<?xml ?> (XML declaration) ((p0)-(p39))", (Object)segment.getDebugInfo());
            try {
                segment.getSource();
                Assert.fail((String)"Should throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException ex) {
                Assert.assertEquals((Object)"Source object is not available when using StreamedSource", (Object)ex.getMessage());
            }
            Assert.assertTrue((boolean)i.hasNext());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            Assert.assertTrue((boolean)i.hasNext());
            segment = i.next();
            Assert.assertEquals((Object)StartTagType.SERVER_COMMON, (Object)((Tag)segment).getTagType());
            Assert.assertEquals((Object)"<%@ page language=\"java\" %>", (Object)segment.toString());
            Assert.assertEquals((long)120L, (long)streamedSource.getBufferSize());
            CharBuffer charBuffer = streamedSource.getCurrentSegmentCharBuffer();
            char[] charBufferArray = charBuffer.array();
            Assert.assertEquals((long)120L, (long)charBufferArray.length);
            Assert.assertEquals((Object)segment.toString(), (Object)new String(charBufferArray, charBuffer.position(), charBuffer.length()));
            segment = i.next();
            Assert.assertEquals((Object)StartTagType.SERVER_COMMON, (Object)((Tag)segment).getTagType());
            Assert.assertEquals((Object)"<%@ taglib uri=\"/WEB-INF/struts-i18n.tld\" prefix=\"i18n\" %>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)StartTagType.XML_PROCESSING_INSTRUCTION, (Object)((Tag)segment).getTagType());
            Assert.assertEquals((Object)"<?xml-stylesheet href=\"standardstyle.css\" title=\"Standard Stylesheet\" type=\"text/css\"?>", (Object)segment.toString());
            Assert.assertEquals((long)120L, (long)streamedSource.getBufferSize());
            segment = i.next();
            Assert.assertEquals((long)240L, (long)streamedSource.getBufferSize());
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)StartTagType.DOCTYPE_DECLARATION, (Object)((Tag)segment).getTagType());
            Assert.assertEquals((Object)"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" [\r\n <!ELEMENT greeting (#PCDATA)>\r\n <!ENTITY p CDATA \"<p>\">\r\n]>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)StartTagType.MARKUP_DECLARATION, (Object)((Tag)segment).getTagType());
            Assert.assertEquals((Object)"<!ELEMENT greeting (#PCDATA)>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)StartTagType.MARKUP_DECLARATION, (Object)((Tag)segment).getTagType());
            Assert.assertEquals((Object)"<!ENTITY p CDATA \"<p>\">", (Object)segment.toString());
            int x = 0;
            while (x < 7) {
                segment = i.next();
                ++x;
            }
            Assert.assertEquals((Object)"Jericho HTML Parser Test Document", (Object)segment.toString());
            x = 0;
            while (x < 5) {
                segment = i.next();
                ++x;
            }
            StartTag startTag = (StartTag)segment;
            Assert.assertEquals((Object)StartTagType.NORMAL, (Object)startTag.getTagType());
            Assert.assertEquals((Object)"<meta name=\"keywords\" content=\"HTML parser,test document,R&amp;D\" />", (Object)segment.toString());
            Assert.assertEquals((Object)"HTML parser,test document,R&D", (Object)startTag.getAttributeValue("content"));
            try {
                startTag.getElement();
                Assert.fail((String)"Should throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException ex) {
                Assert.assertEquals((Object)"Elements are not supported when using StreamedSource", (Object)ex.getMessage());
            }
            x = 0;
            while (x < 8) {
                segment = i.next();
                ++x;
            }
            StringWriter plainTextWriter = new StringWriter();
            segment = i.next();
            Assert.assertEquals((Object)"This paragraph contains character references: ", (Object)segment.toString());
            plainTextWriter.append(segment);
            segment = i.next();
            Assert.assertEquals((Object)"&euro;", (Object)segment.toString());
            CharacterEntityReference characterEntityReference = (CharacterEntityReference)segment;
            characterEntityReference.appendCharTo(plainTextWriter);
            segment = i.next();
            Assert.assertEquals((Object)" and ", (Object)segment.toString());
            plainTextWriter.append(segment);
            segment = i.next();
            Assert.assertEquals((Object)"&#169;", (Object)segment.toString());
            NumericCharacterReference numericCharacterReference = (NumericCharacterReference)segment;
            numericCharacterReference.appendCharTo(plainTextWriter);
            segment = i.next();
            Assert.assertEquals((Object)".", (Object)segment.toString());
            plainTextWriter.append(segment);
            Assert.assertEquals((Object)"This paragraph contains character references: \u20ac and \u00a9.", (Object)plainTextWriter.toString());
            int x2 = 0;
            while (x2 < 3) {
                segment = i.next();
                ++x2;
            }
            startTag = (StartTag)segment;
            Assert.assertEquals((Object)StartTagType.COMMENT, (Object)startTag.getTagType());
            Assert.assertEquals((Object)"<!-- <p>This paragraph is commented out</p> -->", (Object)segment.toString());
            Assert.assertEquals((Object)" <p>This paragraph is commented out</p> ", (Object)startTag.getTagContent().toString());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"<input type=\"button\" value=\"Click here to execute script\" title=\"simply writes some text using document.write\"\r\n  onclick=\"document.write('<h2>This element is defined inside an onclick attribute</h2>')\"/>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            x2 = 0;
            while (x2 < 5) {
                segment = i.next();
                ++x2;
            }
            startTag = (StartTag)segment;
            Assert.assertEquals((Object)StartTagType.CDATA_SECTION, (Object)startTag.getTagType());
            Assert.assertEquals((Object)"<![CDATA[\r\n <an> example of <sgml> markup that is not <painful> to write with < and such.\r\n]]>", (Object)segment.toString());
            Assert.assertEquals((Object)"\r\n <an> example of <sgml> markup that is not <painful> to write with < and such.\r\n", (Object)startTag.getTagContent().toString());
            segment = i.next();
            segment = i.next();
            Assert.assertEquals((Object)"<script language=\"javascript\" type=\"text/javascript\">", (Object)segment.toString());
            segment = i.next();
            segment = i.next();
            Assert.assertEquals((Object)"</script>", (Object)segment.toString());
            segment = i.next();
            segment = i.next();
            Assert.assertEquals((Object)"<script language=\"javascript\" type=\"text/javascript\">", (Object)segment.toString());
            segment = i.next();
            segment = i.next();
            Assert.assertEquals((Object)"</script>", (Object)segment.toString());
            segment = i.next();
            segment = i.next();
            Assert.assertEquals((Object)"<script language=\"javascript\" type=\"text/javascript\">", (Object)segment.toString());
            segment = i.next();
            segment = i.next();
            Assert.assertEquals((Object)"</script>", (Object)segment.toString());
            Assert.assertEquals((long)240L, (long)streamedSource.getBufferSize());
            segment = i.next();
            Assert.assertEquals((long)480L, (long)streamedSource.getBufferSize());
            segment = i.next();
            startTag = (StartTag)segment;
            Assert.assertEquals((Object)StartTagType.COMMENT, (Object)startTag.getTagType());
            segment = i.next();
            Assert.assertEquals((Object)"<% server tag %>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"<hr>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            segment = i.next();
            startTag = (StartTag)segment;
            Assert.assertEquals((Object)StartTagType.SERVER_COMMON_COMMENT, (Object)startTag.getTagType());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"<hr>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n<*abc def=\"ghi\">\r\n This is an example of an element from a hypothetical server language \r\n whose tag formats have not been registered with the TagTypeRegister class \r\n</*abc>\r\n", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"<p>", (Object)segment.toString());
            Assert.assertEquals((long)480L, (long)streamedSource.getBufferSize());
            x2 = 0;
            while (x2 < 41) {
                segment = i.next();
                Assert.assertEquals((long)480L, (long)segment.length());
                ++x2;
            }
            segment = i.next();
            Assert.assertEquals((long)391L, (long)segment.length());
            Assert.assertEquals((long)480L, (long)streamedSource.getBufferSize());
            segment = i.next();
            Assert.assertEquals((Object)"</p>", (Object)segment.toString());
            Assert.assertEquals((long)480L, (long)streamedSource.getBufferSize());
            segment = i.next();
            Assert.assertEquals((long)30720L, (long)streamedSource.getBufferSize());
            segment = i.next();
            startTag = (StartTag)segment;
            Assert.assertEquals((Object)StartTagType.COMMENT, (Object)startTag.getTagType());
            Assert.assertEquals((long)20077L, (long)segment.length());
            segment = i.next();
            Assert.assertTrue((boolean)i.hasNext());
            segment = i.next();
            Assert.assertEquals((Object)"</html>", (Object)segment.toString());
            Assert.assertTrue((boolean)i.hasNext());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            Assert.assertEquals((long)30720L, (long)streamedSource.getBufferSize());
            Assert.assertFalse((boolean)i.hasNext());
            try {
                segment = i.next();
                Assert.fail((String)"Should throw NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        finally {
            if (streamedSource != null) {
                streamedSource.close();
            }
        }
    }

    @Test
    public void testCoalescing() throws Exception {
        StreamedSource streamedSource = null;
        try {
            int originalInitialExpandableBufferSize = StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE;
            StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE = 120;
            streamedSource = new StreamedSource(new URL(sourceUrlString)).setCoalescing(true);
            StreamedText.INITIAL_EXPANDABLE_BUFFER_SIZE = originalInitialExpandableBufferSize;
            Iterator<Segment> i = streamedSource.iterator();
            Segment segment = i.next();
            int x = 0;
            while (x < 68) {
                segment = i.next();
                ++x;
            }
            Assert.assertEquals((Object)"<p>", (Object)segment.toString());
            Assert.assertEquals((long)480L, (long)streamedSource.getBufferSize());
            segment = i.next();
            Assert.assertEquals((long)20071L, (long)segment.length());
            Assert.assertEquals((long)30720L, (long)streamedSource.getBufferSize());
            Assert.assertEquals((long)20071L, (long)segment.toString().length());
            segment = i.next();
            Assert.assertEquals((Object)"</p>", (Object)segment.toString());
            segment = i.next();
            segment = i.next();
            StartTag startTag = (StartTag)segment;
            Assert.assertEquals((Object)StartTagType.COMMENT, (Object)startTag.getTagType());
            Assert.assertEquals((long)20077L, (long)segment.length());
            Assert.assertEquals((long)30720L, (long)streamedSource.getBufferSize());
            segment = i.next();
            segment = i.next();
            Assert.assertEquals((Object)"</html>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            Assert.assertEquals((long)30720L, (long)streamedSource.getBufferSize());
            Assert.assertFalse((boolean)i.hasNext());
        }
        finally {
            if (streamedSource != null) {
                streamedSource.close();
            }
        }
    }

    @Test
    public void testFixedBuffer() throws Exception {
        char[] buffer = new char[250];
        StreamedSource streamedSource = null;
        try {
            streamedSource = new StreamedSource(new URL(sourceUrlString)).setBuffer(buffer);
            Iterator<Segment> i = streamedSource.iterator();
            Assert.assertTrue((boolean)i.hasNext());
            Segment segment = i.next();
            Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            int x = 0;
            while (x < 14) {
                segment = i.next();
                ++x;
            }
            segment = i.next();
            Assert.assertEquals((Object)"Jericho HTML Parser Test Document", (Object)segment.toString());
            x = 0;
            while (x < 52) {
                segment = i.next();
                ++x;
            }
            Assert.assertEquals((Object)"<p>", (Object)segment.toString());
            x = 0;
            while (x < 80) {
                segment = i.next();
                Assert.assertEquals((long)250L, (long)segment.length());
                ++x;
            }
            segment = i.next();
            Assert.assertEquals((long)71L, (long)segment.length());
            segment = i.next();
            Assert.assertEquals((Object)"</p>", (Object)segment.toString());
            Assert.assertEquals((long)250L, (long)streamedSource.getBufferSize());
            try {
                i.hasNext();
                Assert.fail((String)"Should throw BufferOverflowException");
            }
            catch (BufferOverflowException bufferOverflowException) {}
        }
        finally {
            if (streamedSource != null) {
                streamedSource.close();
            }
        }
    }

    @Test
    public void testCharSequence() throws Exception {
        String sourceText = new Source(new URL(sourceUrlString)).toString();
        StreamedSource streamedSource = null;
        try {
            streamedSource = new StreamedSource(sourceText);
            Assert.assertEquals((long)42680L, (long)streamedSource.getBufferSize());
            Iterator<Segment> i = streamedSource.iterator();
            Segment segment = i.next();
            int x = 0;
            while (x < 11) {
                segment = i.next();
                ++x;
            }
            Assert.assertEquals((Object)"<HTML>", (Object)segment.toString());
            StartTag htmlStartTag = (StartTag)segment;
            int x2 = 0;
            while (x2 < 57) {
                segment = i.next();
                ++x2;
            }
            Assert.assertEquals((Object)"<p>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((long)20071L, (long)segment.toString().length());
            x2 = 0;
            while (x2 < 3) {
                segment = i.next();
                ++x2;
            }
            StartTag startTag = (StartTag)segment;
            Assert.assertEquals((Object)StartTagType.COMMENT, (Object)startTag.getTagType());
            Assert.assertEquals((long)20077L, (long)segment.toString().length());
            segment = i.next();
            segment = i.next();
            Assert.assertEquals((Object)"</html>", (Object)segment.toString());
            segment = i.next();
            Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
            Assert.assertFalse((boolean)i.hasNext());
            try {
                htmlStartTag.getElement();
                Assert.fail((String)"Should throw UnsupportedOperationException");
            }
            catch (UnsupportedOperationException ex) {
                Assert.assertEquals((Object)"Elements are not supported when using StreamedSource", (Object)ex.getMessage());
            }
        }
        finally {
            if (streamedSource != null) {
                streamedSource.close();
            }
        }
    }

    @Test
    public void exampleFetchElementContent() throws Exception {
        ArrayList<String> paragraphTextList = new ArrayList<String>();
        StreamedSource streamedSource = null;
        try {
            streamedSource = new StreamedSource(new URL(sourceUrlString));
            StringBuilder sb = new StringBuilder();
            boolean insideParagraphElement = false;
            for (Segment segment : streamedSource) {
                if (segment instanceof Tag) {
                    Tag tag = (Tag)segment;
                    if (!tag.getName().equals("p")) continue;
                    if (tag instanceof StartTag) {
                        insideParagraphElement = true;
                        sb.setLength(0);
                        continue;
                    }
                    insideParagraphElement = false;
                    paragraphTextList.add(sb.toString());
                    continue;
                }
                if (!insideParagraphElement) continue;
                if (segment instanceof CharacterReference) {
                    ((CharacterReference)segment).appendCharTo(sb);
                    continue;
                }
                sb.append(segment);
            }
        }
        finally {
            if (streamedSource != null) {
                streamedSource.close();
            }
        }
        Assert.assertEquals((long)3L, (long)paragraphTextList.size());
        Assert.assertEquals((Object)"This paragraph contains character references: \u20ac and \u00a9.", paragraphTextList.get(0));
        Assert.assertEquals((Object)"The following text demonstrates the use of a CDATA section which has limited browser compatability", paragraphTextList.get(1));
        Assert.assertEquals((long)20071L, (long)((String)paragraphTextList.get(2)).length());
    }
}

