/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.List;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.Logger;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagTypeRegister;

public abstract class TagType {
    private final String description;
    private final String startDelimiter;
    private final String closingDelimiter;
    private final boolean isServerTag;
    private final String namePrefix;
    final String startDelimiterPrefix;
    private static Logger logger = null;

    TagType(String description, String startDelimiter, String closingDelimiter, boolean isServerTag, String startDelimiterPrefix) {
        this.description = description;
        this.startDelimiter = startDelimiter;
        this.closingDelimiter = closingDelimiter;
        this.isServerTag = isServerTag;
        this.namePrefix = startDelimiter.substring(startDelimiterPrefix.length());
        this.startDelimiterPrefix = startDelimiterPrefix;
    }

    public final void register() {
        TagType.getLogger().debug("Register tag type: " + this);
        TagTypeRegister.add(this);
    }

    public final void deregister() {
        TagType.getLogger().debug("Deregister tag type " + this);
        TagTypeRegister.remove(this);
    }

    public static final List<TagType> getRegisteredTagTypes() {
        return TagTypeRegister.getList();
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getStartDelimiter() {
        return this.startDelimiter;
    }

    public final String getClosingDelimiter() {
        return this.closingDelimiter;
    }

    public final boolean isServerTag() {
        return this.isServerTag;
    }

    protected final String getNamePrefix() {
        return this.namePrefix;
    }

    protected boolean isValidPosition(Source source, int pos, int[] fullSequentialParseData) {
        if (this.isServerTag()) {
            if (fullSequentialParseData != null) {
                return true;
            }
            return !StartTagType.SERVER_COMMON_COMMENT.tagEncloses(source, pos);
        }
        if (fullSequentialParseData != null) {
            if (fullSequentialParseData[0] == Integer.MAX_VALUE) {
                if (this == EndTagType.NORMAL && source.getParseText().containsAt("</script", pos)) {
                    fullSequentialParseData[0] = pos;
                    return true;
                }
                return false;
            }
            return pos >= fullSequentialParseData[0];
        }
        TagType[] tagTypesIgnoringEnclosedMarkup = TagType.getTagTypesIgnoringEnclosedMarkup();
        int i = 0;
        while (i < tagTypesIgnoringEnclosedMarkup.length) {
            TagType tagTypeIgnoringEnclosedMarkup = tagTypesIgnoringEnclosedMarkup[i];
            if ((this != StartTagType.COMMENT || tagTypeIgnoringEnclosedMarkup != StartTagType.COMMENT) && tagTypeIgnoringEnclosedMarkup.tagEncloses(source, pos)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final TagType[] getTagTypesIgnoringEnclosedMarkup() {
        return TagTypesIgnoringEnclosedMarkup.array;
    }

    public static final void setTagTypesIgnoringEnclosedMarkup(TagType[] tagTypes) {
        if (tagTypes == null) {
            throw new IllegalArgumentException();
        }
        TagTypesIgnoringEnclosedMarkup.array = tagTypes;
    }

    protected abstract Tag constructTagAt(Source var1, int var2);

    protected final boolean tagEncloses(Source source, int pos) {
        if (pos == 0) {
            return false;
        }
        Tag enclosingTag = source.getEnclosingTag(pos - 1, this);
        return enclosingTag != null && pos != enclosingTag.getEnd();
    }

    public String toString() {
        return this.getDescription();
    }

    static final Tag getTagAt(Source source, int pos, boolean serverTagOnly, boolean assumeNoNestedTags) {
        TagTypeRegister.ProspectiveTagTypeIterator prospectiveTagTypeIterator = new TagTypeRegister.ProspectiveTagTypeIterator(source, pos);
        while (prospectiveTagTypeIterator.hasNext()) {
            TagType tagType = prospectiveTagTypeIterator.next();
            if (serverTagOnly && !tagType.isServerTag() || !assumeNoNestedTags && !tagType.isValidPosition(source, pos, source.fullSequentialParseData)) continue;
            try {
                Tag tag = tagType.constructTagAt(source, pos);
                if (tag == null) continue;
                return tag;
            }
            catch (IndexOutOfBoundsException ex) {
                if (!source.logger.isErrorEnabled()) continue;
                source.logger.error(source.getRowColumnVector(pos).appendTo(new StringBuilder(200).append("Tag at ")).append(" not recognised as type '").append(tagType.getDescription()).append("' because it has no end delimiter").toString());
            }
        }
        return null;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = Source.newLogger();
        }
        return logger;
    }

    private static final class TagTypesIgnoringEnclosedMarkup {
        public static TagType[] array = new TagType[]{StartTagType.COMMENT, StartTagType.CDATA_SECTION};

        private TagTypesIgnoringEnclosedMarkup() {
        }
    }
}

