/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.CharStreamSource;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.NodeIterator;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;

public class TextExtractor
implements CharStreamSource {
    private final Segment segment;
    private boolean convertNonBreakingSpaces = Config.ConvertNonBreakingSpaces;
    private boolean includeAttributes = false;
    private boolean excludeNonHTMLElements = false;
    private static final Map<String, AttributeIncludeChecker> map;
    private static AttributeIncludeChecker ALWAYS_INCLUDE;
    private static AttributeIncludeChecker INCLUDE_IF_NAME_ATTRIBUTE_PRESENT;

    static {
        ALWAYS_INCLUDE = new AttributeIncludeChecker(){

            @Override
            public boolean includeAttribute(StartTag startTag, Attribute attribute) {
                return true;
            }
        };
        INCLUDE_IF_NAME_ATTRIBUTE_PRESENT = new AttributeIncludeChecker(){

            @Override
            public boolean includeAttribute(StartTag startTag, Attribute attribute) {
                return startTag.getAttributes().get("name") != null;
            }
        };
        map = new HashMap<String, AttributeIncludeChecker>();
        map.put("title", ALWAYS_INCLUDE);
        map.put("alt", ALWAYS_INCLUDE);
        map.put("label", ALWAYS_INCLUDE);
        map.put("summary", ALWAYS_INCLUDE);
        map.put("content", INCLUDE_IF_NAME_ATTRIBUTE_PRESENT);
        map.put("href", ALWAYS_INCLUDE);
    }

    public TextExtractor(Segment segment) {
        this.segment = segment;
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
        writer.flush();
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        appendable.append(this.toString());
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        return this.segment.length();
    }

    @Override
    public String toString() {
        return new Processor(this.segment, this.getConvertNonBreakingSpaces(), this.getIncludeAttributes(), this.getExcludeNonHTMLElements()).toString();
    }

    public TextExtractor setConvertNonBreakingSpaces(boolean convertNonBreakingSpaces) {
        this.convertNonBreakingSpaces = convertNonBreakingSpaces;
        return this;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.convertNonBreakingSpaces;
    }

    public TextExtractor setIncludeAttributes(boolean includeAttributes) {
        this.includeAttributes = includeAttributes;
        return this;
    }

    public boolean getIncludeAttributes() {
        return this.includeAttributes;
    }

    public boolean includeAttribute(StartTag startTag, Attribute attribute) {
        AttributeIncludeChecker attributeIncludeChecker = map.get(attribute.getKey());
        if (attributeIncludeChecker == null) {
            return false;
        }
        return attributeIncludeChecker.includeAttribute(startTag, attribute);
    }

    public TextExtractor setExcludeNonHTMLElements(boolean excludeNonHTMLElements) {
        this.excludeNonHTMLElements = excludeNonHTMLElements;
        return this;
    }

    public boolean getExcludeNonHTMLElements() {
        return this.excludeNonHTMLElements;
    }

    public boolean excludeElement(StartTag startTag) {
        return false;
    }

    private static interface AttributeIncludeChecker {
        public boolean includeAttribute(StartTag var1, Attribute var2);
    }

    private final class Processor {
        private final Segment segment;
        private final Source source;
        private final boolean convertNonBreakingSpaces;
        private final boolean includeAttributes;
        private final boolean excludeNonHTMLElements;

        public Processor(Segment segment, boolean convertNonBreakingSpaces, boolean includeAttributes, boolean excludeNonHTMLElements) {
            this.segment = segment;
            this.source = segment.source;
            this.convertNonBreakingSpaces = convertNonBreakingSpaces;
            this.includeAttributes = includeAttributes;
            this.excludeNonHTMLElements = excludeNonHTMLElements;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.segment.length());
            NodeIterator nodeIterator = new NodeIterator(this.segment);
            while (nodeIterator.hasNext()) {
                Segment segment = nodeIterator.next();
                if (segment instanceof Tag) {
                    Tag tag = (Tag)segment;
                    if (tag.getTagType().isServerTag()) {
                        boolean elementContainsMarkup = false;
                        Element element = tag.getElement();
                        if (element == null || element.getEnd() <= tag.getEnd()) continue;
                        nodeIterator.skipToPos(element.getEnd());
                        continue;
                    }
                    if (tag.getTagType() == StartTagType.NORMAL) {
                        StartTag startTag = (StartTag)tag;
                        if (tag.name == "script" || tag.name == "style" || TextExtractor.this.excludeElement(startTag) || this.excludeNonHTMLElements && !HTMLElements.getElementNames().contains(tag.name)) {
                            nodeIterator.skipToPos(startTag.getElement().getEnd());
                            continue;
                        }
                        if (this.includeAttributes) {
                            for (Attribute attribute : startTag.getAttributes()) {
                                if (!TextExtractor.this.includeAttribute(startTag, attribute)) continue;
                                sb.append(' ').append(attribute.getValueSegment()).append(' ');
                            }
                        }
                    }
                    if (tag.getName() != "br" && HTMLElements.getInlineLevelElementNames().contains(tag.getName())) continue;
                    sb.append(' ');
                    continue;
                }
                sb.append(segment);
            }
            String decodedText = CharacterReference.decodeCollapseWhiteSpace(sb, this.convertNonBreakingSpaces);
            return decodedText;
        }
    }
}

