/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

final class URIAttributes {
    private static final String[] uriAttributeNames = new String[]{"action", "archive", "background", "cite", "href", "longdesc", "src", "usemap"};
    private static final String[] objectURIAttributeNames = new String[]{"classid", "codebase", "data"};

    URIAttributes() {
    }

    public static List<Attribute> getList(Segment segment) {
        Attribute attribute;
        if (segment == null || segment.getFirstStartTag() == null) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String[] stringArray = uriAttributeNames;
        int n = uriAttributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String uriAttributeName = stringArray[n2];
            for (StartTag startTag : segment.getAllStartTags(uriAttributeName, null)) {
                attribute = startTag.getAttributes().get(uriAttributeName);
                attribute.startTag = startTag;
                attributes.add(attribute);
            }
            ++n2;
        }
        for (StartTag startTag : segment.getAllStartTags("object")) {
            String[] stringArray2 = objectURIAttributeNames;
            int n3 = objectURIAttributeNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String uriAttributeName = stringArray2[n4];
                attribute = startTag.getAttributes().get(uriAttributeName);
                if (attribute != null) {
                    attribute.startTag = startTag;
                    attributes.add(attribute);
                }
                ++n4;
            }
        }
        Collections.sort(attributes);
        return attributes;
    }

    public static List<Segment> getStyleURISegments(Segment segment) {
        if (segment == null || segment.length() == 0) {
            return Collections.emptyList();
        }
        if (segment.getFirstStartTag() == null) {
            int urlDelimiterStartPos = segment.getSource().getParseText().indexOf("url(", segment.getBegin(), segment.getEnd());
            if (urlDelimiterStartPos == -1) {
                return Collections.emptyList();
            }
            return URIAttributes.addURLSegmentsFromCSS(new ArrayList<Segment>(), new Segment(segment.getSource(), urlDelimiterStartPos, segment.getEnd()));
        }
        ArrayList<Segment> uriSegments = new ArrayList<Segment>();
        for (StartTag startTag : segment.getAllStartTags("style", null)) {
            URIAttributes.addURLSegmentsFromCSS(uriSegments, startTag.getAttributes().get("style").getValueSegment());
        }
        for (Element element : segment.getAllElements("style")) {
            URIAttributes.addURLSegmentsFromCSS(uriSegments, element.getContent());
        }
        Collections.sort(uriSegments);
        return uriSegments;
    }

    private static List<Segment> addURLSegmentsFromCSS(List<Segment> uriSegments, Segment cssSegment) {
        Source source = cssSegment.getSource();
        ParseText parseText = source.getParseText();
        int breakAtIndex = cssSegment.getEnd();
        int pos = cssSegment.getBegin();
        while ((pos = parseText.indexOf("url(", pos, breakAtIndex)) != -1) {
            int uriEnd;
            int uriBegin;
            int closingBracketPos;
            pos += 4;
            while (pos < breakAtIndex && Segment.isWhiteSpace(parseText.charAt(pos))) {
                ++pos;
            }
            if (pos >= breakAtIndex || URIAttributes.isQuote(parseText.charAt(pos)) && ++pos >= breakAtIndex || (closingBracketPos = parseText.indexOf(')', uriBegin = pos, breakAtIndex)) == -1) break;
            pos = closingBracketPos;
            while (Segment.isWhiteSpace(parseText.charAt(pos - 1))) {
                --pos;
            }
            if (URIAttributes.isQuote(parseText.charAt(pos - 1))) {
                // empty if block
            }
            if ((uriEnd = --pos) <= uriBegin) break;
            uriSegments.add(new Segment(source, uriBegin, uriEnd));
            pos = closingBracketPos;
        }
        return uriSegments;
    }

    private static boolean isQuote(char ch) {
        return ch == '\"' || ch == '\'';
    }
}

