/*
 * Decompiled with CFR 0.152.
 */
package ignore;

import japa.parser.JavaParser;
import japa.parser.ParseException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;

public class TestRunner {
    private static final File ROOT = new File("D:/Downloads/openjdk-7-ea-src-b27-22_may_2008/openjdk/langtools/test/tools/javac");
    int runCount = 0;
    long runTime = 0L;

    public static void main(String[] args) {
        new TestRunner().run();
    }

    private void visitAllJavaFiles(FileFilter callback, File dir) {
        File[] listFiles = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".java");
            }
        });
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                if (element.isDirectory()) {
                    this.visitAllJavaFiles(callback, element);
                } else {
                    callback.accept(element);
                }
                ++n2;
            }
        }
    }

    public void run() {
        this.visitAllJavaFiles(new FileFilter(){

            public boolean accept(File javaFile) {
                try {
                    TestRunner.this.runTest(javaFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return false;
            }
        }, ROOT);
        System.out.println("Compiled " + this.runCount + " in " + this.runTime + " ms, avarage of " + (double)this.runTime / (double)this.runCount);
    }

    private void runTest(File javaFile) throws IOException {
        StringBuilder buf = new StringBuilder();
        try {
            FileInputStream in = new FileInputStream(javaFile);
            try {
                int i;
                while ((i = in.read()) >= 0) {
                    buf.append((char)i);
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (buf.indexOf("@test") < 0) {
            return;
        }
        boolean fail = false;
        if (buf.indexOf("@compile ") < 0 || buf.indexOf("compile/fail") >= 0) {
            return;
        }
        try {
            ++this.runCount;
            long time = System.currentTimeMillis();
            JavaParser.parse(javaFile);
            this.runTime += System.currentTimeMillis() - time;
            if (fail) {
                System.out.println("Testing file: " + javaFile.getPath());
                System.out.println("  >>Parser error expected but not ocurred");
            }
        }
        catch (ParseException e) {
            if (!fail) {
                System.out.println("Testing file: " + javaFile.getPath());
                System.out.println("  >>Parser error not expected: " + e.getMessage());
            }
        }
        catch (Error e) {
            System.out.println("Testing file: " + javaFile.getPath());
            System.out.println("  >>Unknow error: " + e.getMessage());
        }
    }
}

