/*
 * Decompiled with CFR 0.152.
 */
package japa.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import japa.parser.JavaParser;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.expr.DmlExpression;
import japa.parser.ast.expr.QueryLiteralExpr;
import japa.parser.ast.stmt.DmlStmt;
import japa.parser.ast.stmt.ForStmt;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.io.FileInputStream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ApexPrinter {
    static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    static JSONObject returnObject = new JSONObject();
    static JSONArray methodList = new JSONArray();
    static JSONArray forLoopList = new JSONArray();
    static JSONArray queryList = new JSONArray();
    static JSONArray dmlList = new JSONArray();
    static JSONArray classList = new JSONArray();

    public static void main(String[] args) throws Exception {
        String filePath = null;
        if (args.length <= 0) {
            System.err.println("Please provide a file location or pipe body to STDIN.");
            return;
        }
        filePath = new String(args[0]);
        FileInputStream in = new FileInputStream(filePath);
        CompilationUnit cu = null;
        try {
            cu = JavaParser.parse(in);
        }
        finally {
            in.close();
        }
        new ClassVisitor().visit(cu, null);
        new MethodVisitor().visit(cu, null);
        new ForLoopVisitor().visit(cu, null);
        new QueryVisitor().visit(cu, null);
        new DmlVisitor().visit(cu, null);
        new DmlExpressionVisitor().visit(cu, null);
        returnObject.put((Object)"classes", (Object)classList);
        returnObject.put((Object)"methods", (Object)methodList);
        returnObject.put((Object)"forLoops", (Object)forLoopList);
        returnObject.put((Object)"queries", (Object)queryList);
        returnObject.put((Object)"dmlStatements", (Object)dmlList);
        String jsonText = JSONValue.toJSONString((Object)returnObject);
        String json = gson.toJson((Object)returnObject);
        System.out.print(json);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassVisitor
    extends VoidVisitorAdapter<Object> {
        private ClassVisitor() {
        }

        @Override
        public void visit(ClassOrInterfaceDeclaration n, Object arg) {
            JSONObject cls = new JSONObject();
            cls.put((Object)"name", (Object)n.getName());
            cls.put((Object)"annotations", n.getAnnotations());
            cls.put((Object)"lineNumber", (Object)n.getBeginLine());
            classList.add((Object)cls);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DmlExpressionVisitor
    extends VoidVisitorAdapter<Object> {
        private DmlExpressionVisitor() {
        }

        @Override
        public void visit(DmlExpression n, Object arg) {
            JSONObject dmlStatement = new JSONObject();
            dmlStatement.put((Object)"statement", (Object)n);
            dmlList.add((Object)dmlStatement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DmlVisitor
    extends VoidVisitorAdapter<Object> {
        private DmlVisitor() {
        }

        @Override
        public void visit(DmlStmt n, Object arg) {
            JSONObject dmlStatement = new JSONObject();
            dmlStatement.put((Object)"statement", (Object)n.getBody());
            dmlList.add((Object)dmlStatement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForLoopVisitor
    extends VoidVisitorAdapter<Object> {
        private ForLoopVisitor() {
        }

        @Override
        public void visit(ForStmt n, Object arg) {
            JSONArray forLoop = new JSONArray();
            forLoop.add((Object)n.getBeginLine());
            forLoop.add((Object)n.getEndLine());
            forLoopList.add((Object)forLoop);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodVisitor
    extends VoidVisitorAdapter<Object> {
        private MethodVisitor() {
        }

        @Override
        public void visit(MethodDeclaration n, Object arg) {
            JSONObject method = new JSONObject();
            method.put((Object)"name", (Object)n.getName());
            method.put((Object)"annotations", n.getAnnotations());
            method.put((Object)"lineNumber", (Object)n.getBeginLine());
            methodList.add((Object)method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryVisitor
    extends VoidVisitorAdapter<Object> {
        private QueryVisitor() {
        }

        @Override
        public void visit(QueryLiteralExpr n, Object arg) {
            JSONObject query = new JSONObject();
            query.put((Object)"statement", (Object)n.getValue());
            query.put((Object)"lineNumber", (Object)n.getBeginLine());
            queryList.add((Object)query);
        }
    }
}

