/*
 * Decompiled with CFR 0.152.
 */
package japa.parser;

import japa.parser.ASTParser;
import japa.parser.ParseException;
import japa.parser.Token;
import japa.parser.ast.CompilationUnit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class JavaParser {
    private static ASTParser parser;
    private static boolean cacheParser;
    public List<ParseException> syntaxErrors = new ArrayList<ParseException>();

    static {
        cacheParser = true;
    }

    private JavaParser() {
    }

    public static void setCacheParser(boolean value) {
        cacheParser = value;
        if (!value) {
            parser = null;
        }
    }

    public static CompilationUnit parse(InputStream in, String encoding) throws ParseException {
        if (cacheParser) {
            if (parser == null) {
                parser = new ASTParser(in, encoding);
            } else {
                parser.reset(in, encoding);
            }
            return parser.CompilationUnit();
        }
        return new ASTParser(in, encoding).CompilationUnit();
    }

    public static CompilationUnit parse(InputStream in) throws ParseException {
        return JavaParser.parse(in, null);
    }

    public static CompilationUnit parse(File file, String encoding) throws ParseException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            CompilationUnit compilationUnit = JavaParser.parse(in, encoding);
            return compilationUnit;
        }
        finally {
            in.close();
        }
    }

    public static CompilationUnit parse(File file) throws ParseException, IOException {
        return JavaParser.parse(file, null);
    }

    void recover(ParseException ex, int recoveryPoint) {
        Token t;
        this.syntaxErrors.add(ex);
        do {
            t = ex.currentToken.next;
        } while (t.kind != 0 && t.kind != recoveryPoint);
    }
}

