/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.test;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.test.Helper;
import org.junit.Assert;
import org.junit.Test;

public class TestDumper {
    @Test
    public void testDumpVisitor() throws Exception {
        String source = Helper.readClass("DumperTestClass");
        CompilationUnit cu = Helper.parserString(source);
        Assert.assertEquals((Object)source, (Object)cu.toString());
    }

    @Test
    public void testJavadoc() throws Exception {
        String source = Helper.readClass("JavadocTestClass");
        CompilationUnit cu = Helper.parserString(source);
        Assert.assertEquals((Object)source, (Object)cu.toString());
        Assert.assertEquals((long)19L, (long)cu.getComments().size());
    }

    @Test
    public void testComments() throws Exception {
        String source_with_comment = "package japa.parser.javacc;\npublic class Teste {\n//line comment\nint a = 0;//line comment\r\nint b = 0;//line comment\rint c = 0;/* multi-line\n comment\n*/int d = 0;/** multi-line\r\n javadoc\n*/int e = 0;}\n//final comment";
        String source_without_comment = "package japa.parser.javacc;\n\npublic class Teste {\n\n    int a = 0;\n\n    int b = 0;\n\n    int c = 0;\n\n    int d = 0;\n\n    /** multi-line\r\n javadoc\n*/\n    int e = 0;\n}\n";
        CompilationUnit cu = Helper.parserString("package japa.parser.javacc;\npublic class Teste {\n//line comment\nint a = 0;//line comment\r\nint b = 0;//line comment\rint c = 0;/* multi-line\n comment\n*/int d = 0;/** multi-line\r\n javadoc\n*/int e = 0;}\n//final comment");
        Assert.assertEquals((Object)"package japa.parser.javacc;\n\npublic class Teste {\n\n    int a = 0;\n\n    int b = 0;\n\n    int c = 0;\n\n    int d = 0;\n\n    /** multi-line\r\n javadoc\n*/\n    int e = 0;\n}\n", (Object)cu.toString());
        Assert.assertEquals((long)6L, (long)cu.getComments().size());
    }
}

