/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.test;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.test.Helper;
import org.junit.Assert;
import org.junit.Test;

public class TestHashCodeEquals {
    private final String source_with_comment = "package japa.parser.javacc;\npublic class Teste {\n//line comment\nint a = 0;//line comment\r\nint b = 0;//line comment\rint c = 0;/* multi-line\n comment\n*/int d = 0;/** multi-line\r\n javadoc\n*/int e = 0;}\n//final comment";
    private final String source_without_comment = "package japa.parser.javacc;\n\npublic class Teste {\n\n    int a = 0;\n\n    int b = 0;\n\n    int c = 0;\n\n    int d = 0;\n\n    /** multi-line\r\n javadoc\n*/\n    int e = 0;\n}\n";

    private void assertEqualsAndHashCode(Object o1, Object o2) {
        Assert.assertEquals((Object)o1, (Object)o2);
        Assert.assertEquals((long)o1.hashCode(), (long)o2.hashCode());
    }

    private void assertNotEqualsAndHashCode(Object o1, Object o2) {
        Assert.assertFalse((String)"Not different equals", (boolean)o1.equals(o2));
        Assert.assertFalse((String)"Not different hashCode", (o1.hashCode() == o2.hashCode() ? 1 : 0) != 0);
    }

    private void assertNotEquals(Object o1, Object o2) {
        Assert.assertFalse((String)"Not different equals", (boolean)o1.equals(o2));
    }

    @Test
    public void tesCompilationUnitEqual() throws Exception {
        String source = Helper.readClass("DumperTestClass");
        CompilationUnit cu1 = Helper.parserString(source);
        CompilationUnit cu2 = Helper.parserString(source);
        this.assertEqualsAndHashCode(cu1, cu2);
    }

    @Test
    public void tesCompilationUnitNotEqual() throws Exception {
        String source = Helper.readClass("DumperTestClass");
        CompilationUnit cu1 = Helper.parserString(source);
        CompilationUnit cu2 = Helper.parserString(source);
        cu2.setPackage(new PackageDeclaration(new NameExpr("diff_package")));
        this.assertNotEqualsAndHashCode(cu1, cu2);
    }

    @Test
    public void testDiffClasses() throws Exception {
        String source_with_comment = "package japa.parser.javacc; public class Teste {}";
        String source_without_comment = "package japa.parser.javacc; public enum Teste {}";
        CompilationUnit cu1 = Helper.parserString("package japa.parser.javacc; public class Teste {}");
        CompilationUnit cu2 = Helper.parserString("package japa.parser.javacc; public enum Teste {}");
        this.assertNotEqualsAndHashCode(cu1, cu2);
    }

    @Test
    public void testJavadoc() throws Exception {
        String source = Helper.readClass("JavadocTestClass");
        CompilationUnit cu1 = Helper.parserString(source);
        CompilationUnit cu2 = Helper.parserString(source);
        this.assertEqualsAndHashCode(cu1, cu2);
    }

    @Test
    public void testCommentsDiff() throws Exception {
        CompilationUnit cu1 = Helper.parserString("package japa.parser.javacc;\npublic class Teste {\n//line comment\nint a = 0;//line comment\r\nint b = 0;//line comment\rint c = 0;/* multi-line\n comment\n*/int d = 0;/** multi-line\r\n javadoc\n*/int e = 0;}\n//final comment");
        CompilationUnit cu2 = Helper.parserString("package japa.parser.javacc;\n\npublic class Teste {\n\n    int a = 0;\n\n    int b = 0;\n\n    int c = 0;\n\n    int d = 0;\n\n    /** multi-line\r\n javadoc\n*/\n    int e = 0;\n}\n");
        this.assertNotEquals(cu1, cu2);
    }

    @Test
    public void testCommentsEquals() throws Exception {
        CompilationUnit cu1 = Helper.parserString("package japa.parser.javacc;\npublic class Teste {\n//line comment\nint a = 0;//line comment\r\nint b = 0;//line comment\rint c = 0;/* multi-line\n comment\n*/int d = 0;/** multi-line\r\n javadoc\n*/int e = 0;}\n//final comment");
        CompilationUnit cu2 = Helper.parserString("package japa.parser.javacc;\npublic class Teste {\n//line comment\nint a = 0;//line comment\r\nint b = 0;//line comment\rint c = 0;/* multi-line\n comment\n*/int d = 0;/** multi-line\r\n javadoc\n*/int e = 0;}\n//final comment");
        this.assertEqualsAndHashCode(cu1, cu2);
    }
}

