/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.MasonTagTypes;
import net.htmlparser.jericho.MicrosoftConditionalCommentTagTypes;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class FindSpecificTags {
    static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    static JSONObject returnObject = new JSONObject();
    static JSONArray actionPollerList = new JSONArray();
    static JSONArray outputLinkList = new JSONArray();

    public static void main(String[] args) throws Exception {
        String filePath = "";
        if (args.length <= 0) {
            System.err.println("Please provide a file location or pipe body to STDIN.");
            return;
        }
        filePath = new String(args[0]);
        FileInputStream in = new FileInputStream(filePath);
        MicrosoftConditionalCommentTagTypes.register();
        MasonTagTypes.register();
        Source source = new Source(in);
        HashSet<String> tagsWeCareAbout = new HashSet<String>(Arrays.asList("actionpoller", "outputlink"));
        HashSet<String> attributesWeCareAbout = new HashSet<String>(Arrays.asList("value"));
        List<StartTag> apexTags = source.getAllStartTags("apex:");
        for (StartTag t : apexTags) {
            JSONObject ap2;
            String attributeName;
            String tagName = t.getName().split(":")[1].toLowerCase();
            if (!tagsWeCareAbout.contains(tagName)) continue;
            Attributes atts = t.getAttributes();
            if (tagName.trim().equals("outputlink")) {
                for (Attribute a : atts) {
                    attributeName = a.getKey();
                    String attributeValue = a.getValue();
                    if (!attributeName.trim().equals("value") || attributeValue.contains("{!")) continue;
                    ap2 = new JSONObject();
                    ap2.put((Object)"location", (Object)a.getRowColumnVector());
                    outputLinkList.add((Object)ap2);
                }
                continue;
            }
            if (!tagName.trim().equals("actionpoller")) continue;
            for (Attribute a : atts) {
                attributeName = a.getKey();
                int interval = 0;
                try {
                    interval = Integer.parseInt(a.getValue());
                }
                catch (Exception ap2) {
                    // empty catch block
                }
                if (!attributeName.trim().equals("interval") || interval > 60) continue;
                ap2 = new JSONObject();
                ap2.put((Object)"location", (Object)a.getRowColumnVector());
                actionPollerList.add((Object)ap2);
            }
        }
        returnObject.put((Object)"actionPollers", (Object)actionPollerList);
        returnObject.put((Object)"outputLinks", (Object)outputLinkList);
        String jsonText = JSONValue.toJSONString((Object)returnObject);
        String json = gson.toJson((Object)returnObject);
        System.out.print(json);
    }

    private static void displaySegments(List<? extends Segment> segments) {
        for (Segment segment : segments) {
            System.out.println("-------------------------------------------------------------------------------");
            System.out.println(segment.getDebugInfo());
            System.out.println(segment);
        }
        System.out.println("\n*******************************************************************************\n");
    }
}

