/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;

public class HTMLSanitiser {
    private static final Set<String> VALID_ELEMENT_NAMES = new HashSet<String>(Arrays.asList("br", "p", "b", "i", "ol", "ul", "li", "a"));
    private static final Set<String> VALID_ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList("id", "class", "href", "target", "title"));
    private static final Object VALID_MARKER = new Object();

    private HTMLSanitiser() {
    }

    public static String encodeInvalidMarkup(String pseudoHTML) {
        return HTMLSanitiser.encodeInvalidMarkup(pseudoHTML, false);
    }

    public static String encodeInvalidMarkup(String pseudoHTML, boolean formatWhiteSpace) {
        return HTMLSanitiser.sanitise(pseudoHTML, formatWhiteSpace, false);
    }

    public static String stripInvalidMarkup(String pseudoHTML) {
        return HTMLSanitiser.stripInvalidMarkup(pseudoHTML, false);
    }

    public static String stripInvalidMarkup(String pseudoHTML, boolean formatWhiteSpace) {
        return HTMLSanitiser.sanitise(pseudoHTML, formatWhiteSpace, true);
    }

    private static String sanitise(String pseudoHTML, boolean formatWhiteSpace, boolean stripInvalidElements) {
        Source source = new Source(pseudoHTML);
        source.fullSequentialParse();
        OutputDocument outputDocument = new OutputDocument(source);
        List<Tag> tags = source.getAllTags();
        int pos = 0;
        for (Tag tag : tags) {
            if (HTMLSanitiser.processTag(tag, outputDocument)) {
                tag.setUserData(VALID_MARKER);
            } else {
                if (!stripInvalidElements) continue;
                outputDocument.remove(tag);
            }
            HTMLSanitiser.reencodeTextSegment(source, outputDocument, pos, tag.getBegin(), formatWhiteSpace);
            pos = tag.getEnd();
        }
        HTMLSanitiser.reencodeTextSegment(source, outputDocument, pos, source.getEnd(), formatWhiteSpace);
        return outputDocument.toString();
    }

    private static boolean processTag(Tag tag, OutputDocument outputDocument) {
        String elementName = tag.getName();
        if (!VALID_ELEMENT_NAMES.contains(elementName)) {
            return false;
        }
        if (tag.getTagType() == StartTagType.NORMAL) {
            Element element = tag.getElement();
            if (HTMLElements.getEndTagRequiredElementNames().contains(elementName)) {
                if (element.getEndTag() == null) {
                    return false;
                }
            } else if (HTMLElements.getEndTagOptionalElementNames().contains(elementName)) {
                if (elementName == "li" && !HTMLSanitiser.isValidLITag(tag)) {
                    return false;
                }
                if (element.getEndTag() == null) {
                    outputDocument.insert(element.getEnd(), HTMLSanitiser.getEndTagHTML(elementName));
                }
            }
            outputDocument.replace(tag, HTMLSanitiser.getStartTagHTML(element.getStartTag()));
        } else if (tag.getTagType() == EndTagType.NORMAL) {
            if (tag.getElement() == null) {
                return false;
            }
            if (elementName == "li" && !HTMLSanitiser.isValidLITag(tag)) {
                return false;
            }
            outputDocument.replace(tag, HTMLSanitiser.getEndTagHTML(elementName));
        } else {
            return false;
        }
        return true;
    }

    private static boolean isValidLITag(Tag tag) {
        Element parentElement = tag.getElement().getParentElement();
        if (parentElement == null) {
            return false;
        }
        if (parentElement.getStartTag().getUserData() != VALID_MARKER) {
            return false;
        }
        return parentElement.getName() == "ul" || parentElement.getName() == "ol";
    }

    private static void reencodeTextSegment(Source source, OutputDocument outputDocument, int begin, int end, boolean formatWhiteSpace) {
        if (begin >= end) {
            return;
        }
        Segment textSegment = new Segment(source, begin, end);
        String decodedText = CharacterReference.decode(textSegment);
        String encodedText = formatWhiteSpace ? CharacterReference.encodeWithWhiteSpaceFormatting(decodedText) : CharacterReference.encode(decodedText);
        outputDocument.replace(textSegment, encodedText);
    }

    private static CharSequence getStartTagHTML(StartTag startTag) {
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(startTag.getName());
        for (Attribute attribute : startTag.getAttributes()) {
            if (!VALID_ATTRIBUTE_NAMES.contains(attribute.getKey())) continue;
            sb.append(' ').append(attribute.getName());
            if (attribute.getValue() == null) continue;
            sb.append("=\"");
            sb.append(CharacterReference.encode(attribute.getValue()));
            sb.append('\"');
        }
        if (startTag.getElement().getEndTag() == null && !HTMLElements.getEndTagOptionalElementNames().contains(startTag.getName())) {
            sb.append(" /");
        }
        sb.append('>');
        return sb;
    }

    private static String getEndTagHTML(String tagName) {
        return "</" + tagName + '>';
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Examples of HTMLSanitiser.encodeInvalidMarkup:");
        System.out.println("----------------------------------------------\n");
        HTMLSanitiser.displayEncodeInvalidMarkup("ab & c", "encode text");
        HTMLSanitiser.displayEncodeInvalidMarkup("abc <u>def</u> geh", "<U> element not allowed");
        HTMLSanitiser.displayEncodeInvalidMarkup("<p>abc", "add optional end tag");
        HTMLSanitiser.displayEncodeInvalidMarkup("<script>abc</script>", "remove potentially dangerous script");
        HTMLSanitiser.displayEncodeInvalidMarkup("<p class=\"xyz\" onmouseover=\"nastyscript\">abc</p>", "keep approved attributes but strip non-approved attributes");
        HTMLSanitiser.displayEncodeInvalidMarkup("<p id=abc class='xyz'>abc</p>", "tidy up attributes to make them XHTML compliant");
        HTMLSanitiser.displayEncodeInvalidMarkup("List:<ul><li>A</li><li>B<li>C</ul>", "inserts optional end tags");
        System.out.println("Examples of HTMLSanitiser.stripInvalidMarkup:");
        System.out.println("---------------------------------------------\n");
        HTMLSanitiser.displayStripInvalidMarkup("ab & c", "encode text");
        HTMLSanitiser.displayStripInvalidMarkup("abc <u>def</u> geh", "<U> element not allowed");
        HTMLSanitiser.displayStripInvalidMarkup("<p>abc", "add optional end tag");
        HTMLSanitiser.displayStripInvalidMarkup("<script>abc</script>", "remove potentially dangerous script");
        HTMLSanitiser.displayStripInvalidMarkup("<p class=\"xyz\" onmouseover=\"nastyscript\">abc</p>", "keep approved attributes but strip non-approved attributes");
        HTMLSanitiser.displayStripInvalidMarkup("<p id=abc class='xyz'>abc</p>", "tidy up attributes to make them XHTML compliant");
        HTMLSanitiser.displayStripInvalidMarkup("List:<ul><li>A</li><li>B<li>C</ul>", "inserts optional end tags");
        HTMLSanitiser.displayStripInvalidMarkup("List:<li>A</li><li>B<li>C", "missing required <UL> or <OL> element");
        HTMLSanitiser.displayStripInvalidMarkup("List:<ul><li>A</li><b><li>B</b><li>C</ul>", "<LI> is invalid as it is not directly under <UL> or <OL>");
        System.out.println("Examples of HTMLSanitiser.stripInvalidMarkup with formatWhiteSpace=true:");
        System.out.println("------------------------------------------------------------------------\n");
        HTMLSanitiser.displayStripInvalidMarkup("abc\ndef", true, "convert LF to <BR>");
        HTMLSanitiser.displayStripInvalidMarkup("    abc", true, "ensure consecutive spaces are rendered");
        HTMLSanitiser.displayStripInvalidMarkup("\tabc", true, "convert TAB to equivalent of four spaces");
    }

    private static void displayEncodeInvalidMarkup(String input, String explanation) {
        HTMLSanitiser.display(input, explanation, HTMLSanitiser.encodeInvalidMarkup(input));
    }

    private static void displayStripInvalidMarkup(String input, String explanation) {
        HTMLSanitiser.display(input, explanation, HTMLSanitiser.stripInvalidMarkup(input));
    }

    private static void displayStripInvalidMarkup(String input, boolean formatWhiteSpace, String explanation) {
        HTMLSanitiser.display(input, explanation, HTMLSanitiser.stripInvalidMarkup(input, formatWhiteSpace));
    }

    private static void display(String input, String explanation, String output) {
        System.out.println(String.valueOf(explanation) + ":\ninput : " + input + "\noutput: " + output + "\n");
    }
}

