/*
 * Decompiled with CFR 0.152.
 */
import org.junit.Assert;
import org.junit.Test;

public class HTMLSanitiserTest {
    @Test
    public void testEncodeInvalidMarkup() {
        Assert.assertEquals((Object)"abc", (Object)HTMLSanitiser.encodeInvalidMarkup("abc"));
        Assert.assertEquals((Object)"ab &amp; c", (Object)HTMLSanitiser.encodeInvalidMarkup("ab & c"));
        Assert.assertEquals((Object)"abc <p>def</p> geh", (Object)HTMLSanitiser.encodeInvalidMarkup("abc <p>def</p> geh"));
        Assert.assertEquals((Object)"abc <b>def</b> geh", (Object)HTMLSanitiser.encodeInvalidMarkup("abc <b>def</b> geh"));
        Assert.assertEquals((Object)"abc <i>def</i> geh", (Object)HTMLSanitiser.encodeInvalidMarkup("abc <i>def</i> geh"));
        Assert.assertEquals((Object)"abc <a href=\"http://url\">def</a> geh", (Object)HTMLSanitiser.encodeInvalidMarkup("abc <a href=\"http://url\">def</a> geh"));
        Assert.assertEquals((Object)"abc <a href=\"http://url\" target=\"_blank\" title=\"Click here for link\">def</a> geh", (Object)HTMLSanitiser.encodeInvalidMarkup("abc <a href=\"http://url\" target=\"_blank\" title=\"Click here for link\">def</a> geh"));
        Assert.assertEquals((Object)"abc <a href=\"http://url?p1=x&amp;p2=y\">def</a> geh", (Object)HTMLSanitiser.encodeInvalidMarkup("abc <a href=\"http://url?p1=x&p2=y\">def</a> geh"));
        Assert.assertEquals((Object)"abc &lt;u&gt;def&lt;/u&gt; geh", (Object)HTMLSanitiser.encodeInvalidMarkup("abc <u>def</u> geh"));
        Assert.assertEquals((Object)"<p>abc</p>", (Object)HTMLSanitiser.encodeInvalidMarkup("<p>abc"));
        Assert.assertEquals((Object)"abc<br />def", (Object)HTMLSanitiser.encodeInvalidMarkup("abc<br>def"));
        Assert.assertEquals((Object)"&lt;script&gt;abc&lt;/script&gt;", (Object)HTMLSanitiser.encodeInvalidMarkup("<script>abc</script>"));
        Assert.assertEquals((Object)"<p class=\"xyz\">abc</p>", (Object)HTMLSanitiser.encodeInvalidMarkup("<p class=\"xyz\" onmouseover=\"nastyscript\">abc</p>"));
        Assert.assertEquals((Object)"<p id=\"abc\" class=\"xyz\">abc</p>", (Object)HTMLSanitiser.encodeInvalidMarkup("<p id=\"abc\" class=\"xyz\">abc</p>"));
        Assert.assertEquals((Object)"<p id=\"abc\" class=\"xyz\">abc</p>", (Object)HTMLSanitiser.encodeInvalidMarkup("<p id=abc class='xyz'>abc</p>"));
        Assert.assertEquals((Object)"List:<ul><li>A</li><li>B</li><li>C</li></ul>", (Object)HTMLSanitiser.encodeInvalidMarkup("List:<ul><li>A</li><li>B<li>C</ul>"));
        Assert.assertEquals((Object)"List:&lt;li&gt;A&lt;/li&gt;&lt;li&gt;B&lt;li&gt;C", (Object)HTMLSanitiser.encodeInvalidMarkup("List:<li>A</li><li>B<li>C"));
        Assert.assertEquals((Object)"List:&lt;ul&gt;&lt;li&gt;A&lt;/li&gt;&lt;li&gt;B&lt;li&gt;C", (Object)HTMLSanitiser.encodeInvalidMarkup("List:<ul><li>A</li><li>B<li>C"));
        Assert.assertEquals((Object)"List:<ul><li>A</li><li><b>B</b></li><li>C</li></ul>", (Object)HTMLSanitiser.encodeInvalidMarkup("List:<ul><li>A</li><li><b>B</b><li>C</ul>"));
        Assert.assertEquals((Object)"List:<ul><li>A</li><b>&lt;li&gt;B</b><li>C</li></ul>", (Object)HTMLSanitiser.encodeInvalidMarkup("List:<ul><li>A</li><b><li>B</b><li>C</ul>"));
    }

    @Test
    public void testStripInvalidMarkup() {
        Assert.assertEquals((Object)"abc", (Object)HTMLSanitiser.stripInvalidMarkup("abc"));
        Assert.assertEquals((Object)"ab &amp; c", (Object)HTMLSanitiser.stripInvalidMarkup("ab & c"));
        Assert.assertEquals((Object)"abc <p>def</p> geh", (Object)HTMLSanitiser.stripInvalidMarkup("abc <p>def</p> geh"));
        Assert.assertEquals((Object)"abc <b>def</b> geh", (Object)HTMLSanitiser.stripInvalidMarkup("abc <b>def</b> geh"));
        Assert.assertEquals((Object)"abc <i>def</i> geh", (Object)HTMLSanitiser.stripInvalidMarkup("abc <i>def</i> geh"));
        Assert.assertEquals((Object)"abc <a href=\"http://url\">def</a> geh", (Object)HTMLSanitiser.stripInvalidMarkup("abc <a href=\"http://url\">def</a> geh"));
        Assert.assertEquals((Object)"abc <a href=\"http://url\" target=\"_blank\" title=\"Click here for link\">def</a> geh", (Object)HTMLSanitiser.stripInvalidMarkup("abc <a href=\"http://url\" target=\"_blank\" title=\"Click here for link\">def</a> geh"));
        Assert.assertEquals((Object)"abc <a href=\"http://url?p1=x&amp;p2=y\">def</a> geh", (Object)HTMLSanitiser.stripInvalidMarkup("abc <a href=\"http://url?p1=x&p2=y\">def</a> geh"));
        Assert.assertEquals((Object)"abc def geh", (Object)HTMLSanitiser.stripInvalidMarkup("abc <u>def</u> geh"));
        Assert.assertEquals((Object)"<p>abc</p>", (Object)HTMLSanitiser.stripInvalidMarkup("<p>abc"));
        Assert.assertEquals((Object)"abc<br />def", (Object)HTMLSanitiser.stripInvalidMarkup("abc<br>def"));
        Assert.assertEquals((Object)"abc", (Object)HTMLSanitiser.stripInvalidMarkup("<script>abc</script>"));
        Assert.assertEquals((Object)"<p class=\"xyz\">abc</p>", (Object)HTMLSanitiser.stripInvalidMarkup("<p class=\"xyz\" onmouseover=\"nastyscript\">abc</p>"));
        Assert.assertEquals((Object)"<p id=\"abc\" class=\"xyz\">abc</p>", (Object)HTMLSanitiser.stripInvalidMarkup("<p id=\"abc\" class=\"xyz\">abc</p>"));
        Assert.assertEquals((Object)"<p id=\"abc\" class=\"xyz\">abc</p>", (Object)HTMLSanitiser.stripInvalidMarkup("<p id=abc class='xyz'>abc</p>"));
        Assert.assertEquals((Object)"List:<ul><li>A</li><li>B</li><li>C</li></ul>", (Object)HTMLSanitiser.stripInvalidMarkup("List:<ul><li>A</li><li>B<li>C</ul>"));
        Assert.assertEquals((Object)"List:ABC", (Object)HTMLSanitiser.stripInvalidMarkup("List:<li>A</li><li>B<li>C"));
        Assert.assertEquals((Object)"List:ABC", (Object)HTMLSanitiser.stripInvalidMarkup("List:<ul><li>A</li><li>B<li>C"));
        Assert.assertEquals((Object)"List:<ul><li>A</li><li><b>B</b></li><li>C</li></ul>", (Object)HTMLSanitiser.stripInvalidMarkup("List:<ul><li>A</li><li><b>B</b><li>C</ul>"));
        Assert.assertEquals((Object)"List:<ul><li>A</li><b>B</b><li>C</li></ul>", (Object)HTMLSanitiser.stripInvalidMarkup("List:<ul><li>A</li><b><li>B</b><li>C</ul>"));
    }

    @Test
    public void testStripInvalidMarkupWithFormatting() {
        Assert.assertEquals((Object)"abc\n   def", (Object)HTMLSanitiser.stripInvalidMarkup("abc\n   def", false));
        Assert.assertEquals((Object)"abc<br />def", (Object)HTMLSanitiser.stripInvalidMarkup("abc\ndef", true));
        Assert.assertEquals((Object)"abc<br />def", (Object)HTMLSanitiser.stripInvalidMarkup("abc\rdef", true));
        Assert.assertEquals((Object)"abc<br />def", (Object)HTMLSanitiser.stripInvalidMarkup("abc\r\ndef", true));
        Assert.assertEquals((Object)"&nbsp; &nbsp; abc", (Object)HTMLSanitiser.stripInvalidMarkup("    abc", true));
        Assert.assertEquals((Object)"&nbsp; &nbsp; abc", (Object)HTMLSanitiser.stripInvalidMarkup("\tabc", true));
    }
}

