/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;

public class SplitLongLines {
    private static final int MAX_LENGTH = 70;
    private static int col;

    public static void main(String[] args) throws Exception {
        String sourceUrlString = "../../doc/index.html";
        if (args.length == 0) {
            System.err.println("Using default argument of \"" + sourceUrlString + '\"');
        } else {
            sourceUrlString = args[0];
        }
        if (sourceUrlString.indexOf(58) == -1) {
            sourceUrlString = "file:" + sourceUrlString;
        }
        URL sourceUrl = new URL(sourceUrlString);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(sourceUrl.openStream()));
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 70) {
                    SplitLongLines.println(line);
                    continue;
                }
                if ((line = line.trim()).length() <= 70) {
                    SplitLongLines.println(line);
                    continue;
                }
                Source source = new Source(line);
                int pos = 0;
                for (Tag tag : source.getAllTags()) {
                    if (pos != tag.getBegin()) {
                        SplitLongLines.print(line.subSequence(pos, tag.getBegin()));
                    }
                    SplitLongLines.printTag(tag, line);
                    pos = tag.getEnd();
                }
                if (pos != line.length()) {
                    SplitLongLines.print(line.subSequence(pos, line.length()));
                }
                SplitLongLines.println();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static void println() {
        System.out.println();
        col = 0;
    }

    private static void println(CharSequence text) {
        System.out.println(text);
        col = 0;
    }

    private static void print(CharSequence text) {
        SplitLongLines.print(text, true);
    }

    private static void print(CharSequence text, boolean splitLongText) {
        if (splitLongText && text.length() > 70) {
            String[] words = text.toString().split("\\s");
            int i = 0;
            while (i < words.length) {
                SplitLongLines.print(words[i], false);
                if (i < words.length - 1) {
                    SplitLongLines.print(" ");
                }
                ++i;
            }
            return;
        }
        if (col > 0 && col + text.length() > 70) {
            SplitLongLines.println();
        }
        System.out.print(text);
        col += text.length();
    }

    private static void printTag(Tag tag, String line) {
        if (tag.length() <= 70 || tag instanceof EndTag) {
            SplitLongLines.print(tag);
            return;
        }
        StartTag startTag = (StartTag)tag;
        Attributes attributes = startTag.getAttributes();
        if (attributes != null) {
            SplitLongLines.print(line.substring(startTag.getBegin(), attributes.getBegin()));
            for (Attribute attribute : attributes) {
                SplitLongLines.print(" ");
                SplitLongLines.print(attribute);
            }
            SplitLongLines.print(line.substring(attributes.getEnd(), startTag.getEnd()));
        } else {
            SplitLongLines.print(startTag);
        }
    }
}

