/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;

public final class Attribute
extends Segment {
    private final String key;
    private final Segment nameSegment;
    private final Segment valueSegment;
    private final Segment valueSegmentIncludingQuotes;
    StartTag startTag = StartTag.NOT_CACHED;
    static final String CHECKED = "checked";
    static final String CLASS = "class";
    static final String DISABLED = "disabled";
    static final String ID = "id";
    static final String MULTIPLE = "multiple";
    static final String NAME = "name";
    static final String SELECTED = "selected";
    static final String STYLE = "style";
    static final String TYPE = "type";
    static final String VALUE = "value";

    Attribute(Source source, String key, Segment nameSegment) {
        this(source, key, nameSegment, null, null);
    }

    Attribute(Source source, String key, Segment nameSegment, Segment valueSegment, Segment valueSegmentIncludingQuotes) {
        super(source, nameSegment.getBegin(), valueSegmentIncludingQuotes == null ? nameSegment.getEnd() : valueSegmentIncludingQuotes.getEnd());
        this.key = key;
        this.nameSegment = nameSegment;
        this.valueSegment = valueSegment;
        this.valueSegmentIncludingQuotes = valueSegmentIncludingQuotes;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.nameSegment.toString();
    }

    public Segment getNameSegment() {
        return this.nameSegment;
    }

    public boolean hasValue() {
        return this.valueSegment != null;
    }

    public String getValue() {
        return CharacterReference.decode(this.valueSegment, true);
    }

    public Segment getValueSegment() {
        return this.valueSegment;
    }

    public Segment getValueSegmentIncludingQuotes() {
        return this.valueSegmentIncludingQuotes;
    }

    public char getQuoteChar() {
        if (this.valueSegment == this.valueSegmentIncludingQuotes) {
            return ' ';
        }
        return this.source.charAt(this.valueSegmentIncludingQuotes.getBegin());
    }

    public StartTag getStartTag() {
        if (this.startTag == StartTag.NOT_CACHED) {
            Tag tag = this.source.getEnclosingTag(this.begin);
            this.startTag = tag == null || tag instanceof EndTag ? null : (StartTag)tag;
        }
        return this.startTag;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder().append(this.key).append(super.getDebugInfo()).append(",name=").append(this.nameSegment.getDebugInfo());
        if (this.hasValue()) {
            sb.append(",value=").append(this.valueSegment.getDebugInfo()).append('\"').append(this.valueSegment).append('\"').append(Config.NewLine);
        } else {
            sb.append(",NO VALUE").append(Config.NewLine);
        }
        return sb.toString();
    }

    Tag appendTidy(Appendable appendable, Tag nextTag) throws IOException {
        appendable.append(' ').append(this.nameSegment);
        if (this.valueSegment != null) {
            appendable.append("=\"");
            while (nextTag != null && nextTag.begin < this.valueSegment.begin) {
                nextTag = nextTag.getNextTag();
            }
            if (nextTag == null || nextTag.begin >= this.valueSegment.end) {
                Attribute.appendTidyValue(appendable, this.valueSegment);
            } else {
                int i = this.valueSegment.begin;
                while (nextTag != null && nextTag.begin < this.valueSegment.end) {
                    Attribute.appendTidyValue(appendable, new Segment(this.source, i, nextTag.begin));
                    if (nextTag.end > this.valueSegment.end) {
                        i = this.valueSegment.end;
                        appendable.append(new Segment(this.source, nextTag.begin, i));
                        break;
                    }
                    appendable.append(nextTag);
                    i = nextTag.end;
                    nextTag = nextTag.getNextTag();
                }
                if (i < this.valueSegment.end) {
                    Attribute.appendTidyValue(appendable, new Segment(this.source, i, this.valueSegment.end));
                }
            }
            appendable.append('\"');
        }
        return nextTag;
    }

    private static void appendTidyValue(Appendable appendable, CharSequence unencodedValue) throws IOException {
        CharacterReference.appendEncode(appendable, CharacterReference.decode(unencodedValue, true), false);
    }

    static Appendable appendHTML(Appendable appendable, CharSequence name, CharSequence value) throws IOException {
        appendable.append(' ').append(name);
        if (value != null) {
            appendable.append("=\"");
            CharacterReference.appendEncode(appendable, value, false);
            appendable.append('\"');
        }
        return appendable;
    }
}

