/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.junit.Assert;
import org.junit.Test;

public class CharacterReferenceTest {
    @Test
    public void testDecode() {
        Assert.assertEquals((Object)"b&b", (Object)CharacterReference.decode("b&amp;b"));
        Assert.assertEquals((Object)"b&b", (Object)CharacterReference.decode("b&#38;b"));
        Assert.assertEquals((Object)"b&b", (Object)CharacterReference.decode("b&#x26;b"));
        Assert.assertEquals((Object)"x\u20acx", (Object)CharacterReference.decode("x&euro;x"));
        Assert.assertEquals((Object)"x\u20acx", (Object)CharacterReference.decode("x&#8364;x"));
        Assert.assertEquals((Object)"x\u20acx", (Object)CharacterReference.decode("x&#x20ac;x"));
    }

    @Test
    public void testDecodeUnterminated() {
        Assert.assertEquals((Object)"b&ampb", (Object)CharacterReference.decode("b&ampb"));
        Assert.assertEquals((Object)"b& b", (Object)CharacterReference.decode("b&amp b"));
        Assert.assertEquals((Object)"b&b", (Object)CharacterReference.decode("b&#38b"));
        Assert.assertEquals((Object)"b&x", (Object)CharacterReference.decode("b&#x26x", true));
        Assert.assertEquals((Object)"x& x", (Object)CharacterReference.decode("x&amp x", false));
        Assert.assertEquals((Object)"x& x", (Object)CharacterReference.decode("x&#38 x", false));
        Assert.assertEquals((Object)"x&#x26 x", (Object)CharacterReference.decode("x&#x26 x", false));
        Assert.assertEquals((Object)"x&euro x", (Object)CharacterReference.decode("x&euro x", false));
        Assert.assertEquals((Object)"x\u20ac x", (Object)CharacterReference.decode("x&#8364 x", false));
        Assert.assertEquals((Object)"x&#x20ac x", (Object)CharacterReference.decode("x&#x20ac x", false));
        Assert.assertEquals((Object)"x& x", (Object)CharacterReference.decode("x&amp x", true));
        Assert.assertEquals((Object)"x& x", (Object)CharacterReference.decode("x&#38 x", true));
        Assert.assertEquals((Object)"x& x", (Object)CharacterReference.decode("x&#x26 x", true));
        Assert.assertEquals((Object)"x&euro x", (Object)CharacterReference.decode("x&euro x", true));
        Assert.assertEquals((Object)"x\u20ac x", (Object)CharacterReference.decode("x&#8364 x", true));
        Assert.assertEquals((Object)"x\u20ac x", (Object)CharacterReference.decode("x&#x20ac x", true));
    }

    @Test
    public void testDecodeAttribute() {
        Source source = new Source("<a href=\"test?a=1&amp;b=2&c=3&euro=4&d=&ltx&gt&e=5\">test</a>");
        StartTag startTag = source.getFirstStartTag("a");
        String href = startTag.getAttributeValue("href");
        Assert.assertEquals((Object)"test?a=1&b=2&c=3&euro=4&d=&ltx>&e=5", (Object)href);
    }
}

