/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormControlType;

public final class FormField {
    private final String name;
    private int userValueCount = 0;
    private boolean allowsMultipleValues = false;
    private LinkedHashSet<String> predefinedValues = null;
    private final LinkedHashSet<FormControl> formControls = new LinkedHashSet();
    private transient FormControl firstFormControl = null;
    int columnIndex;

    FormField(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<FormControl> getFormControls() {
        return this.formControls;
    }

    public FormControl getFormControl(String predefinedValue) {
        if (predefinedValue == null) {
            for (FormControl formControl : this.formControls) {
                if (!formControl.getFormControlType().hasPredefinedValue()) {
                    return formControl;
                }
                if (formControl.getFormControlType().getElementName() == "select" || formControl.getPredefinedValue() != null) continue;
                return formControl;
            }
        } else {
            for (FormControl formControl : this.formControls) {
                if (!(formControl.getFormControlType().getElementName() == "select" ? formControl.getPredefinedValues().contains(predefinedValue) : predefinedValue.equals(formControl.getPredefinedValue()))) continue;
                return formControl;
            }
        }
        return null;
    }

    public FormControl getFormControl() {
        return (FormControl)this.formControls.iterator().next();
    }

    public boolean allowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public int getUserValueCount() {
        return this.userValueCount;
    }

    public Collection<String> getPredefinedValues() {
        if (this.predefinedValues == null) {
            return Collections.emptySet();
        }
        return this.predefinedValues;
    }

    public List<String> getValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (FormControl formControl : this.formControls) {
            formControl.addValuesTo(values);
        }
        return values;
    }

    public void clearValues() {
        for (FormControl formControl : this.formControls) {
            formControl.clearValues();
        }
    }

    public void setValues(Collection<String> values) {
        this.clearValues();
        this.addValues(values);
    }

    public boolean setValue(String value) {
        this.clearValues();
        return value != null ? this.addValue(value) : true;
    }

    public boolean addValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value argument must not be null");
        }
        if (this.formControls.size() == 1) {
            return this.getFirstFormControl().addValue(value);
        }
        LinkedList<FormControl> userValueControls = null;
        for (FormControl formControl : this.formControls) {
            if (!formControl.getFormControlType().hasPredefinedValue()) {
                if (userValueControls == null) {
                    userValueControls = new LinkedList<FormControl>();
                }
                userValueControls.add(formControl);
                continue;
            }
            if (!formControl.addValue(value)) continue;
            return true;
        }
        if (userValueControls == null) {
            return false;
        }
        for (FormControl userFormControl : userValueControls) {
            if (!userFormControl.addValue(value)) continue;
            return true;
        }
        return false;
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Field: ").append(this.name).append(", UserValueCount=").append(this.userValueCount).append(", AllowsMultipleValues=").append(this.allowsMultipleValues);
        if (this.predefinedValues != null) {
            for (String predefinedValue : this.predefinedValues) {
                sb.append(Config.NewLine).append("PredefinedValue: ").append(predefinedValue);
            }
        }
        for (FormControl formControl : this.formControls) {
            sb.append(Config.NewLine).append("FormControl: ").append(formControl.getDebugInfo());
        }
        sb.append(Config.NewLine).append(Config.NewLine);
        return sb.toString();
    }

    public String toString() {
        return this.getDebugInfo();
    }

    void addValues(Collection<String> values) {
        if (values != null) {
            for (String value : values) {
                this.addValue(value);
            }
        }
    }

    void addValues(String[] values) {
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.addValue(value);
                ++n2;
            }
        }
    }

    void addFormControl(FormControl formControl, String predefinedValue) {
        if (predefinedValue == null) {
            ++this.userValueCount;
        } else {
            if (this.predefinedValues == null) {
                this.predefinedValues = new LinkedHashSet();
            }
            this.predefinedValues.add(predefinedValue);
        }
        this.formControls.add(formControl);
        this.allowsMultipleValues = this.calculateAllowsMultipleValues(formControl);
    }

    private boolean calculateAllowsMultipleValues(FormControl newFormControl) {
        if (this.allowsMultipleValues || this.userValueCount > 1) {
            return true;
        }
        if (this.userValueCount == 1) {
            return this.predefinedValues != null;
        }
        if (this.predefinedValues.size() == 1) {
            return false;
        }
        FormControlType newFormControlType = newFormControl.getFormControlType();
        if (this.formControls.size() == 1) {
            return newFormControlType == FormControlType.SELECT_MULTIPLE;
        }
        FormControlType firstFormControlType = this.getFirstFormControl().getFormControlType();
        if (newFormControlType == FormControlType.RADIO && firstFormControlType == FormControlType.RADIO) {
            return false;
        }
        return !newFormControlType.isSubmit() || !firstFormControlType.isSubmit();
    }

    FormControl getFirstFormControl() {
        if (this.firstFormControl == null) {
            this.firstFormControl = (FormControl)this.formControls.iterator().next();
        }
        return this.firstFormControl;
    }

    void merge(FormField formField) {
        if (formField.userValueCount > this.userValueCount) {
            this.userValueCount = formField.userValueCount;
        }
        boolean bl = this.allowsMultipleValues = this.allowsMultipleValues || formField.allowsMultipleValues;
        if (this.predefinedValues == null) {
            this.predefinedValues = formField.predefinedValues;
        } else if (formField.predefinedValues != null) {
            for (String predefinedValue : this.predefinedValues) {
                this.predefinedValues.add(predefinedValue);
            }
        }
        for (FormControl formControl : formField.getFormControls()) {
            this.formControls.add(formControl);
        }
    }
}

