/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

final class IntStringHashMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 15;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient Entry[] entries;
    private transient int size;
    private int threshold;
    private float loadFactor;
    private int bitmask;

    public IntStringHashMap(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.threshold = (int)((float)capacity * loadFactor);
        this.entries = new Entry[capacity];
        this.bitmask = capacity - 1;
    }

    public IntStringHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntStringHashMap() {
        this(15, 0.75f);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private int getIndex(int key) {
        return key & this.bitmask;
    }

    public String get(int key) {
        Entry entry = this.entries[this.getIndex(key)];
        while (entry != null) {
            if (key == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private Entry getEntry(int key) {
        Entry entry = this.entries[this.getIndex(key)];
        while (entry != null && key != entry.key) {
            entry = entry.next;
        }
        return entry;
    }

    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    public String put(int key, String value) {
        int index = this.getIndex(key);
        Entry entry = this.entries[index];
        while (entry != null) {
            if (key == entry.key) {
                String oldValue = entry.value;
                entry.value = value;
                return oldValue;
            }
            entry = entry.next;
        }
        this.entries[index] = new Entry(key, value, this.entries[index]);
        if (this.size++ >= this.threshold) {
            this.increaseCapacity();
        }
        return null;
    }

    private void increaseCapacity() {
        int oldCapacity = this.entries.length;
        Entry[] oldEntries = this.entries;
        this.entries = new Entry[oldCapacity << 1];
        this.bitmask = this.entries.length - 1;
        Entry[] entryArray = oldEntries;
        int n = oldEntries.length;
        int n2 = 0;
        while (n2 < n) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                Entry next = entry.next;
                int index = this.getIndex(entry.key);
                entry.next = this.entries[index];
                this.entries[index] = entry;
                entry = next;
            }
            ++n2;
        }
        this.threshold = (int)((float)this.entries.length * this.loadFactor);
    }

    public String remove(int key) {
        int index = this.getIndex(key);
        Entry previous = null;
        Entry entry = this.entries[index];
        while (entry != null) {
            if (key == entry.key) {
                if (previous == null) {
                    this.entries[index] = entry.next;
                } else {
                    previous.next = entry.next;
                }
                --this.size;
                return entry.value;
            }
            previous = entry;
            entry = previous.next;
        }
        return null;
    }

    public void clear() {
        int i = this.bitmask;
        while (i >= 0) {
            this.entries[i] = null;
            --i;
        }
        this.size = 0;
    }

    public boolean containsValue(String value) {
        if (value == null) {
            int i = this.bitmask;
            while (i >= 0) {
                Entry entry = this.entries[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
                --i;
            }
        } else {
            int i = this.bitmask;
            while (i >= 0) {
                Entry entry = this.entries[i];
                while (entry != null) {
                    if (value.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
                --i;
            }
        }
        return false;
    }

    private static final class Entry {
        final int key;
        String value;
        Entry next;

        public Entry(int key, String value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

