/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.htmlparser.jericho.CharacterEntityReference;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.NumericCharacterReference;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import org.junit.Assert;
import org.junit.Test;

public class NodeIteratorTest {
    private static final String sourceUrlString = "file:test/data/StreamedSourceTest.html";

    @Test
    public void test() throws Exception {
        Source source = new Source(new URL(sourceUrlString));
        Assert.assertEquals((Object)"UTF-8", (Object)source.getEncoding());
        Iterator<Segment> i = source.iterator();
        Assert.assertTrue((boolean)i.hasNext());
        Segment segment = i.next();
        Assert.assertEquals((Object)StartTagType.XML_DECLARATION, (Object)((Tag)segment).getTagType());
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", (Object)segment.toString());
        Assert.assertEquals((Object)"<?xml ?> (XML declaration) ((r1,c1,p0)-(r1,c40,p39))", (Object)segment.getDebugInfo());
        Assert.assertTrue((boolean)i.hasNext());
        segment = i.next();
        Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
        Assert.assertTrue((boolean)i.hasNext());
        segment = i.next();
        Assert.assertEquals((Object)StartTagType.SERVER_COMMON, (Object)((Tag)segment).getTagType());
        Assert.assertEquals((Object)"<%@ page language=\"java\" %>", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)StartTagType.SERVER_COMMON, (Object)((Tag)segment).getTagType());
        Assert.assertEquals((Object)"<%@ taglib uri=\"/WEB-INF/struts-i18n.tld\" prefix=\"i18n\" %>", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)StartTagType.XML_PROCESSING_INSTRUCTION, (Object)((Tag)segment).getTagType());
        Assert.assertEquals((Object)"<?xml-stylesheet href=\"standardstyle.css\" title=\"Standard Stylesheet\" type=\"text/css\"?>", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)StartTagType.DOCTYPE_DECLARATION, (Object)((Tag)segment).getTagType());
        Assert.assertEquals((Object)"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" [\r\n <!ELEMENT greeting (#PCDATA)>\r\n <!ENTITY p CDATA \"<p>\">\r\n]>", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)StartTagType.MARKUP_DECLARATION, (Object)((Tag)segment).getTagType());
        Assert.assertEquals((Object)"<!ELEMENT greeting (#PCDATA)>", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)StartTagType.MARKUP_DECLARATION, (Object)((Tag)segment).getTagType());
        Assert.assertEquals((Object)"<!ENTITY p CDATA \"<p>\">", (Object)segment.toString());
        int x = 0;
        while (x < 7) {
            segment = i.next();
            ++x;
        }
        Assert.assertEquals((Object)"Jericho HTML Parser Test Document", (Object)segment.toString());
        x = 0;
        while (x < 5) {
            segment = i.next();
            ++x;
        }
        StartTag startTag = (StartTag)segment;
        Assert.assertEquals((Object)StartTagType.NORMAL, (Object)startTag.getTagType());
        Assert.assertEquals((Object)"<meta name=\"keywords\" content=\"HTML parser,test document,R&amp;D\" />", (Object)segment.toString());
        Assert.assertEquals((Object)"HTML parser,test document,R&D", (Object)startTag.getAttributeValue("content"));
        x = 0;
        while (x < 8) {
            segment = i.next();
            ++x;
        }
        StringBuilder sb = new StringBuilder();
        segment = i.next();
        Assert.assertEquals((Object)"This paragraph contains character references: ", (Object)segment.toString());
        sb.append(segment);
        segment = i.next();
        Assert.assertEquals((Object)"&euro;", (Object)segment.toString());
        CharacterEntityReference characterEntityReference = (CharacterEntityReference)segment;
        characterEntityReference.appendCharTo(sb);
        segment = i.next();
        Assert.assertEquals((Object)" and ", (Object)segment.toString());
        sb.append(segment);
        segment = i.next();
        Assert.assertEquals((Object)"&#169;", (Object)segment.toString());
        NumericCharacterReference numericCharacterReference = (NumericCharacterReference)segment;
        numericCharacterReference.appendCharTo(sb);
        segment = i.next();
        Assert.assertEquals((Object)".", (Object)segment.toString());
        sb.append(segment);
        Assert.assertEquals((Object)"This paragraph contains character references: \u20ac and \u00a9.", (Object)sb.toString());
        int x2 = 0;
        while (x2 < 3) {
            segment = i.next();
            ++x2;
        }
        startTag = (StartTag)segment;
        Assert.assertEquals((Object)StartTagType.COMMENT, (Object)startTag.getTagType());
        Assert.assertEquals((Object)"<!-- <p>This paragraph is commented out</p> -->", (Object)segment.toString());
        Assert.assertEquals((Object)" <p>This paragraph is commented out</p> ", (Object)startTag.getTagContent().toString());
        segment = i.next();
        Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)"<input type=\"button\" value=\"Click here to execute script\" title=\"simply writes some text using document.write\"\r\n  onclick=\"document.write('<h2>This element is defined inside an onclick attribute</h2>')\"/>", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
        x2 = 0;
        while (x2 < 5) {
            segment = i.next();
            ++x2;
        }
        startTag = (StartTag)segment;
        Assert.assertEquals((Object)StartTagType.CDATA_SECTION, (Object)startTag.getTagType());
        Assert.assertEquals((Object)"<![CDATA[\r\n <an> example of <sgml> markup that is not <painful> to write with < and such.\r\n]]>", (Object)segment.toString());
        Assert.assertEquals((Object)"\r\n <an> example of <sgml> markup that is not <painful> to write with < and such.\r\n", (Object)startTag.getTagContent().toString());
        segment = i.next();
        segment = i.next();
        Assert.assertEquals((Object)"<script language=\"javascript\" type=\"text/javascript\">", (Object)segment.toString());
        segment = i.next();
        segment = i.next();
        Assert.assertEquals((Object)"</script>", (Object)segment.toString());
        segment = i.next();
        segment = i.next();
        Assert.assertEquals((Object)"<script language=\"javascript\" type=\"text/javascript\">", (Object)segment.toString());
        segment = i.next();
        segment = i.next();
        Assert.assertEquals((Object)"</script>", (Object)segment.toString());
        segment = i.next();
        segment = i.next();
        Assert.assertEquals((Object)"<script language=\"javascript\" type=\"text/javascript\">", (Object)segment.toString());
        segment = i.next();
        segment = i.next();
        Assert.assertEquals((Object)"</script>", (Object)segment.toString());
        segment = i.next();
        segment = i.next();
        startTag = (StartTag)segment;
        Assert.assertEquals((Object)StartTagType.COMMENT, (Object)startTag.getTagType());
        segment = i.next();
        Assert.assertEquals((Object)"<% server tag %>", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)"<hr>", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
        segment = i.next();
        startTag = (StartTag)segment;
        Assert.assertEquals((Object)StartTagType.SERVER_COMMON_COMMENT, (Object)startTag.getTagType());
        segment = i.next();
        Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)"<hr>", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)"\r\n<*abc def=\"ghi\">\r\n This is an example of an element from a hypothetical server language \r\n whose tag formats have not been registered with the TagTypeRegister class \r\n</*abc>\r\n", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((Object)"<p>", (Object)segment.toString());
        segment = i.next();
        Assert.assertEquals((long)20071L, (long)segment.length());
        segment = i.next();
        Assert.assertEquals((Object)"</p>", (Object)segment.toString());
        segment = i.next();
        segment = i.next();
        startTag = (StartTag)segment;
        Assert.assertEquals((Object)StartTagType.COMMENT, (Object)startTag.getTagType());
        Assert.assertEquals((long)20077L, (long)segment.length());
        segment = i.next();
        Assert.assertTrue((boolean)i.hasNext());
        segment = i.next();
        Assert.assertEquals((Object)"</html>", (Object)segment.toString());
        Assert.assertTrue((boolean)i.hasNext());
        segment = i.next();
        Assert.assertEquals((Object)"\r\n", (Object)segment.toString());
        Assert.assertFalse((boolean)i.hasNext());
        try {
            segment = i.next();
            Assert.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testLegacyIteratorCompatabilityMode() throws Exception {
        Segment segment;
        Source source = new Source(new URL(sourceUrlString));
        Source.LegacyIteratorCompatabilityMode = true;
        Iterator<Segment> i = source.iterator();
        Source.LegacyIteratorCompatabilityMode = false;
        int x = 0;
        while (x < 30) {
            segment = i.next();
            ++x;
        }
        segment = i.next();
        Assert.assertEquals((Object)"This paragraph contains character references: &euro; and &#169;.", (Object)segment.toString());
        Assert.assertEquals((Object)"This paragraph contains character references: \u20ac and \u00a9.", (Object)CharacterReference.decode(segment.toString()));
    }

    @Test
    public void testCharacterReferences() throws Exception {
        String sourceText = "&amp;<a>&amp;<b title=\"&amp;\">ww&amp;<c>&amp;xx<d>yy&amp;zz&amp;<e>&amp;";
        Source source = new Source(sourceText);
        Iterator<Segment> i = source.iterator();
        Assert.assertTrue((boolean)(i.next() instanceof CharacterReference));
        Assert.assertTrue((boolean)(i.next() instanceof Tag));
        Assert.assertTrue((boolean)(i.next() instanceof CharacterReference));
        Assert.assertTrue((boolean)(i.next() instanceof Tag));
        Assert.assertEquals((Object)"ww", (Object)i.next().toString());
        Assert.assertTrue((boolean)(i.next() instanceof CharacterReference));
        Assert.assertTrue((boolean)(i.next() instanceof Tag));
        Assert.assertTrue((boolean)(i.next() instanceof CharacterReference));
        Assert.assertEquals((Object)"xx", (Object)i.next().toString());
        Assert.assertTrue((boolean)(i.next() instanceof Tag));
        Assert.assertEquals((Object)"yy", (Object)i.next().toString());
        Assert.assertTrue((boolean)(i.next() instanceof CharacterReference));
        Assert.assertEquals((Object)"zz", (Object)i.next().toString());
        Assert.assertTrue((boolean)(i.next() instanceof CharacterReference));
        Assert.assertTrue((boolean)(i.next() instanceof Tag));
        Assert.assertTrue((boolean)(i.next() instanceof CharacterReference));
    }
}

