/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.AttributesOutputSegment;
import net.htmlparser.jericho.BlankOutputSegment;
import net.htmlparser.jericho.CharOutputSegment;
import net.htmlparser.jericho.CharStreamSource;
import net.htmlparser.jericho.CharStreamSourceUtil;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.OutputSegment;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.RemoveOutputSegment;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StringOutputSegment;

public final class OutputDocument
implements CharStreamSource {
    private CharSequence sourceText;
    private ArrayList<OutputSegment> outputSegments = new ArrayList();
    private final Segment segment;

    public OutputDocument(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.segment = source;
        this.sourceText = source;
    }

    public OutputDocument(Segment segment) {
        if (segment == null) {
            throw new IllegalArgumentException("segment argument must not be null");
        }
        this.segment = segment;
        Source source = segment.source;
        this.sourceText = source;
        if (segment.begin > 0) {
            this.remove(0, segment.begin);
        }
        if (segment.end < source.end) {
            this.remove(segment.end, source.end);
        }
    }

    OutputDocument(ParseText parseText) {
        this.sourceText = parseText;
        this.segment = null;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public void remove(int begin, int end) {
        this.register(new RemoveOutputSegment(begin, end));
    }

    public void remove(Segment segment) {
        this.register(new RemoveOutputSegment(segment));
    }

    public void remove(Collection<? extends Segment> segments) {
        for (Segment segment : segments) {
            this.remove(segment);
        }
    }

    public void insert(int pos, CharSequence text) {
        this.register(new StringOutputSegment(pos, pos, text));
    }

    public void replace(Segment segment, CharSequence text) {
        this.replace(segment.getBegin(), segment.getEnd(), text);
    }

    public void replace(int begin, int end, CharSequence text) {
        this.register(new StringOutputSegment(begin, end, text));
    }

    public void replace(int begin, int end, char ch) {
        this.register(new CharOutputSegment(begin, end, ch));
    }

    public void replace(FormControl formControl) {
        formControl.replaceInOutputDocument(this);
    }

    public void replace(FormFields formFields) {
        formFields.replaceInOutputDocument(this);
    }

    public Map<String, String> replace(Attributes attributes, boolean convertNamesToLowerCase) {
        AttributesOutputSegment attributesOutputSegment = new AttributesOutputSegment(attributes, convertNamesToLowerCase);
        this.register(attributesOutputSegment);
        return attributesOutputSegment.getMap();
    }

    public void replace(Attributes attributes, Map<String, String> map) {
        this.register(new AttributesOutputSegment(attributes, map));
    }

    public void replaceWithSpaces(int begin, int end) {
        this.register(new BlankOutputSegment(begin, end));
    }

    public void register(OutputSegment outputSegment) {
        this.outputSegments.add(outputSegment);
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        try {
            this.appendTo(writer);
        }
        finally {
            writer.flush();
        }
    }

    public void writeTo(Writer writer, int begin, int end) throws IOException {
        try {
            this.appendTo(writer, begin, end);
        }
        finally {
            writer.flush();
        }
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        this.appendTo(appendable, 0, this.sourceText.length());
    }

    public void appendTo(Appendable appendable, int begin, int end) throws IOException {
        if (this.outputSegments.isEmpty()) {
            appendable.append(this.sourceText, begin, end);
            return;
        }
        int pos = begin;
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        for (OutputSegment outputSegment : this.outputSegments) {
            if (outputSegment.getEnd() < pos || outputSegment.getEnd() == pos && outputSegment.getBegin() < pos) continue;
            if (outputSegment.getBegin() > end || outputSegment.getBegin() == end && outputSegment.getEnd() > end) break;
            if (outputSegment.getBegin() > pos) {
                appendable.append(this.sourceText, pos, outputSegment.getBegin());
            }
            if (outputSegment.getBegin() < pos && outputSegment instanceof BlankOutputSegment) {
                int outputSegmentEnd = outputSegment.getEnd();
                while (pos < outputSegmentEnd) {
                    appendable.append(' ');
                    ++pos;
                }
                continue;
            }
            outputSegment.appendTo(appendable);
            pos = outputSegment.getEnd();
        }
        if (pos < end) {
            appendable.append(this.sourceText, pos, end);
        }
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        long estimatedMaximumOutputLength = this.sourceText.length();
        for (OutputSegment outputSegment : this.outputSegments) {
            int outputSegmentOriginalLength = outputSegment.getEnd() - outputSegment.getBegin();
            estimatedMaximumOutputLength += outputSegment.getEstimatedMaximumOutputLength() - (long)outputSegmentOriginalLength;
        }
        return estimatedMaximumOutputLength >= 0L ? estimatedMaximumOutputLength : -1L;
    }

    @Override
    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        for (OutputSegment outputSegment : this.getRegisteredOutputSegments()) {
            if (outputSegment instanceof BlankOutputSegment) {
                sb.append("Replace with Spaces: ");
            } else if (outputSegment instanceof RemoveOutputSegment) {
                sb.append("Remove: ");
            } else {
                sb.append("Replace: ");
            }
            if (this.sourceText instanceof Source) {
                Source source = (Source)this.sourceText;
                sb.append('(');
                source.getRowColumnVector(outputSegment.getBegin()).appendTo(sb);
                sb.append('-');
                source.getRowColumnVector(outputSegment.getEnd()).appendTo(sb);
                sb.append(')');
            } else {
                sb.append("(p").append(outputSegment.getBegin()).append("-p").append(outputSegment.getEnd()).append(')');
            }
            sb.append(' ');
            String outputFromSegment = outputSegment.toString();
            if (outputFromSegment.length() <= 20) {
                sb.append(outputFromSegment);
            } else {
                sb.append(outputFromSegment.substring(0, 20)).append("...");
            }
            sb.append(Config.NewLine);
        }
        return sb.toString();
    }

    public List<OutputSegment> getRegisteredOutputSegments() {
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        return this.outputSegments;
    }
}

