/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.htmlparser.jericho.CharStreamSource;
import net.htmlparser.jericho.CharStreamSourceUtil;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.RendererCSS;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;

public class Renderer
implements CharStreamSource {
    private final Segment rootSegment;
    private int maxLineLength = 76;
    private int hrLineLength = 72;
    private String newLine = "\r\n";
    private boolean includeHyperlinkURLs = true;
    private boolean includeAlternateText = true;
    private boolean decorateFontStyles = false;
    private boolean convertNonBreakingSpaces = Config.ConvertNonBreakingSpaces;
    private int blockIndentSize = 4;
    private int listIndentSize = 6;
    private char[] listBullets = new char[]{'*', 'o', '+', '#'};
    private boolean includeFirstElementTopMargin = false;
    private String tableCellSeparator = " \t";
    private static final int DEFAULT_LINE_LENGTH = 76;
    private static final int UNORDERED_LIST = -1;
    private static Map<String, ElementHandler> ELEMENT_HANDLERS = new HashMap<String, ElementHandler>();

    static {
        ELEMENT_HANDLERS.put("a", A_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("address", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("applet", AlternateTextElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("b", FontStyleElementHandler.INSTANCE_B);
        ELEMENT_HANDLERS.put("blockquote", StandardBlockElementHandler.INSTANCE_1_1_INDENT);
        ELEMENT_HANDLERS.put("br", BR_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("button", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("caption", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("center", StandardBlockElementHandler.INSTANCE_1_1);
        ELEMENT_HANDLERS.put("code", FontStyleElementHandler.INSTANCE_CODE);
        ELEMENT_HANDLERS.put("dd", StandardBlockElementHandler.INSTANCE_0_0_INDENT);
        ELEMENT_HANDLERS.put("dir", ListElementHandler.INSTANCE_UL);
        ELEMENT_HANDLERS.put("div", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("dt", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("em", FontStyleElementHandler.INSTANCE_I);
        ELEMENT_HANDLERS.put("fieldset", StandardBlockElementHandler.INSTANCE_1_1);
        ELEMENT_HANDLERS.put("form", StandardBlockElementHandler.INSTANCE_1_1);
        ELEMENT_HANDLERS.put("h1", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("h2", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("h3", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("h4", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("h5", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("h6", StandardBlockElementHandler.INSTANCE_2_1);
        ELEMENT_HANDLERS.put("head", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("hr", HR_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("i", FontStyleElementHandler.INSTANCE_I);
        ELEMENT_HANDLERS.put("img", AlternateTextElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("input", AlternateTextElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("legend", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("li", LI_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("menu", ListElementHandler.INSTANCE_UL);
        ELEMENT_HANDLERS.put("map", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("noframes", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("noscript", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("ol", ListElementHandler.INSTANCE_OL);
        ELEMENT_HANDLERS.put("p", StandardBlockElementHandler.INSTANCE_1_1);
        ELEMENT_HANDLERS.put("pre", PRE_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("script", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("select", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("strong", FontStyleElementHandler.INSTANCE_B);
        ELEMENT_HANDLERS.put("style", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("textarea", RemoveElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("td", TD_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("th", TD_ElementHandler.INSTANCE);
        ELEMENT_HANDLERS.put("tr", StandardBlockElementHandler.INSTANCE_0_0);
        ELEMENT_HANDLERS.put("u", FontStyleElementHandler.INSTANCE_U);
        ELEMENT_HANDLERS.put("ul", ListElementHandler.INSTANCE_UL);
    }

    public Renderer(Segment segment) {
        this.rootSegment = segment;
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
        writer.flush();
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        new Processor(this, this.rootSegment, this.getMaxLineLength(), this.getHRLineLength(), this.getNewLine(), this.getIncludeHyperlinkURLs(), this.getIncludeAlternateText(), this.getDecorateFontStyles(), this.getConvertNonBreakingSpaces(), this.getBlockIndentSize(), this.getListIndentSize(), this.getListBullets(), this.getTableCellSeparator()).appendTo(appendable);
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        return this.rootSegment.length();
    }

    @Override
    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public Renderer setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
        if (maxLineLength > 0) {
            this.hrLineLength = Math.max(2, maxLineLength - 4);
        }
        return this;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public Renderer setHRLineLength(int hrLineLength) {
        this.hrLineLength = hrLineLength;
        return this;
    }

    public int getHRLineLength() {
        return this.hrLineLength;
    }

    public Renderer setNewLine(String newLine) {
        this.newLine = newLine;
        return this;
    }

    public String getNewLine() {
        if (this.newLine == null) {
            this.newLine = this.rootSegment.source.getBestGuessNewLine();
        }
        return this.newLine;
    }

    public Renderer setIncludeHyperlinkURLs(boolean includeHyperlinkURLs) {
        this.includeHyperlinkURLs = includeHyperlinkURLs;
        return this;
    }

    public boolean getIncludeHyperlinkURLs() {
        return this.includeHyperlinkURLs;
    }

    public String renderHyperlinkURL(StartTag startTag) {
        String href = startTag.getAttributeValue("href");
        if (href == null || href.startsWith("javascript:")) {
            return null;
        }
        try {
            URI uri = new URI(href);
            if (!uri.isAbsolute()) {
                return null;
            }
        }
        catch (URISyntaxException ex) {
            return null;
        }
        return String.valueOf('<') + href + '>';
    }

    public Renderer setIncludeAlternateText(boolean includeAlternateText) {
        this.includeAlternateText = includeAlternateText;
        return this;
    }

    public boolean getIncludeAlternateText() {
        return this.includeAlternateText;
    }

    public String renderAlternateText(StartTag startTag) {
        if (startTag.getName() == "area") {
            return null;
        }
        String alt = startTag.getAttributeValue("alt");
        if (alt == null || alt.length() == 0) {
            return null;
        }
        return String.valueOf('[') + alt + ']';
    }

    public Renderer setDecorateFontStyles(boolean decorateFontStyles) {
        this.decorateFontStyles = decorateFontStyles;
        return this;
    }

    public boolean getDecorateFontStyles() {
        return this.decorateFontStyles;
    }

    public Renderer setConvertNonBreakingSpaces(boolean convertNonBreakingSpaces) {
        this.convertNonBreakingSpaces = convertNonBreakingSpaces;
        return this;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.convertNonBreakingSpaces;
    }

    public Renderer setBlockIndentSize(int blockIndentSize) {
        this.blockIndentSize = blockIndentSize;
        return this;
    }

    public int getBlockIndentSize() {
        return this.blockIndentSize;
    }

    public Renderer setListIndentSize(int listIndentSize) {
        this.listIndentSize = listIndentSize;
        return this;
    }

    public int getListIndentSize() {
        return this.listIndentSize;
    }

    public Renderer setListBullets(char[] listBullets) {
        if (listBullets == null || listBullets.length == 0) {
            throw new IllegalArgumentException("listBullets argument must be an array of at least one character");
        }
        this.listBullets = listBullets;
        return this;
    }

    public char[] getListBullets() {
        return this.listBullets;
    }

    public Renderer setIncludeFirstElementTopMargin(boolean includeFirstElementTopMargin) {
        this.includeFirstElementTopMargin = includeFirstElementTopMargin;
        return this;
    }

    public boolean getIncludeFirstElementTopMargin() {
        return this.includeFirstElementTopMargin;
    }

    public Renderer setTableCellSeparator(String tableCellSeparator) {
        this.tableCellSeparator = tableCellSeparator;
        return this;
    }

    public String getTableCellSeparator() {
        return this.tableCellSeparator;
    }

    public static void setDefaultTopMargin(String htmlElementName, int topMargin) {
        htmlElementName = HTMLElements.getConstantElementName(htmlElementName.toLowerCase());
        ELEMENT_HANDLERS.put(htmlElementName, Renderer.getAbstractBlockElementHandler(htmlElementName).newTopMargin(topMargin));
    }

    public static int getDefaultTopMargin(String htmlElementName) {
        return Renderer.getAbstractBlockElementHandler(htmlElementName.toLowerCase()).getTopMargin();
    }

    public static void setDefaultBottomMargin(String htmlElementName, int bottomMargin) {
        htmlElementName = HTMLElements.getConstantElementName(htmlElementName.toLowerCase());
        ELEMENT_HANDLERS.put(htmlElementName, Renderer.getAbstractBlockElementHandler(htmlElementName).newBottomMargin(bottomMargin));
    }

    public static int getDefaultBottomMargin(String htmlElementName) {
        return Renderer.getAbstractBlockElementHandler(htmlElementName.toLowerCase()).getBottomMargin();
    }

    public static void setDefaultIndent(String htmlElementName, boolean indent) {
        if ((htmlElementName = HTMLElements.getConstantElementName(htmlElementName.toLowerCase())) == "li") {
            throw new UnsupportedOperationException();
        }
        ELEMENT_HANDLERS.put(htmlElementName, Renderer.getAbstractBlockElementHandler(htmlElementName).newIndent(indent));
    }

    public static boolean isDefaultIndent(String htmlElementName) {
        if ((htmlElementName = HTMLElements.getConstantElementName(htmlElementName.toLowerCase())) == "li") {
            throw new UnsupportedOperationException();
        }
        return Renderer.getAbstractBlockElementHandler(htmlElementName.toLowerCase()).isIndent();
    }

    private static AbstractBlockElementHandler getAbstractBlockElementHandler(String htmlElementName) {
        ElementHandler elementHandler = ELEMENT_HANDLERS.get(htmlElementName);
        if (elementHandler == null || !(elementHandler instanceof AbstractBlockElementHandler)) {
            throw new UnsupportedOperationException("Cannot set block properties on element " + htmlElementName);
        }
        return (AbstractBlockElementHandler)elementHandler;
    }

    private static final String getInformalURL(String url) {
        if (url.startsWith("http://")) {
            url = url.substring(7);
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private static final class A_ElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new A_ElementHandler();

        private A_ElementHandler() {
        }

        @Override
        public void process(Processor x, Element element) throws IOException {
            if (!x.includeHyperlinkURLs) {
                x.appendElementContent(element);
                return;
            }
            String renderedHyperlinkURL = x.renderer.renderHyperlinkURL(element.getStartTag());
            if (renderedHyperlinkURL == null) {
                x.appendElementContent(element);
                return;
            }
            String href = element.getAttributeValue("href");
            boolean displayContent = href == null || !Renderer.getInformalURL(href).equals(Renderer.getInformalURL(element.getContent().toString()));
            int linkLength = renderedHyperlinkURL.length();
            if (displayContent) {
                x.appendElementContent(element);
                ++linkLength;
            }
            if (x.maxLineLength > 0 && x.col + linkLength >= x.maxLineLength) {
                x.startNewLine(0);
            } else if (displayContent) {
                x.append(' ');
            }
            x.append(renderedHyperlinkURL);
            x.lastCharWhiteSpace = true;
        }
    }

    private static abstract class AbstractBlockElementHandler
    implements ElementHandler {
        private final int topMargin;
        private final int bottomMargin;
        private final boolean indent;

        protected AbstractBlockElementHandler(int topMargin, int bottomMargin, boolean indent) {
            this.topMargin = topMargin;
            this.bottomMargin = bottomMargin;
            this.indent = indent;
        }

        @Override
        public void process(Processor x, Element element) throws IOException {
            x.blockBoundary(RendererCSS.getTopMargin(element, this.topMargin));
            int leftMargin = RendererCSS.getLeftMargin(element, this.indent ? x.blockIndentSize : 0);
            Processor processor = x;
            processor.indentSize = processor.indentSize + leftMargin;
            this.processBlockContent(x, element);
            Processor processor2 = x;
            processor2.indentSize = processor2.indentSize - leftMargin;
            x.blockBoundary(RendererCSS.getBottomMargin(element, this.bottomMargin));
        }

        public AbstractBlockElementHandler newTopMargin(int topMargin) {
            return this.newInstance(topMargin, this.bottomMargin, this.indent);
        }

        public int getTopMargin() {
            return this.topMargin;
        }

        public AbstractBlockElementHandler newBottomMargin(int bottomMargin) {
            return this.newInstance(this.topMargin, bottomMargin, this.indent);
        }

        public int getBottomMargin() {
            return this.bottomMargin;
        }

        public AbstractBlockElementHandler newIndent(boolean indent) {
            return this.newInstance(this.topMargin, this.bottomMargin, indent);
        }

        public boolean isIndent() {
            return this.indent;
        }

        protected abstract void processBlockContent(Processor var1, Element var2) throws IOException;

        protected abstract AbstractBlockElementHandler newInstance(int var1, int var2, boolean var3);
    }

    private static final class AlternateTextElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new AlternateTextElementHandler();

        private AlternateTextElementHandler() {
        }

        @Override
        public void process(Processor x, Element element) throws IOException {
            if (!x.includeAlternateText) {
                return;
            }
            String text = x.renderer.renderAlternateText(element.getStartTag());
            if (text == null) {
                return;
            }
            x.appendText(text);
        }
    }

    private static final class BR_ElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new BR_ElementHandler();

        private BR_ElementHandler() {
        }

        @Override
        public void process(Processor x, Element element) throws IOException {
            if (x.isBlockBoundary() && !x.atStartOfLine && !x.skipInitialNewLines) {
                x.newLine();
            }
            x.newLine();
            x.blockBoundary(0);
        }
    }

    private static interface ElementHandler {
        public void process(Processor var1, Element var2) throws IOException;
    }

    private static final class FontStyleElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE_B = new FontStyleElementHandler('*');
        public static final ElementHandler INSTANCE_I = new FontStyleElementHandler('/');
        public static final ElementHandler INSTANCE_U = new FontStyleElementHandler('_');
        public static final ElementHandler INSTANCE_CODE = new FontStyleElementHandler('|');
        private final char decorationChar;

        public FontStyleElementHandler(char decorationChar) {
            this.decorationChar = decorationChar;
        }

        @Override
        public void process(Processor x, Element element) throws IOException {
            if (x.decorateFontStyles) {
                if (x.isBlockBoundary()) {
                    x.appendBlockVerticalMargin();
                } else if (x.lastCharWhiteSpace) {
                    x.append(' ');
                    x.lastCharWhiteSpace = false;
                }
                x.append(this.decorationChar);
                x.appendElementContent(element);
                if (x.decorateFontStyles) {
                    x.append(this.decorationChar);
                }
            } else {
                x.appendElementContent(element);
            }
        }
    }

    private static final class HR_ElementHandler
    extends AbstractBlockElementHandler {
        public static final ElementHandler INSTANCE = new HR_ElementHandler();

        private HR_ElementHandler() {
            this(0, 0, false);
        }

        private HR_ElementHandler(int topMargin, int bottomMargin, boolean indent) {
            super(topMargin, bottomMargin, indent);
        }

        @Override
        protected void processBlockContent(Processor x, Element element) throws IOException {
            x.appendBlockVerticalMargin();
            x.append('-');
            int i = x.col;
            while (i < x.hrLineLength) {
                x.appendable.append('-');
                ++i;
            }
            x.col = x.hrLineLength;
        }

        @Override
        protected AbstractBlockElementHandler newInstance(int topMargin, int bottomMargin, boolean indent) {
            return new HR_ElementHandler(topMargin, bottomMargin, indent);
        }
    }

    private static final class LI_ElementHandler
    extends AbstractBlockElementHandler {
        public static final ElementHandler INSTANCE = new LI_ElementHandler();

        private LI_ElementHandler() {
            this(0, 0, false);
        }

        private LI_ElementHandler(int topMargin, int bottomMargin, boolean indent) {
            super(topMargin, bottomMargin, indent);
        }

        @Override
        protected void processBlockContent(Processor x, Element element) throws IOException {
            if (x.listBulletNumber != -1) {
                Processor processor = x;
                processor.listBulletNumber = processor.listBulletNumber + 1;
            }
            x.bullet = true;
            x.appendBlockVerticalMargin();
            x.appendIndent();
            x.skipInitialNewLines = true;
            x.blockBoundary(0);
            x.appendElementContent(element);
            x.bullet = false;
        }

        @Override
        protected AbstractBlockElementHandler newInstance(int topMargin, int bottomMargin, boolean indent) {
            return new LI_ElementHandler(topMargin, bottomMargin, indent);
        }
    }

    private static final class ListElementHandler
    extends AbstractBlockElementHandler {
        public static final ElementHandler INSTANCE_OL = new ListElementHandler(0);
        public static final ElementHandler INSTANCE_UL = new ListElementHandler(-1);
        private final int initialListBulletNumber;

        private ListElementHandler(int initialListBulletNumber) {
            this(initialListBulletNumber, 0, 0, false);
        }

        private ListElementHandler(int initialListBulletNumber, int topMargin, int bottomMargin, boolean indent) {
            super(topMargin, bottomMargin, indent);
            this.initialListBulletNumber = initialListBulletNumber;
        }

        @Override
        protected void processBlockContent(Processor x, Element element) throws IOException {
            int oldListBulletNumber = x.listBulletNumber;
            x.listBulletNumber = this.initialListBulletNumber;
            Processor processor = x;
            processor.listIndentLevel = processor.listIndentLevel + 1;
            x.appendElementContent(element);
            Processor processor2 = x;
            processor2.listIndentLevel = processor2.listIndentLevel - 1;
            x.listBulletNumber = oldListBulletNumber;
        }

        @Override
        protected AbstractBlockElementHandler newInstance(int topMargin, int bottomMargin, boolean indent) {
            return new ListElementHandler(this.initialListBulletNumber, topMargin, bottomMargin, indent);
        }
    }

    private static final class PRE_ElementHandler
    extends AbstractBlockElementHandler {
        public static final ElementHandler INSTANCE = new PRE_ElementHandler();

        private PRE_ElementHandler() {
            this(1, 1, false);
        }

        private PRE_ElementHandler(int topMargin, int bottomMargin, boolean indent) {
            super(topMargin, bottomMargin, indent);
        }

        @Override
        protected void processBlockContent(Processor x, Element element) throws IOException {
            boolean oldPreformatted = x.preformatted;
            x.preformatted = true;
            x.appendElementContent(element);
            x.preformatted = oldPreformatted;
        }

        @Override
        protected AbstractBlockElementHandler newInstance(int topMargin, int bottomMargin, boolean indent) {
            return new PRE_ElementHandler(topMargin, bottomMargin, indent);
        }
    }

    private static final class Processor {
        private final Renderer renderer;
        private final Segment rootSegment;
        private final Source source;
        private final int maxLineLength;
        private final int hrLineLength;
        private final String newLine;
        private final boolean includeHyperlinkURLs;
        private final boolean includeAlternateText;
        private final boolean decorateFontStyles;
        private final boolean convertNonBreakingSpaces;
        private final int blockIndentSize;
        private final int listIndentSize;
        private final char[] listBullets;
        private final String tableCellSeparator;
        private Appendable appendable;
        private int renderedIndex;
        private boolean atStartOfLine;
        private boolean skipInitialNewLines;
        private int col;
        private int listIndentLevel;
        private int indentSize;
        private int blockVerticalMargin;
        private boolean preformatted;
        private boolean lastCharWhiteSpace;
        private final boolean ignoreInitialWhiteSpace = false;
        private boolean bullet;
        private int listBulletNumber;
        private static final int NO_MARGIN = -1;

        public Processor(Renderer renderer, Segment rootSegment, int maxLineLength, int hrLineLength, String newLine, boolean includeHyperlinkURLs, boolean includeAlternateText, boolean decorateFontStyles, boolean convertNonBreakingSpaces, int blockIndentSize, int listIndentSize, char[] listBullets, String tableCellSeparator) {
            this.renderer = renderer;
            this.rootSegment = rootSegment;
            this.source = rootSegment.source;
            this.maxLineLength = maxLineLength;
            this.hrLineLength = hrLineLength;
            this.newLine = newLine;
            this.includeHyperlinkURLs = includeHyperlinkURLs;
            this.includeAlternateText = includeAlternateText;
            this.decorateFontStyles = decorateFontStyles;
            this.convertNonBreakingSpaces = convertNonBreakingSpaces;
            this.blockIndentSize = blockIndentSize;
            this.listIndentSize = listIndentSize;
            this.listBullets = listBullets;
            this.tableCellSeparator = tableCellSeparator;
        }

        public void appendTo(Appendable appendable) throws IOException {
            this.reset();
            this.appendable = appendable;
            List<Element> elements = this.rootSegment instanceof Element ? Collections.singletonList((Element)this.rootSegment) : this.rootSegment.getChildElements();
            this.appendSegmentProcessingChildElements(this.rootSegment.begin, this.rootSegment.end, elements);
        }

        private void reset() {
            this.renderedIndex = 0;
            this.atStartOfLine = true;
            this.skipInitialNewLines = !this.renderer.includeFirstElementTopMargin;
            this.col = 0;
            this.listIndentLevel = 0;
            this.indentSize = 0;
            this.blockVerticalMargin = -1;
            this.preformatted = false;
            this.lastCharWhiteSpace = false;
            this.bullet = false;
        }

        private void appendElementContent(Element element) throws IOException {
            int contentEnd = element.getContentEnd();
            if (element.isEmpty() || this.renderedIndex >= contentEnd) {
                return;
            }
            int contentBegin = element.getStartTag().end;
            this.appendSegmentProcessingChildElements(Math.max(this.renderedIndex, contentBegin), contentEnd, element.getChildElements());
        }

        private void appendSegmentProcessingChildElements(int begin, int end, List<Element> childElements) throws IOException {
            int index = begin;
            for (Element childElement : childElements) {
                if (index >= childElement.end) continue;
                if (index < childElement.begin) {
                    this.appendSegmentRemovingTags(index, childElement.begin);
                }
                Processor.getElementHandler(childElement).process(this, childElement);
                index = Math.max(this.renderedIndex, childElement.end);
            }
            if (index < end) {
                this.appendSegmentRemovingTags(index, end);
            }
        }

        private static ElementHandler getElementHandler(Element element) {
            if (element.getStartTag().getStartTagType().isServerTag()) {
                return RemoveElementHandler.INSTANCE;
            }
            ElementHandler elementHandler = (ElementHandler)ELEMENT_HANDLERS.get(element.getName());
            return elementHandler != null ? elementHandler : StandardInlineElementHandler.INSTANCE;
        }

        private void appendSegmentRemovingTags(int begin, int end) throws IOException {
            Tag tag;
            int index = begin;
            while ((tag = this.source.getNextTag(index)) != null && tag.begin < end) {
                this.appendSegment(index, tag.begin);
                index = tag.end;
            }
            this.appendSegment(index, end);
        }

        private void appendSegment(int begin, int end) throws IOException {
            assert (begin <= end);
            if (begin < this.renderedIndex) {
                begin = this.renderedIndex;
            }
            if (begin >= end) {
                return;
            }
            try {
                if (this.preformatted) {
                    this.appendPreformattedSegment(begin, end);
                } else {
                    this.appendNonPreformattedSegment(begin, end);
                }
            }
            finally {
                if (this.renderedIndex < end) {
                    this.renderedIndex = end;
                }
            }
        }

        private void appendPreformattedSegment(int begin, int end) throws IOException {
            assert (begin < end);
            assert (begin >= this.renderedIndex);
            if (this.isBlockBoundary()) {
                this.appendBlockVerticalMargin();
            }
            String text = CharacterReference.decode(this.source.subSequence(begin, end), false, this.convertNonBreakingSpaces);
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                if (ch == '\n') {
                    this.newLine();
                } else if (ch == '\r') {
                    this.newLine();
                    int nextI = i + 1;
                    if (nextI == text.length()) break;
                    if (text.charAt(nextI) == '\n') {
                        ++i;
                    }
                } else {
                    this.append(ch);
                }
                ++i;
            }
        }

        private void appendNonPreformattedSegment(int begin, int end) throws IOException {
            assert (begin < end);
            assert (begin >= this.renderedIndex);
            String text = CharacterReference.decodeCollapseWhiteSpace(this.source.subSequence(begin, end), this.convertNonBreakingSpaces);
            if (text.length() == 0) {
                this.lastCharWhiteSpace = true;
                return;
            }
            this.appendNonPreformattedText(text, Segment.isWhiteSpace(this.source.charAt(begin)), Segment.isWhiteSpace(this.source.charAt(end - 1)));
        }

        private void appendText(String text) throws IOException {
            assert (text.length() > 0);
            this.appendNonPreformattedText(text, Segment.isWhiteSpace(text.charAt(0)), Segment.isWhiteSpace(text.charAt(text.length() - 1)));
        }

        private void appendNonPreformattedText(String text, boolean isWhiteSpaceAtStart, boolean isWhiteSpaceAtEnd) throws IOException {
            if (this.isBlockBoundary()) {
                this.appendBlockVerticalMargin();
            } else if (this.lastCharWhiteSpace || isWhiteSpaceAtStart) {
                this.append(' ');
            }
            int textIndex = 0;
            int i = 0;
            this.lastCharWhiteSpace = false;
            while (true) {
                if (i < text.length()) {
                    if (text.charAt(i) != ' ' || i + 1 < text.length() && text.charAt(i + 1) == '>' || i + 6 < text.length() && text.startsWith("From ", i + 1)) {
                        ++i;
                        continue;
                    }
                }
                if (this.maxLineLength > 0 && this.col + i - textIndex + 1 >= this.maxLineLength) {
                    if (this.lastCharWhiteSpace && (this.listIndentLevel | this.indentSize) == 0) {
                        this.append(' ');
                    }
                    this.startNewLine(0);
                } else if (this.lastCharWhiteSpace) {
                    this.append(' ');
                }
                this.append(text, textIndex, i);
                if (i == text.length()) break;
                this.lastCharWhiteSpace = true;
                textIndex = ++i;
            }
            this.lastCharWhiteSpace = isWhiteSpaceAtEnd;
        }

        private boolean isBlockBoundary() {
            return this.blockVerticalMargin != -1;
        }

        /*
         * Unable to fully structure code
         */
        private void appendBlockVerticalMargin() throws IOException {
            block4: {
                block2: {
                    block3: {
                        if (!Processor.$assertionsDisabled && this.blockVerticalMargin == -1) {
                            throw new AssertionError();
                        }
                        if (!this.skipInitialNewLines) break block2;
                        this.skipInitialNewLines = false;
                        indentCol = this.indentSize + this.listIndentLevel * this.listIndentSize;
                        if (this.col != indentCol) break block3;
                        this.atStartOfLine = false;
                        break block4;
                    }
                    if (!this.bullet && this.col <= indentCol) ** GOTO lbl16
                    this.startNewLine(0);
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        this.appendable.append(' ');
                        ++this.col;
lbl16:
                        // 2 sources

                        ** while (indentCol > this.col)
                    }
lbl17:
                    // 1 sources

                    this.atStartOfLine = false;
                    break block4;
                }
                this.startNewLine(this.blockVerticalMargin);
            }
            this.blockVerticalMargin = -1;
        }

        private void blockBoundary(int verticalMargin) throws IOException {
            if (this.blockVerticalMargin < verticalMargin) {
                this.blockVerticalMargin = verticalMargin;
            }
        }

        private void startNewLine(int verticalMargin) throws IOException {
            int requiredNewLines = verticalMargin + (this.atStartOfLine ? 0 : 1);
            int i = 0;
            while (i < requiredNewLines) {
                this.appendable.append(this.newLine);
                ++i;
            }
            this.atStartOfLine = true;
            this.col = 0;
        }

        private void newLine() throws IOException {
            this.appendable.append(this.newLine);
            this.atStartOfLine = true;
            this.col = 0;
        }

        private void appendTextInit() throws IOException {
            this.skipInitialNewLines = false;
            if (this.atStartOfLine) {
                this.appendIndent();
            }
        }

        private void appendIndent() throws IOException {
            int i = this.indentSize;
            while (i > 0) {
                this.appendable.append(' ');
                --i;
            }
            if (this.bullet) {
                i = (this.listIndentLevel - 1) * this.listIndentSize;
                while (i > 0) {
                    this.appendable.append(' ');
                    --i;
                }
                if (this.listBulletNumber == -1) {
                    i = this.listIndentSize - 2;
                    while (i > 0) {
                        this.appendable.append(' ');
                        --i;
                    }
                    this.appendable.append(this.listBullets[(this.listIndentLevel - 1) % this.listBullets.length]).append(' ');
                } else {
                    String bulletNumberString = Integer.toString(this.listBulletNumber);
                    int i2 = this.listIndentSize - bulletNumberString.length() - 2;
                    while (i2 > 0) {
                        this.appendable.append(' ');
                        --i2;
                    }
                    this.appendable.append(bulletNumberString).append(". ");
                }
                this.bullet = false;
            } else {
                i = this.listIndentLevel * this.listIndentSize;
                while (i > 0) {
                    this.appendable.append(' ');
                    --i;
                }
            }
            this.col = this.indentSize + this.listIndentLevel * this.listIndentSize;
            this.atStartOfLine = false;
        }

        private Processor append(char ch) throws IOException {
            this.appendTextInit();
            this.appendable.append(ch);
            ++this.col;
            return this;
        }

        private Processor append(String text) throws IOException {
            this.appendTextInit();
            this.appendable.append(text);
            this.col += text.length();
            return this;
        }

        private void append(CharSequence text, int begin, int end) throws IOException {
            this.appendTextInit();
            int i = begin;
            while (i < end) {
                this.appendable.append(text.charAt(i));
                ++i;
            }
            this.col += end - begin;
        }
    }

    private static final class RemoveElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new RemoveElementHandler();

        private RemoveElementHandler() {
        }

        @Override
        public void process(Processor x, Element element) {
        }
    }

    private static final class StandardBlockElementHandler
    extends AbstractBlockElementHandler {
        public static final ElementHandler INSTANCE_0_0 = new StandardBlockElementHandler(0, 0, false);
        public static final ElementHandler INSTANCE_1_1 = new StandardBlockElementHandler(1, 1, false);
        public static final ElementHandler INSTANCE_2_1 = new StandardBlockElementHandler(2, 1, false);
        public static final ElementHandler INSTANCE_0_0_INDENT = new StandardBlockElementHandler(0, 0, true);
        public static final ElementHandler INSTANCE_1_1_INDENT = new StandardBlockElementHandler(1, 1, true);

        private StandardBlockElementHandler(int topMargin, int bottomMargin, boolean indent) {
            super(topMargin, bottomMargin, indent);
        }

        @Override
        protected void processBlockContent(Processor x, Element element) throws IOException {
            x.appendElementContent(element);
        }

        @Override
        protected AbstractBlockElementHandler newInstance(int topMargin, int bottomMargin, boolean indent) {
            return new StandardBlockElementHandler(topMargin, bottomMargin, indent);
        }
    }

    private static final class StandardInlineElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new StandardInlineElementHandler();

        private StandardInlineElementHandler() {
        }

        @Override
        public void process(Processor x, Element element) throws IOException {
            x.appendElementContent(element);
        }
    }

    private static final class TD_ElementHandler
    implements ElementHandler {
        public static final ElementHandler INSTANCE = new TD_ElementHandler();

        private TD_ElementHandler() {
        }

        @Override
        public void process(Processor x, Element element) throws IOException {
            if (!x.isBlockBoundary()) {
                x.append(x.tableCellSeparator);
            }
            x.lastCharWhiteSpace = false;
            x.appendElementContent(element);
        }
    }
}

